/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.gallery;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URL;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.ide.wizard.spi.WizardHook;
import javax.ide.wizard.spi.WizardInfo;
import javax.swing.JDialog;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Context;
import oracle.ide.ExtensionRegistry;
import oracle.ide.Ide;
import oracle.ide.dialogs.SizeKeeperCallback;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.gallery.ElementInfo;
import oracle.ide.gallery.GalleryElement;
import oracle.ide.gallery.GalleryFolder;
import oracle.ide.gallery.GalleryHandler;
import oracle.ide.gallery.GalleryManager;
import oracle.ide.gallery.GalleryXMLDataNode;
import oracle.ide.gallery.JavaxIdeElementInfo;
import oracle.ide.gallery.ObjectGalleryAddin;
import oracle.ide.gallery.ObjectGalleryPanel;
import oracle.ide.gallery.RootGalleryFolder;
import oracle.ide.model.XMLDataNode;
import oracle.ide.net.URLFactory;
import oracle.ide.panels.TDialogLauncher;
import oracle.ide.resource.GalleryArb;
import oracle.ide.util.ModelUtil;
import oracle.ide.wizard.Wizard;
import oracle.ide.wizard.WizardManager;

public final class ObjectGallery {
    private static final String XML_FILENAME = "gallery.xml";
    private final SizeKeeperCallback _dialogCallback;
    private XMLDataNode _model;
    private Context _context;
    private JEWTFinishDialog _dlg;
    private GalleryElement _selItem;
    private ObjectGalleryPanel _panel;
    private boolean _loadedHook;

    void $init$() {
        this._dialogCallback = new SizeKeeperCallback("new.gallery");
        this._loadedHook = false;
    }

    public ObjectGallery() {
        this.$init$();
        File file = new File(Ide.getLibDirectory(), XML_FILENAME);
        URL uRL = URLFactory.newFileURL(file);
        this._model = new GalleryXMLDataNode(uRL);
    }

    public GalleryFolder getModel() {
        return (GalleryFolder)this._model.getData();
    }

    public void runDialog(Context context) {
        this.runDialog(context, null, null);
    }

    public void runDialog(Context context, String string, String string2) {
        if (this._context != null) {
            return;
        }
        this._context = context;
        if (!this._loadedHook) {
            try {
                ExtensionRegistry extensionRegistry = ExtensionRegistry.getOracleRegistry();
                GalleryHandler galleryHandler = (GalleryHandler)extensionRegistry.getIdeHook(GalleryHandler.ELEMENT);
                GalleryManager galleryManager = GalleryManager.getGalleryManager();
                ((ObjectGalleryAddin)galleryManager).registerFolders(galleryHandler.getFolders());
                Set set = galleryHandler.getItems();
                for (ElementInfo elementInfo : set) {
                    galleryManager.registerGalleryElement(elementInfo);
                }
                WizardHook wizardHook = (WizardHook)ExtensionRegistry.getExtensionRegistry().getHook(WizardHook.ELEMENT);
                Collection collection = wizardHook.getAllWizardClasses();
                Iterator iterator = collection.iterator();
                while (iterator.hasNext()) {
                    WizardInfo wizardInfo = wizardHook.getWizardInfo((String)iterator.next());
                    galleryManager.registerGalleryElement(new JavaxIdeElementInfo(wizardInfo));
                }
            }
            finally {
                this._loadedHook = true;
            }
        }
        try {
            this._model.open();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return;
        }
        this._dlg = new JEWTFinishDialog((Frame)((Object)Ide.getMainWindow()), GalleryArb.getString(6), 7);
        this.flushPendingGalleryItems();
        RootGalleryFolder rootGalleryFolder = (RootGalleryFolder)this._model.getData();
        EventAdapter eventAdapter = new EventAdapter(null);
        this._panel = new ObjectGalleryPanel(rootGalleryFolder, context);
        this._panel.listItem.addListSelectionListener(eventAdapter);
        this._panel.addActionListener(eventAdapter);
        this._dlg.setOKButtonEnabled(false);
        this._dlg.setContent(this._panel);
        this._dlg.setResizable(true);
        this._panel.setContext(context);
        this._panel.setInitialSelection(string, string2);
        this._dlg.setPreferredSize(TDialogLauncher.getPreferredDefaultInitialSize());
        this._dlg.setInitialFocus(this._panel.treeCat);
        this.setCanAdvance();
        this._dialogCallback.dialogAboutToRun((JDialog)((Object)this._dlg));
        boolean bl = WizardLauncher.runDialog((JDialog)((Object)this._dlg));
        rootGalleryFolder.setMainDividerLocation(this._panel.getMainDividerLocation());
        rootGalleryFolder.setItemDividerLocation(this._panel.getItemDividerLocation());
        if (bl) {
            this.invokeWizard(this._selItem);
        }
        this._context = null;
        this._dlg = null;
        this._selItem = null;
        this._panel = null;
    }

    static final boolean isWizardAvailable(Wizard wizard, Context context) {
        if (wizard != null) {
            try {
                boolean bl = wizard.isAvailable(context);
                return bl;
            }
            catch (ThreadDeath threadDeath) {
                throw threadDeath;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
        return false;
    }

    private void invokeWizard(GalleryElement galleryElement) {
        if (this._selItem != null && this._selItem.getWizard() != null) {
            GalleryElement galleryElement2 = galleryElement;
            Context context = this._context;
            Wizard wizard = galleryElement2.getWizard();
            if (wizard != null) {
                String[] stringArray = galleryElement2.getWizardParameters();
                String[] stringArray2 = galleryElement2.getTechnologyKeys();
                WizardManager.getInstance().invokeSecondaryWizard(wizard, context, stringArray, stringArray2);
            }
        }
    }

    private final void setCanAdvance() {
        try {
            try {
                GalleryElement galleryElement;
                this._selItem = galleryElement = (GalleryElement)this._panel.listItem.getSelectedValue();
            }
            catch (Exception exception) {
                this._selItem = null;
            }
        }
        catch (Throwable throwable) {
            Wizard wizard = this._selItem != null ? this._selItem.getWizard() : null;
            this._dlg.setOKButtonEnabled(ObjectGallery.isWizardAvailable(wizard, this._context));
            throw throwable;
        }
        Wizard wizard = this._selItem != null ? this._selItem.getWizard() : null;
        this._dlg.setOKButtonEnabled(ObjectGallery.isWizardAvailable(wizard, this._context));
    }

    private static ObjectGalleryAddin getObjectGalleryAddin() {
        GalleryManager galleryManager = GalleryManager.getGalleryManager();
        if (galleryManager instanceof ObjectGalleryAddin) {
            return (ObjectGalleryAddin)galleryManager;
        }
        return null;
    }

    private void flushPendingGalleryItems() {
        String string;
        ObjectGalleryAddin objectGalleryAddin = ObjectGallery.getObjectGalleryAddin();
        if (objectGalleryAddin != null) {
            objectGalleryAddin.addPendingGalleryItems();
            objectGalleryAddin.removePendingGalleryItems();
        }
        if (ModelUtil.hasLength((String)(string = System.getProperty("jdev.debug.technology.log")))) {
            PrintStream printStream;
            if (string.equals("System.out")) {
                printStream = System.out;
            } else if (string.equals("System.err")) {
                printStream = System.err;
            } else {
                try {
                    printStream = new PrintStream(new FileOutputStream(string));
                }
                catch (FileNotFoundException fileNotFoundException) {
                    System.err.println("ERROR opening technology log: " + string);
                    return;
                }
            }
            GalleryFolder galleryFolder = this.getModel();
            if (galleryFolder != null) {
                TreeMap treeMap = new TreeMap();
                printStream.println();
                printStream.println("Technologies By Item");
                printStream.println("--------------------");
                galleryFolder.debugLogTechnologies(printStream, null, treeMap);
                printStream.println();
                printStream.println("Items By Technology");
                printStream.println("-------------------");
                for (Map.Entry entry : treeMap.entrySet()) {
                    String string2 = (String)entry.getKey();
                    printStream.println();
                    printStream.println(string2 + ":");
                    List list = (List)entry.getValue();
                    Iterator iterator = list.iterator();
                    while (iterator.hasNext()) {
                        printStream.println("  " + (String)iterator.next());
                    }
                }
            }
        }
    }

    static void mav$setCanAdvance(ObjectGallery objectGallery) {
        objectGallery.setCanAdvance();
    }

    static GalleryElement ra$_selItem(ObjectGallery objectGallery) {
        return objectGallery._selItem;
    }

    static Context ra$_context(ObjectGallery objectGallery) {
        return objectGallery._context;
    }

    static JEWTFinishDialog ra$_dlg(ObjectGallery objectGallery) {
        return objectGallery._dlg;
    }

    private final class EventAdapter
    implements ListSelectionListener,
    ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            Wizard wizard;
            if (ObjectGallery.ra$_selItem(ObjectGallery.this) != null && ObjectGallery.isWizardAvailable(wizard = ObjectGallery.ra$_selItem(ObjectGallery.this).getWizard(), ObjectGallery.ra$_context(ObjectGallery.this))) {
                ObjectGallery.ra$_dlg(ObjectGallery.this).finish();
            }
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            ObjectGallery.mav$setCanAdvance(ObjectGallery.this);
        }

        private EventAdapter() {
        }

        EventAdapter(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private static final class JEWTFinishDialog
    extends JEWTDialog {
        public JEWTFinishDialog(Frame frame, String string, int n) {
            super(frame, string, n);
            this.setSize(600, 400);
        }

        public void finish() {
            this.dismissDialog(false);
        }
    }
}

