/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.gallery;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import javax.swing.JMenuItem;
import oracle.ide.Context;
import oracle.ide.ExtensionRegistry;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuConstants;
import oracle.ide.controller.MenuManager;
import oracle.ide.controller.Menubar;
import oracle.ide.gallery.ElementInfo;
import oracle.ide.gallery.FolderInfo;
import oracle.ide.gallery.GalleryFolder;
import oracle.ide.gallery.GalleryHandler;
import oracle.ide.gallery.GalleryManager;
import oracle.ide.gallery.ObjectGallery;
import oracle.ide.gallery.RootGalleryFolder;
import oracle.ide.keyboard.KeyStrokeContextRegistry;
import oracle.ide.model.Element;
import oracle.ide.navigator.NavigatorConstants;
import oracle.ide.navigator.NavigatorManager;
import oracle.ide.navigator.NavigatorWindow;
import oracle.ide.resource.GalleryArb;

final class ObjectGalleryAddin
extends GalleryManager
implements ContextMenuListener,
Controller {
    public static final int OBJECT_GALLERY_CMD_ID = Ide.findOrCreateCmdID("ObjectGalleryCommand");
    public static final String OBJECT_GALLERY_CMD = "oracle.ide.cmd.ObjectGalleryCommand";
    private ObjectGallery _gallery;
    private IdeAction _galleryMenuAction;
    private Collection _galleryAddItems;
    private Collection _galleryRemoveItems;
    private Properties _pendingProperties;
    private Collection _foldersAdd;
    private boolean _extGeneratorsLoaded;

    void $init$() {
        this._extGeneratorsLoaded = false;
    }

    public ObjectGalleryAddin() {
        this.$init$();
    }

    public synchronized ObjectGallery getGallery() {
        if (this._gallery == null) {
            this._gallery = new ObjectGallery();
        }
        return this._gallery;
    }

    public void registerGalleryElement(ElementInfo elementInfo) {
        if (this._galleryAddItems == null) {
            this._galleryAddItems = new ArrayList();
        }
        if (!this.removeFromQueue(this._galleryRemoveItems, elementInfo)) {
            this._galleryAddItems.add(elementInfo);
        }
    }

    public void unregisterGalleryElement(ElementInfo elementInfo) {
        if (this._galleryRemoveItems == null) {
            this._galleryRemoveItems = new ArrayList();
        }
        if (!this.removeFromQueue(this._galleryAddItems, elementInfo)) {
            this._galleryRemoveItems.add(elementInfo);
        }
    }

    public Properties getBuilderProperties() {
        if (!this._extGeneratorsLoaded) {
            ExtensionRegistry extensionRegistry = ExtensionRegistry.getOracleRegistry();
            GalleryHandler galleryHandler = (GalleryHandler)extensionRegistry.getIdeHook(GalleryHandler.ELEMENT);
            this.registerBuilderProperties(galleryHandler.getGenerators());
            this._extGeneratorsLoaded = true;
        }
        if (this._pendingProperties != null) {
            if (this.getRootFolder().getGenerators() != null) {
                this._pendingProperties.putAll((Map<?, ?>)this.getRootFolder().getGenerators());
            }
            this.getRootFolder().setGenerators(this._pendingProperties);
            this._pendingProperties = null;
        }
        return this.getRootFolder().getGenerators();
    }

    void registerBuilderProperties(Properties properties) {
        if (this._pendingProperties == null) {
            this._pendingProperties = new Properties();
        }
        this._pendingProperties.putAll((Map<?, ?>)properties);
    }

    void registerFolders(Collection collection) {
        if (this._foldersAdd == null) {
            this._foldersAdd = new LinkedHashSet();
        }
        this._foldersAdd.addAll(collection);
    }

    public void initialize() {
        GalleryManager.setGalleryManager(this);
        Menubar menubar = Ide.getMenubar();
        this._galleryMenuAction = IdeAction.get(OBJECT_GALLERY_CMD_ID, OBJECT_GALLERY_CMD, GalleryArb.getString(3), IdeMainWindow.ACTION_CATEGORY_FILE, GalleryArb.getInteger(4), GalleryArb.getInstance(), 5, (Object)this, true);
        this._galleryMenuAction.addController(this);
        JMenuItem jMenuItem = menubar.createMenuItem(this._galleryMenuAction, 1.0f);
        menubar.add(jMenuItem, MenuManager.getJMenu("File"), 1.0f);
        KeyStrokeContextRegistry keyStrokeContextRegistry = Ide.getKeyStrokeContextRegistry();
        keyStrokeContextRegistry.addAcceleratorDefinitionFile(this.getClass().getClassLoader(), "oracle/ide/gallery/accelerators.xml");
        NavigatorConstants.New = menubar.createMenuItem(this._galleryMenuAction, MenuConstants.WEIGHT_FILE_NEW_GALLERY);
        NavigatorManager.getWorkspaceNavigatorManager().addContextMenuListener(this, null);
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        int n = ideAction.getCommandId();
        if (n == OBJECT_GALLERY_CMD_ID) {
            this._invokeGallery(context);
            return true;
        }
        return false;
    }

    public boolean update(IdeAction ideAction, Context context) {
        int n = ideAction.getCommandId();
        if (n == OBJECT_GALLERY_CMD_ID) {
            ideAction.setEnabled(true);
            return true;
        }
        return false;
    }

    public void menuWillShow(ContextMenu contextMenu) {
        Element element;
        Context context = contextMenu.getContext();
        if (context != null && context.getView() instanceof NavigatorWindow && (element = context.getElement()) != null && element.mayHaveChildren()) {
            contextMenu.add((Component)NavigatorConstants.New, 1.0f);
        }
    }

    public void menuWillHide(ContextMenu contextMenu) {
    }

    public boolean handleDefaultAction(Context context) {
        return false;
    }

    protected void addPendingGalleryItems() {
        if (this._galleryAddItems != null) {
            for (ElementInfo elementInfo : this._galleryAddItems) {
                try {
                    this.addGalleryElement(elementInfo);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            this._galleryAddItems = null;
        }
    }

    protected void removePendingGalleryItems() {
        if (this._galleryRemoveItems != null) {
            for (ElementInfo elementInfo : this._galleryRemoveItems) {
                this.removeGalleryElement(elementInfo);
            }
            this._galleryRemoveItems = null;
        }
    }

    private RootGalleryFolder getRootFolder() {
        this.addFolders();
        return (RootGalleryFolder)this.getGallery().getModel();
    }

    private void addFolders() {
        RootGalleryFolder rootGalleryFolder = (RootGalleryFolder)this.getGallery().getModel();
        if (this._foldersAdd != null) {
            for (FolderInfo folderInfo : this._foldersAdd) {
                GalleryFolder galleryFolder = folderInfo.getCategory() == null ? rootGalleryFolder.createFolder(folderInfo.getName()) : rootGalleryFolder.createFolder(new String[]{folderInfo.getCategory(), folderInfo.getName()});
                galleryFolder.setUnsorted(folderInfo.isUnsorted());
            }
            this._foldersAdd = null;
        }
    }

    private boolean addGalleryElement(ElementInfo elementInfo) {
        RootGalleryFolder rootGalleryFolder = this.getRootFolder();
        GalleryFolder galleryFolder = rootGalleryFolder.createFolder(elementInfo.getPath());
        return galleryFolder.addElement(elementInfo);
    }

    private boolean removeGalleryElement(ElementInfo elementInfo) {
        RootGalleryFolder rootGalleryFolder = this.getRootFolder();
        GalleryFolder galleryFolder = rootGalleryFolder.getFolder(elementInfo.getPath());
        if (galleryFolder == null) {
            return false;
        }
        return galleryFolder.removeElement(elementInfo);
    }

    private void _invokeGallery(Context context) {
        this.getGallery().runDialog(context);
    }

    private boolean removeFromQueue(Collection collection, ElementInfo elementInfo) {
        if (collection == null) {
            return false;
        }
        boolean bl = false;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            ElementInfo elementInfo2 = (ElementInfo)iterator.next();
            if (!elementInfo2.equals(elementInfo)) continue;
            iterator.remove();
            bl = true;
        }
        return bl;
    }
}

