/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.gallery;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.border.Border;
import javax.swing.event.EventListenerList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.controls.DescriptionScrollPane;
import oracle.ide.gallery.GalleryElement;
import oracle.ide.gallery.GalleryFolder;
import oracle.ide.gallery.RootGalleryFolder;
import oracle.ide.help.HelpSystem;
import oracle.ide.model.Project;
import oracle.ide.model.TechnologyScope;
import oracle.ide.model.TechnologyScopeConfiguration;
import oracle.ide.nulls.NullIcon;
import oracle.ide.resource.GalleryArb;
import oracle.ide.util.ModelUtil;
import oracle.ide.util.ResourceUtils;
import oracle.ide.wizard.Wizard;
import oracle.javatools.border.JavatoolsBorderFactory;

final class ObjectGalleryPanel
extends JPanel {
    private static final Icon NULL_ICON = new NullIcon();
    private static final double MAIN_SPLITTER_RESIZE_WEIGHT = 0.33;
    private static final double ITEM_SPLITTER_RESIZE_WEIGHT = 0.65;
    private static final String HELP_ID = "f1_idenewobjectgallery_html";
    private static final Border UNDERLINE_BORDER = BorderFactory.createCompoundBorder(JavatoolsBorderFactory.createBottomBorder((Color)SystemColor.controlShadow), BorderFactory.createEmptyBorder(1, 2, 1, 2));
    final JLabel lblFilter;
    final JComboBox comboFilter;
    final JSplitPane splitPane;
    final JSplitPane itemSplitPane;
    final JLabel lblCat;
    final JLabel lblItems;
    final JLabel lblDescription;
    final JScrollPane jspTreeCat;
    final JScrollPane jspListItems;
    final DescriptionScrollPane jspDescription;
    final JTree treeCat;
    final JList listItem;
    final GridBagLayout gridBagLayout1;
    private RootGalleryFolder _model;
    private Context _context;
    private boolean _explicitInitialSel;
    private TreeModel _treeModel;

    void $init$() {
        this.lblFilter = new JLabel();
        this.comboFilter = new JComboBox();
        this.splitPane = new JSplitPane(1, true);
        this.itemSplitPane = new JSplitPane(0, true);
        this.lblCat = new JLabel();
        this.lblItems = new JLabel();
        this.lblDescription = new JLabel();
        this.jspTreeCat = new JScrollPane();
        this.jspListItems = new JScrollPane();
        this.jspDescription = new DescriptionScrollPane();
        this.treeCat = new JTree();
        this.listItem = new JList();
        this.gridBagLayout1 = new GridBagLayout();
    }

    ObjectGalleryPanel(RootGalleryFolder rootGalleryFolder, Context context) {
        this.$init$();
        this._context = context;
        try {
            this._model = rootGalleryFolder;
            this.jbInit();
            this.postInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(this.gridBagLayout1);
        this.setPreferredSize(new Dimension(450, 300));
        ResourceUtils.resLabel(this.lblFilter, this.comboFilter, GalleryArb.getString(11));
        ResourceUtils.resLabel(this.lblCat, this.treeCat, GalleryArb.getString(7));
        ResourceUtils.resLabel(this.lblItems, this.listItem, GalleryArb.getString(8));
        ResourceUtils.resLabel(this.lblDescription, this.jspDescription.getLabelComponent(), GalleryArb.getString(9));
        this.treeCat.setExpandsSelectedPaths(true);
        this.treeCat.setRootVisible(false);
        this.treeCat.setShowsRootHandles(true);
        this.treeCat.getSelectionModel().setSelectionMode(1);
        this.listItem.setSelectionMode(0);
        this.lblCat.setBorder(UNDERLINE_BORDER);
        this.lblItems.setBorder(UNDERLINE_BORDER);
        this.lblDescription.setBorder(UNDERLINE_BORDER);
        this.jspTreeCat.setBorder(null);
        this.jspListItems.setBorder(null);
        this.jspDescription.setBorder(null);
        this.itemSplitPane.setBorder(null);
        this.jspDescription.setMinimumSize(new Dimension(32, 16));
        this.jspDescription.setHorizontalScrollBarPolicy(31);
        this.splitPane.setResizeWeight(0.33);
        this.itemSplitPane.setResizeWeight(0.65);
        this.jspTreeCat.setColumnHeaderView(this.lblCat);
        this.jspTreeCat.setViewportView(this.treeCat);
        this.jspListItems.setColumnHeaderView(this.lblItems);
        this.jspListItems.setViewportView(this.listItem);
        this.jspDescription.setColumnHeaderView(this.lblDescription);
        this.itemSplitPane.setTopComponent(this.jspListItems);
        this.itemSplitPane.setBottomComponent(this.jspDescription);
        this.splitPane.setLeftComponent(this.jspTreeCat);
        this.splitPane.setRightComponent(this.itemSplitPane);
        this.add((Component)this.lblFilter, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 12), 0, 0));
        this.add((Component)this.comboFilter, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 12), 0, 0));
        this.add((Component)this.splitPane, new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    private void postInit() {
        EventListener eventListener = new EventListener(null);
        this.addHierarchyListener(eventListener);
        this.comboFilter.addItemListener(eventListener);
        this.listItem.addListSelectionListener(eventListener);
        this.listItem.addMouseListener(eventListener);
        this.treeCat.addTreeSelectionListener(eventListener);
        this.treeCat.addTreeExpansionListener(eventListener);
        this.treeCat.setCellRenderer(new CategoryTreeCellRenderer(null));
        this.listItem.setCellRenderer(new ItemListCellRenderer(null));
        this.initFilterCombo();
        this.rebuildGallery();
        ToolTipManager.sharedInstance().registerComponent(this.treeCat);
        HelpSystem helpSystem = HelpSystem.getHelpSystem();
        if (helpSystem != null) {
            helpSystem.registerTopic(this, HELP_ID);
        }
    }

    private TreeModel createTreeModel() {
        GalleryTreeNode galleryTreeNode = new GalleryTreeNode(this._model);
        this._treeModel = new DefaultTreeModel(galleryTreeNode);
        return this._treeModel;
    }

    private void initFilterCombo() {
        DefaultComboBoxModel<FilterChoice> defaultComboBoxModel = new DefaultComboBoxModel<FilterChoice>();
        if (this.hasProjectContext()) {
            if (this.hasProjectScope()) {
                defaultComboBoxModel.addElement(ProjectFilterChoice.PROJECT_TECHNOLOGIES);
            }
            defaultComboBoxModel.addElement(ProjectFilterChoice.ALL_TECHNOLOGIES);
        } else {
            defaultComboBoxModel.addElement(GlobalFilterChoice.AVAILABLE_ITEMS);
            defaultComboBoxModel.addElement(GlobalFilterChoice.ALL_ITEMS);
        }
        this.comboFilter.setModel(defaultComboBoxModel);
    }

    private GalleryFolder getGalleryFolder(TreePath treePath) {
        if (treePath == null) {
            return null;
        }
        Object object = treePath.getLastPathComponent();
        if (!(object instanceof GalleryTreeNode)) {
            return null;
        }
        GalleryTreeNode galleryTreeNode = (GalleryTreeNode)object;
        return GalleryTreeNode.mav$getGalleryFolder(galleryTreeNode);
    }

    private void restoreTreeExpansion() {
        boolean bl = this.isAllScope() ^ true;
        GalleryTreeNode galleryTreeNode = this.getRoot();
        Enumeration<TreeNode> enumeration = galleryTreeNode.breadthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            GalleryTreeNode galleryTreeNode2 = (GalleryTreeNode)enumeration.nextElement();
            GalleryFolder galleryFolder = GalleryTreeNode.mav$getGalleryFolder(galleryTreeNode2);
            if (!bl && !galleryFolder.isExpanded()) continue;
            this.treeCat.expandPath(new TreePath(galleryTreeNode2.getPath()));
        }
    }

    private void restoreTreeSelection(TreePath treePath) {
        GalleryFolder galleryFolder = this.getGalleryFolder(treePath);
        GalleryTreeNode galleryTreeNode = this.getRoot();
        Enumeration<TreeNode> enumeration = galleryTreeNode.breadthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            GalleryTreeNode galleryTreeNode2 = (GalleryTreeNode)enumeration.nextElement();
            if (galleryFolder != galleryTreeNode2.getUserObject()) continue;
            this.treeCat.setSelectionPath(new TreePath(galleryTreeNode2.getPath()));
            return;
        }
        this.treeCat.setSelectionRow(0);
    }

    private GalleryTreeNode getRoot() {
        return (GalleryTreeNode)this._treeModel.getRoot();
    }

    public void setContext(Context context) {
        this._context = context;
    }

    public void setInitialSelection(String string) {
        this.setInitialSelection(null, string);
    }

    protected void setInitialSelection(String string, String string2) {
        GalleryTreeNode galleryTreeNode = this.getRoot();
        if (string != null) {
            this._explicitInitialSel = true;
            Enumeration<TreeNode> enumeration = galleryTreeNode.breadthFirstEnumeration();
            while (enumeration.hasMoreElements()) {
                GalleryTreeNode galleryTreeNode2 = (GalleryTreeNode)enumeration.nextElement();
                GalleryFolder galleryFolder = (GalleryFolder)galleryTreeNode2.getUserObject();
                if (!string.equals(galleryFolder.getName())) continue;
                this.treeCat.setSelectionPath(new TreePath(galleryTreeNode2.getPath()));
                if (this.listItem.getModel().getSize() > 0) {
                    this.listItem.setSelectedIndex(0);
                }
                galleryTreeNode = galleryTreeNode2;
                break;
            }
        }
        if (string2 != null) {
            this._explicitInitialSel = true;
            Enumeration<TreeNode> enumeration = galleryTreeNode.breadthFirstEnumeration();
            while (enumeration.hasMoreElements()) {
                GalleryTreeNode galleryTreeNode3 = (GalleryTreeNode)enumeration.nextElement();
                GalleryFolder galleryFolder = (GalleryFolder)galleryTreeNode3.getUserObject();
                GalleryElement[] galleryElementArray = galleryFolder.getElementChildren();
                int n = 0;
                while (n < galleryElementArray.length) {
                    GalleryElement galleryElement = galleryElementArray[n];
                    String string3 = galleryElement.getWizardClass();
                    if (string2.equals(string3)) {
                        this.treeCat.setSelectionPath(new TreePath(galleryTreeNode3.getPath()));
                        this.listItem.setSelectedValue(galleryElement, true);
                        return;
                    }
                    ++n;
                }
            }
        }
    }

    void addActionListener(ActionListener actionListener) {
        this.listenerList.add(ActionListener.class, actionListener);
    }

    void removeActionListener(ActionListener actionListener) {
        this.listenerList.remove(ActionListener.class, actionListener);
    }

    int getMainDividerLocation() {
        return this.splitPane.getDividerLocation();
    }

    int getItemDividerLocation() {
        return this.itemSplitPane.getDividerLocation();
    }

    private boolean isAllScope() {
        FilterChoice filterChoice = (FilterChoice)this.comboFilter.getSelectedItem();
        return filterChoice == ProjectFilterChoice.ALL_TECHNOLOGIES || filterChoice == GlobalFilterChoice.ALL_ITEMS;
    }

    private TechnologyScope getScope() {
        return !this.isAllScope() ? this.getProjectScope() : null;
    }

    private TechnologyScope getProjectScope() {
        if (this._context == null) {
            return null;
        }
        Project project = this._context.getProject();
        return project != null ? TechnologyScopeConfiguration.getInstance(project).getTechnologyScope() : null;
    }

    private boolean hasProjectScope() {
        TechnologyScope technologyScope = this.getProjectScope();
        return technologyScope != null && !technologyScope.isEmpty();
    }

    private boolean hasProjectContext() {
        return this._context != null && this._context.getProject() != null;
    }

    private void rebuildGallery() {
        int n;
        this.treeCat.setModel(this.createTreeModel());
        if (this.treeCat.getRowCount() > 0) {
            this.restoreTreeExpansion();
            TreePath treePath = this._model.getSelectedCategoryPath();
            if (treePath != null) {
                this.restoreTreeSelection(treePath);
            } else {
                this.treeCat.setSelectionRow(0);
            }
        }
        if ((n = this.listItem.getModel().getSize()) > 0) {
            int n2 = this._model.getLastSelItem();
            n2 = Math.min(Math.max(0, n2), n - 1);
            this.listItem.setSelectedIndex(n2);
        }
    }

    static Context ra$_context(ObjectGalleryPanel objectGalleryPanel) {
        return objectGalleryPanel._context;
    }

    static Icon ra$NULL_ICON() {
        return NULL_ICON;
    }

    static EventListenerList ra$listenerList(ObjectGalleryPanel objectGalleryPanel) {
        return objectGalleryPanel.listenerList;
    }

    static GalleryFolder mav$getGalleryFolder(ObjectGalleryPanel objectGalleryPanel, TreePath treePath) {
        return objectGalleryPanel.getGalleryFolder(treePath);
    }

    static boolean ra$_explicitInitialSel(ObjectGalleryPanel objectGalleryPanel) {
        return objectGalleryPanel._explicitInitialSel;
    }

    static RootGalleryFolder ra$_model(ObjectGalleryPanel objectGalleryPanel) {
        return objectGalleryPanel._model;
    }

    static boolean mav$isAllScope(ObjectGalleryPanel objectGalleryPanel) {
        return objectGalleryPanel.isAllScope();
    }

    static void mav$rebuildGallery(ObjectGalleryPanel objectGalleryPanel) {
        objectGalleryPanel.rebuildGallery();
    }

    static boolean mav$hasProjectContext(ObjectGalleryPanel objectGalleryPanel) {
        return objectGalleryPanel.hasProjectContext();
    }

    static TechnologyScope mav$getScope(ObjectGalleryPanel objectGalleryPanel) {
        return objectGalleryPanel.getScope();
    }

    private final class ItemListCellRenderer
    extends DefaultListCellRenderer {
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            GalleryElement galleryElement = (GalleryElement)object;
            boolean bl3 = galleryElement.isAvailable(ObjectGalleryPanel.ra$_context(ObjectGalleryPanel.this));
            Icon icon = galleryElement.getIcon();
            Icon icon2 = galleryElement.getDisabledIcon();
            this.setIcon(icon != null ? icon : ObjectGalleryPanel.ra$NULL_ICON());
            this.setDisabledIcon(icon2 != null ? icon2 : ObjectGalleryPanel.ra$NULL_ICON());
            this.setText(galleryElement.getShortLabel());
            this.setToolTipText(galleryElement.getToolTipText());
            this.setEnabled(bl3 && jList.isEnabled());
            return this;
        }

        private ItemListCellRenderer() {
        }

        ItemListCellRenderer(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private static final class CategoryTreeCellRenderer
    extends DefaultTreeCellRenderer {
        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            this.setIcon(null);
            this.setToolTipText(this.getText());
            return this;
        }

        private CategoryTreeCellRenderer() {
        }

        CategoryTreeCellRenderer(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }

    private final class EventListener
    implements TreeSelectionListener,
    TreeExpansionListener,
    MouseListener,
    ListSelectionListener,
    ItemListener,
    HierarchyListener {
        public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
            ObjectGalleryPanel objectGalleryPanel;
            if ((hierarchyEvent.getChangeFlags() & (long)4) != 0L && (objectGalleryPanel = (ObjectGalleryPanel)hierarchyEvent.getSource()).isShowing()) {
                int n = ObjectGalleryPanel.ra$_model(ObjectGalleryPanel.this).getMainDividerLocation();
                if (n != 0) {
                    ObjectGalleryPanel.this.splitPane.setDividerLocation(n);
                } else {
                    ObjectGalleryPanel.this.splitPane.setDividerLocation(ObjectGalleryPanel.this.splitPane.getResizeWeight());
                }
                int n2 = ObjectGalleryPanel.ra$_model(ObjectGalleryPanel.this).getItemDividerLocation();
                if (n2 != 0) {
                    ObjectGalleryPanel.this.itemSplitPane.setDividerLocation(n2);
                } else {
                    ObjectGalleryPanel.this.itemSplitPane.setDividerLocation(ObjectGalleryPanel.this.itemSplitPane.getResizeWeight());
                }
                ObjectGalleryPanel.this.removeHierarchyListener(this);
            }
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getStateChange() == 1) {
                ObjectGalleryPanel.mav$rebuildGallery(ObjectGalleryPanel.this);
            }
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            int n = ObjectGalleryPanel.this.listItem.getSelectedIndex();
            if (!ObjectGalleryPanel.ra$_explicitInitialSel(ObjectGalleryPanel.this)) {
                ObjectGalleryPanel.ra$_model(ObjectGalleryPanel.this).setLastSelItem(n);
            }
            int n2 = ObjectGalleryPanel.this.listItem.getModel().getSize();
            if (n >= 0 && n < n2) {
                String string;
                Object e = ObjectGalleryPanel.this.listItem.getModel().getElementAt(n);
                if (e instanceof GalleryElement) {
                    GalleryElement galleryElement = (GalleryElement)e;
                    string = galleryElement.getLongLabel();
                } else {
                    string = null;
                }
                ObjectGalleryPanel.this.jspDescription.setText(string);
            } else {
                ObjectGalleryPanel.this.jspDescription.setText(null);
            }
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            Object e;
            if (mouseEvent.getClickCount() == 2 && (e = ObjectGalleryPanel.this.listItem.getSelectedValue()) instanceof GalleryElement) {
                GalleryElement galleryElement = (GalleryElement)e;
                Wizard wizard = galleryElement.getWizard();
                if (wizard != null) {
                    this.fireActionPerformed(wizard);
                } else {
                    String string = GalleryArb.getString(1);
                    boolean bl = false;
                    String string2 = GalleryArb.getString(0);
                    IdeMainWindow ideMainWindow = Ide.getMainWindow();
                    JOptionPane.showMessageDialog((Component)((Object)ideMainWindow), string, string2, 0);
                }
            }
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }

        public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
            if (ObjectGalleryPanel.mav$isAllScope(ObjectGalleryPanel.this)) {
                GalleryFolder galleryFolder = ObjectGalleryPanel.mav$getGalleryFolder(ObjectGalleryPanel.this, treeExpansionEvent.getPath());
                galleryFolder.setExpanded(true);
            }
        }

        public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
            if (ObjectGalleryPanel.mav$isAllScope(ObjectGalleryPanel.this)) {
                GalleryFolder galleryFolder = ObjectGalleryPanel.mav$getGalleryFolder(ObjectGalleryPanel.this, treeExpansionEvent.getPath());
                galleryFolder.setExpanded(false);
            }
        }

        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            TreePath treePath = ObjectGalleryPanel.this.treeCat.getSelectionPath();
            GalleryFolder galleryFolder = ObjectGalleryPanel.mav$getGalleryFolder(ObjectGalleryPanel.this, treePath);
            ObjectGalleryPanel.this.listItem.setModel(new GalleryListModel(galleryFolder));
            if (!ObjectGalleryPanel.this.treeCat.isShowing()) {
                return;
            }
            if (ObjectGalleryPanel.this.listItem.getModel().getSize() > 0) {
                ObjectGalleryPanel.this.listItem.setSelectedIndex(0);
            }
            if (!ObjectGalleryPanel.ra$_explicitInitialSel(ObjectGalleryPanel.this)) {
                ObjectGalleryPanel.ra$_model(ObjectGalleryPanel.this).setSelectedCategoryPath(treePath);
                ObjectGalleryPanel.ra$_model(ObjectGalleryPanel.this).setLastSelItem(ObjectGalleryPanel.this.listItem.getSelectedIndex());
            }
        }

        private void fireActionPerformed(Wizard wizard) {
            Object[] objectArray = ObjectGalleryPanel.ra$listenerList(ObjectGalleryPanel.this).getListenerList();
            ActionEvent actionEvent = null;
            String string = "ITEM_INVOKED";
            int n = objectArray.length - 2;
            while (n >= 0) {
                if (objectArray[n] == ActionListener.class) {
                    if (actionEvent == null) {
                        actionEvent = new ActionEvent(wizard, 1001, string, 0);
                    }
                    ((ActionListener)objectArray[n + 1]).actionPerformed(actionEvent);
                }
                n -= 2;
            }
        }

        private EventListener() {
        }

        EventListener(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private final class GalleryTreeNode
    extends DefaultMutableTreeNode {
        public GalleryTreeNode(GalleryFolder galleryFolder) {
            super(galleryFolder);
            Object[] objectArray = galleryFolder.getFolderChildren();
            Arrays.sort(objectArray);
            int n = 0;
            while (n < objectArray.length) {
                Object object = objectArray[n];
                if (this.isAvailable((GalleryFolder)object)) {
                    this.add(new GalleryTreeNode((GalleryFolder)object));
                }
                ++n;
            }
        }

        private boolean isAvailable(GalleryFolder galleryFolder) {
            if (ObjectGalleryPanel.mav$isAllScope(ObjectGalleryPanel.this)) {
                return true;
            }
            return ObjectGalleryPanel.mav$hasProjectContext(ObjectGalleryPanel.this) ? galleryFolder.isInScope(ObjectGalleryPanel.mav$getScope(ObjectGalleryPanel.this)) : galleryFolder.isAvailable(ObjectGalleryPanel.ra$_context(ObjectGalleryPanel.this));
        }

        private GalleryFolder getGalleryFolder() {
            return (GalleryFolder)this.getUserObject();
        }

        static GalleryFolder mav$getGalleryFolder(GalleryTreeNode galleryTreeNode) {
            return galleryTreeNode.getGalleryFolder();
        }
    }

    private final class GalleryListModel
    extends AbstractListModel {
        final List elements;

        public GalleryListModel(GalleryFolder galleryFolder) {
            if (galleryFolder != null) {
                GalleryElement[] galleryElementArray = galleryFolder.getElementChildren();
                this.elements = new ArrayList(galleryElementArray.length);
                int n = 0;
                while (n < galleryElementArray.length) {
                    GalleryElement galleryElement = galleryElementArray[n];
                    try {
                        if (ModelUtil.hasLength((String)galleryElement.getShortLabel()) && this.isAvailable(galleryElement)) {
                            this.elements.add(galleryElement);
                        }
                    }
                    catch (RuntimeException runtimeException) {
                        runtimeException.printStackTrace();
                    }
                    ++n;
                }
                Collections.sort(this.elements);
            } else {
                this.elements = Collections.EMPTY_LIST;
            }
        }

        public int getSize() {
            return this.elements.size();
        }

        public Object getElementAt(int n) {
            return this.elements.get(n);
        }

        private boolean isAvailable(GalleryElement galleryElement) {
            if (ObjectGalleryPanel.mav$isAllScope(ObjectGalleryPanel.this)) {
                return true;
            }
            return ObjectGalleryPanel.mav$hasProjectContext(ObjectGalleryPanel.this) ? galleryElement.isInScope(ObjectGalleryPanel.mav$getScope(ObjectGalleryPanel.this)) : galleryElement.isAvailable(ObjectGalleryPanel.ra$_context(ObjectGalleryPanel.this));
        }
    }

    private static class FilterChoice {
        private final String _name;

        protected FilterChoice(String string) {
            this._name = string;
        }

        public String toString() {
            return this._name;
        }
    }

    private static final class ProjectFilterChoice
    extends FilterChoice {
        public static final ProjectFilterChoice PROJECT_TECHNOLOGIES = new ProjectFilterChoice(GalleryArb.getString(13));
        public static final ProjectFilterChoice ALL_TECHNOLOGIES = new ProjectFilterChoice(GalleryArb.getString(12));

        private ProjectFilterChoice(String string) {
            super(string);
        }
    }

    private static final class GlobalFilterChoice
    extends FilterChoice {
        public static final GlobalFilterChoice AVAILABLE_ITEMS = new GlobalFilterChoice(GalleryArb.getString(14));
        public static final GlobalFilterChoice ALL_ITEMS = new GlobalFilterChoice(GalleryArb.getString(15));

        private GlobalFilterChoice(String string) {
            super(string);
        }
    }
}

