/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.help;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.ide.help.AboutBoxModel;
import oracle.ide.help.AboutBoxPage;
import oracle.ide.help.HelpSystem;
import oracle.ide.resource.IdeArb;

final class AboutBox
extends JPanel
implements Accessible {
    private JTabbedPane tabbedPane;
    private JLabel lblTitle;
    private Icon iconTitle;
    private JLabel lblVersion;
    private JLabel lblBuild;
    private JLabel lblCopyright;
    private AccessibleAboutBox aAboutBox;
    private Container _mainPanel;
    private AboutBoxModel _model;

    void $init$() {
        this.tabbedPane = new JTabbedPane();
        this.lblTitle = new JLabel();
        this.lblVersion = new JLabel();
        this.lblBuild = new JLabel();
        this.lblCopyright = new JLabel();
    }

    AboutBox(AboutBoxModel aboutBoxModel) {
        this.$init$();
        if (aboutBoxModel == null) {
            throw new NullPointerException("Null about box model");
        }
        this.addControls();
        this.setModel(aboutBoxModel);
    }

    PageContainer addPage(AboutBoxPage aboutBoxPage) {
        PageContainer pageContainer = new PageContainer(aboutBoxPage);
        this.tabbedPane.addTab(aboutBoxPage.getName(), pageContainer);
        return pageContainer;
    }

    private void setModel(AboutBoxModel aboutBoxModel) {
        this._model = aboutBoxModel;
        this.lblVersion.setText(this.getVersionString());
        this.lblBuild.setText(this.getBuildString());
        this.lblCopyright.setText(this._model.getCopyrightMessage());
        this.iconTitle = this._model.getBannerImage();
        if (this.iconTitle != null) {
            this.lblTitle.setIcon(this.iconTitle);
        }
        this._mainPanel.validate();
    }

    private void addControls() {
        this.lblTitle.setAlignmentX(0.5f);
        this.lblVersion.setAlignmentX(0.5f);
        this.lblVersion.setFont(this.lblVersion.getFont().deriveFont(1));
        this.lblBuild.setAlignmentX(0.5f);
        this.lblBuild.setFont(this.lblBuild.getFont().deriveFont(1));
        this.lblCopyright.setAlignmentX(0.5f);
        Border border = BorderFactory.createEmptyBorder(10, 10, 10, 10);
        Box box = new Box(1);
        box.setBorder(border);
        box.add(Box.createVerticalGlue());
        box.add(this.lblTitle);
        box.add(Box.createVerticalGlue());
        box.add(this.lblVersion);
        box.add(Box.createVerticalStrut(5));
        box.add(this.lblBuild);
        box.add(Box.createVerticalStrut(10));
        box.add(this.lblCopyright);
        box.add(Box.createVerticalStrut(10));
        this._mainPanel = box;
        2 var3_3 = new 2();
        var3_3.setComponent(box);
        var3_3.setInitialFocus(null);
        var3_3.setName(IdeArb.getString(421));
        this.addPage(var3_3).selected();
        this.setLayout(new BorderLayout());
        this.add((Component)this.tabbedPane, "Center");
        this.tabbedPane.addChangeListener(new 1());
        HelpSystem helpSystem = HelpSystem.getHelpSystem();
        if (helpSystem != null) {
            helpSystem.registerTopic(box, "f1_helpaboutjdev_html");
        }
    }

    JComponent getInitialFocusedComponent() {
        return this.tabbedPane;
    }

    private final String getVersionString() {
        return this._model.getVersionString();
    }

    private final String getBuildString() {
        return this._model.getBuildString();
    }

    public AccessibleContext getAccessibleContext() {
        if (this.aAboutBox == null) {
            this.aAboutBox = new AccessibleAboutBox();
        }
        return this.aAboutBox;
    }

    static JTabbedPane ra$tabbedPane(AboutBox aboutBox) {
        return aboutBox.tabbedPane;
    }

    final class 2
    extends AboutBoxPage {
        protected void populate() {
        }
    }

    final class 1
    implements ChangeListener {
        public void stateChanged(ChangeEvent changeEvent) {
            PageContainer pageContainer = (PageContainer)AboutBox.ra$tabbedPane(AboutBox.this).getSelectedComponent();
            pageContainer.selected();
            pageContainer.validate();
            Component component = pageContainer.getPage().getInitialFocus();
            if (component != null) {
                component.requestFocus();
            }
        }
    }

    protected class AccessibleAboutBox
    extends JPanel.AccessibleJPanel {
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.TABLE;
        }

        protected AccessibleAboutBox() {
            super(AboutBox.this);
        }
    }

    private static class PageContainer
    extends JPanel {
        private final AboutBoxPage _page;

        PageContainer(AboutBoxPage aboutBoxPage) {
            this._page = aboutBoxPage;
            this.setLayout(new BorderLayout());
        }

        void selected() {
            if (this.getComponentCount() == 0) {
                this.add(this._page.getComponent(), "Center");
                this._page.populate();
            }
        }

        AboutBoxPage getPage() {
            return this._page;
        }
    }
}

