/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.help;

import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import javax.naming.Context;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import oracle.bali.ewt.dialog.DialogHeader;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.help.AboutBox;
import oracle.ide.help.AboutBoxModel;
import oracle.ide.help.AboutBoxPage;
import oracle.ide.resource.IdeArb;
import oracle.javatools.jndi.Names;

public class AboutBoxFactory {
    private static final String ABOUT_BOX_FACTORY_NAME = "ide/about-box-factory";
    private static final Dimension DEFAULT_SIZE = new Dimension(600, 400);
    private final List _pageClasses;
    private AboutBoxModel _model;

    void $init$() {
        this._pageClasses = new ArrayList();
        this._model = null;
    }

    public static final AboutBoxFactory getAboutBoxFactory() {
        return (AboutBoxFactory)Names.lookup((Context)Names.newInitialContext(), (String)ABOUT_BOX_FACTORY_NAME);
    }

    public static final void setAboutBoxFactory(AboutBoxFactory aboutBoxFactory) {
        Names.bind((Context)Names.newInitialContext(), (String)ABOUT_BOX_FACTORY_NAME, (Object)aboutBoxFactory);
    }

    public void setModel(AboutBoxModel aboutBoxModel) {
        this._model = aboutBoxModel;
    }

    public final void addPage(Class clazz) {
        if (clazz == null) {
            throw new NullPointerException("Null page class.");
        }
        this._pageClasses.add(clazz);
    }

    public final void removePage(Class clazz) {
        if (clazz != null) {
            this._pageClasses.remove(clazz);
        }
    }

    public void showAboutBox() {
        if (this._model == null) {
            throw new IllegalStateException("No about box model.");
        }
        AboutBox aboutBox = new AboutBox(this._model);
        for (Class clazz : this._pageClasses) {
            try {
                AboutBoxPage aboutBoxPage = (AboutBoxPage)clazz.newInstance();
                aboutBox.addPage(aboutBoxPage);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        this.runDialog(aboutBox);
    }

    private void runDialog(AboutBox aboutBox) {
        JComponent jComponent = aboutBox.getInitialFocusedComponent();
        String string = this._model.getProductName();
        String string2 = IdeArb.format(420, string);
        DialogHeader dialogHeader = new DialogHeader();
        dialogHeader.setHeaderTitle(string);
        dialogHeader.setHeaderDescription(this._model.getProductVersion());
        Icon icon = this._model.getHeaderImage();
        if (icon != null) {
            dialogHeader.setHeaderImage(((ImageIcon)icon).getImage());
        }
        JEWTDialog jEWTDialog = OnePageWizardDialogFactory.createJEWTDialog(aboutBox, jComponent, string2, 1);
        jEWTDialog.setDialogHeader((Component)dialogHeader);
        jEWTDialog.setPreferredSize(DEFAULT_SIZE);
        jEWTDialog.runDialog();
        jEWTDialog.dispose();
    }

    public AboutBoxFactory() {
        this.$init$();
    }
}

