/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.inspector;

import java.util.ArrayList;
import oracle.bali.inspector.PropertyModel;
import oracle.bali.inspector.multi.SelectionModel;
import oracle.ide.Context;
import oracle.ide.controller.Command;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.inspector.IdePropertyModel;
import oracle.ide.inspector.InspectorContext;
import oracle.ide.inspector.PropertySetCommand;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.Subject;

public class IdeMultiObjectModel
extends IdePropertyModel {
    private Context context;
    private Subject[] subjects;

    protected Context getContext() {
        return this.context;
    }

    public void setContext(Context context) {
        Node node;
        this.context = context;
        Element[] elementArray = context.getSelection();
        ArrayList<Element> arrayList = new ArrayList<Element>();
        Integer[] integerArray = InspectorContext.getInspectableOffsets(context);
        if (integerArray != null) {
            int n = 0;
            while (n < integerArray.length) {
                Element element = elementArray[integerArray[n]];
                if (element instanceof Subject) {
                    arrayList.add(element);
                }
                ++n;
            }
        }
        if (arrayList.size() == 0 && (node = context.getNode()) != null) {
            arrayList.add(node);
        }
        this.subjects = new Subject[arrayList.size()];
        arrayList.toArray(this.subjects);
    }

    public Subject[] getSubjects() {
        return this.subjects;
    }

    public void setValueAt(Object object, int n, int n2) {
        Command command = this.createCommand(object, n, n2);
        if (command != null) {
            try {
                CommandProcessor commandProcessor = CommandProcessor.getInstance();
                command.setContext(this.context);
                commandProcessor.invoke(command);
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                throw new IllegalArgumentException();
            }
        }
    }

    protected Command createCommand(Object object, int n, int n2) {
        Object object2 = this.getValueAt(n, this.getColumnIndex(PropertyModel.COLUMN_ID));
        SelectionModel selectionModel = this.getSelectionModel();
        return object2 != null ? new PropertySetCommand(selectionModel, object2, n2, object) : null;
    }
}

