/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.inspector;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.inspector.DefaultInspectable;
import oracle.ide.inspector.IdeMultiObjectModel;
import oracle.ide.inspector.IdePropertyModel;
import oracle.ide.inspector.Inspectable;
import oracle.ide.inspector.InspectableFactory;
import oracle.ide.inspector.MultiInspectable;
import oracle.ide.model.Attributes;
import oracle.ide.model.Element;
import oracle.ide.model.ElementAttributes;
import oracle.ide.model.SupportsInspection;

public class InspectorFactory {
    private static final InspectorFactory INSTANCE = new InspectorFactory();
    private static final String BEANINFO_PROPERTY = "Ide.BeanInfoSearchPath";
    private HashMap inspectableRegistry;
    private HashMap modelRegistry;
    private List factories;
    private Class defaultInspectable;

    static {
        String string = Ide.getProperty(BEANINFO_PROPERTY);
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
            ArrayList<String> arrayList = new ArrayList<String>();
            while (stringTokenizer.hasMoreTokens()) {
                arrayList.add(stringTokenizer.nextToken());
            }
            String[] stringArray = Introspector.getBeanInfoSearchPath();
            int n = stringArray != null ? stringArray.length : 0;
            int n2 = 0;
            while (n2 < n) {
                arrayList.add(stringArray[n2]);
                ++n2;
            }
            n = arrayList.size();
            stringArray = new String[n];
            int n3 = 0;
            while (n3 < n) {
                stringArray[n3] = arrayList.get(n3).toString();
                ++n3;
            }
            Introspector.setBeanInfoSearchPath(stringArray);
        }
    }

    void $init$() {
        this.defaultInspectable = DefaultInspectable.class;
    }

    private InspectorFactory() {
        this.$init$();
        this.inspectableRegistry = new HashMap();
        this.modelRegistry = new HashMap();
        this.factories = new ArrayList();
    }

    public static InspectorFactory getInstance() {
        return INSTANCE;
    }

    public MultiInspectable getMultiInspectable(Context context) {
        return new MultiInspectable(context);
    }

    public Inspectable getInspectable(Context context) {
        boolean bl;
        Element element;
        Inspectable inspectable = null;
        Element element2 = element = context != null ? context.getNode() : null;
        if (element == null) {
            element = context != null ? context.getElement() : null;
        }
        Attributes attributes = element != null ? element.getAttributes() : null;
        boolean bl2 = bl = attributes != null ? attributes.isSet(ElementAttributes.NON_EDITABLE) : false;
        if (element != null && !bl) {
            Object object = element.getData();
            if (object == null) {
                object = element;
            }
            int n = this.factories.size() - 1;
            while (n >= 0) {
                InspectableFactory inspectableFactory = (InspectableFactory)this.factories.get(n);
                inspectable = inspectableFactory.getInspectable(context);
                if (inspectable != null) break;
                --n;
            }
        }
        return inspectable;
    }

    public Inspectable getInspectable(Context context, Element element) {
        boolean bl;
        Inspectable inspectable = null;
        Attributes attributes = element != null ? element.getAttributes() : null;
        boolean bl2 = bl = attributes != null ? attributes.isSet(ElementAttributes.NON_EDITABLE) : false;
        if (element != null && !bl) {
            Object object = element.getData();
            if (object == null) {
                object = element;
            }
            if (object instanceof Inspectable) {
                inspectable = (Inspectable)object;
            } else {
                Class<?> clazz = object.getClass();
                Class clazz2 = (Class)this.inspectableRegistry.get(clazz);
                while (clazz2 == null) {
                    clazz2 = InspectorFactory.getRegisteredInterface(clazz, this.inspectableRegistry);
                    if (clazz2 != null || (clazz = clazz.getSuperclass()) == null) break;
                    clazz2 = (Class)this.inspectableRegistry.get(clazz);
                }
                if (clazz2 == null && object instanceof SupportsInspection) {
                    clazz2 = this.defaultInspectable;
                }
                if (clazz2 != null) {
                    try {
                        inspectable = (Inspectable)clazz2.newInstance();
                    }
                    catch (Exception exception) {
                        inspectable = null;
                    }
                }
            }
            if (inspectable != null) {
                Context context2 = new Context(context);
                context2.setSelection(new Element[]{element});
                inspectable.setContext(context2);
            }
        }
        return inspectable;
    }

    private static Class getRegisteredInterface(Class clazz, HashMap hashMap) {
        Class<?>[] classArray;
        Class<?>[] classArray2 = classArray = clazz != null ? clazz.getInterfaces() : null;
        if (classArray != null) {
            int n = 0;
            while (n < classArray.length) {
                Object object = hashMap.get(classArray[n]);
                if (object == null) {
                    object = InspectorFactory.getRegisteredInterface(classArray[n], hashMap);
                }
                if (object != null) {
                    return (Class)object;
                }
                ++n;
            }
        }
        return null;
    }

    public void registerInspectable(Class clazz, Class clazz2) throws ClassCastException {
        if (clazz != null) {
            if (clazz2 != null) {
                if (!Inspectable.class.isAssignableFrom(clazz2)) {
                    throw new ClassCastException();
                }
                this.inspectableRegistry.put(clazz, clazz2);
            } else {
                this.inspectableRegistry.remove(clazz);
            }
        }
    }

    public void addInspectableFactory(InspectableFactory inspectableFactory) {
        if (inspectableFactory != null && !this.factories.contains(inspectableFactory)) {
            this.factories.add(inspectableFactory);
        }
    }

    public void removeInspectableFactory(InspectableFactory inspectableFactory) {
        if (inspectableFactory != null) {
            this.factories.remove(inspectableFactory);
        }
    }

    public void setDefaultInspectable(Class clazz) {
        if (clazz != null && Inspectable.class.isAssignableFrom(clazz)) {
            this.defaultInspectable = clazz;
        }
    }

    public Class getPropertyModelType(Class clazz) {
        Class clazz2 = null;
        if (clazz != null) {
            clazz2 = (Class)this.modelRegistry.get(clazz);
            while (clazz2 == null) {
                clazz2 = InspectorFactory.getRegisteredInterface(clazz, this.modelRegistry);
                if (clazz2 != null || (clazz = clazz.getSuperclass()) == null) break;
                clazz2 = (Class)this.modelRegistry.get(clazz);
            }
        }
        return clazz2 != null ? clazz2 : IdeMultiObjectModel.class;
    }

    public void registerPropertyModel(Class clazz, Class clazz2) throws ClassCastException {
        if (clazz != null) {
            if (clazz2 != null) {
                if (!IdePropertyModel.class.isAssignableFrom(clazz2)) {
                    throw new ClassCastException();
                }
                this.modelRegistry.put(clazz, clazz2);
            } else {
                this.modelRegistry.remove(clazz);
            }
        }
    }

    public static final BeanInfo getBeanInfo(Class clazz) throws IntrospectionException {
        return Introspector.getBeanInfo(clazz);
    }
}

