/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.keyboard;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JDialog;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.text.JTextComponent;
import oracle.ide.Ide;
import oracle.ide.keyboard.KeyStrokeMap;
import oracle.ide.keyboard.KeyStrokeOptions;
import oracle.ide.keyboard.KeyStrokes;
import oracle.ide.keyboard.MultiInputMap;

public class DialogWatcher
implements AWTEventListener {
    private static DialogWatcher INSTANCE;

    private DialogWatcher() {
    }

    public static void install() {
        INSTANCE = new DialogWatcher();
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        toolkit.addAWTEventListener(INSTANCE, 64);
    }

    public void eventDispatched(AWTEvent aWTEvent) {
        int n = aWTEvent.getID();
        switch (n) {
            case 200: {
                this.whenWindowOpened((WindowEvent)aWTEvent);
            }
        }
    }

    private void whenWindowOpened(WindowEvent windowEvent) {
        JDialog jDialog;
        JRootPane jRootPane;
        InputMap inputMap;
        Window window = windowEvent.getWindow();
        if (window instanceof JDialog && !this.hasMultiInputMap(inputMap = (jRootPane = (jDialog = (JDialog)window).getRootPane()).getInputMap(1))) {
            this.addInputMap(jRootPane);
        }
    }

    private boolean hasMultiInputMap(InputMap inputMap) {
        if (inputMap == null) {
            return false;
        }
        if (inputMap instanceof MultiInputMap) {
            return true;
        }
        return this.hasMultiInputMap(inputMap.getParent());
    }

    private void addInputMap(JRootPane jRootPane) {
        ActionMap actionMap = new ActionMap();
        MultiInputMap multiInputMap = new MultiInputMap();
        KeyStrokeOptions keyStrokeOptions = Ide.getSettings().getKeyStrokeOptions();
        KeyStrokeMap keyStrokeMap = keyStrokeOptions.getGlobalKeyMap();
        this.addKeys(keyStrokeMap, multiInputMap, actionMap, 17);
        this.addKeys(keyStrokeMap, multiInputMap, actionMap, 18);
        this.addKeys(keyStrokeMap, multiInputMap, actionMap, 19);
        if (multiInputMap.size() > 0) {
            InputMap inputMap = jRootPane.getInputMap(1);
            multiInputMap.setParent(inputMap);
            jRootPane.setInputMap(1, multiInputMap);
            ActionMap actionMap2 = jRootPane.getActionMap();
            actionMap.setParent(actionMap2);
            jRootPane.setActionMap(actionMap);
        }
    }

    private void addKeys(KeyStrokeMap keyStrokeMap, MultiInputMap multiInputMap, ActionMap actionMap, int n) {
        InputMap inputMap = (InputMap)UIManager.get("TextArea.focusInputMap");
        Integer n2 = new Integer(n);
        ActionDelegate actionDelegate = new ActionDelegate(n);
        List list = keyStrokeMap.getKeyStrokesFor(n);
        int n3 = 0;
        while (n3 < list.size()) {
            KeyStroke keyStroke;
            KeyStrokes keyStrokes = (KeyStrokes)list.get(n3);
            if (keyStrokes.getLength() != 1 || inputMap.get(keyStroke = keyStrokes.getKeyStroke(0)) == null) {
                multiInputMap.put(keyStrokes, (Object)n2);
                actionMap.put(n2, actionDelegate);
            }
            ++n3;
        }
    }

    public static class ActionDelegate
    extends AbstractAction {
        private int _commandID;

        public ActionDelegate(int n) {
            this._commandID = n;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Component component;
            Window window;
            Component component2;
            Object object = actionEvent.getSource();
            if (object instanceof Component && (component2 = (window = SwingUtilities.getWindowAncestor(component = (Component)object)).getFocusOwner()) instanceof JTextComponent) {
                JTextComponent jTextComponent = (JTextComponent)component2;
                switch (this._commandID) {
                    case 17: {
                        jTextComponent.cut();
                        break;
                    }
                    case 18: {
                        jTextComponent.copy();
                        break;
                    }
                    case 19: {
                        jTextComponent.paste();
                    }
                }
            }
        }
    }
}

