/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.keyboard;

import java.awt.Component;
import java.awt.DefaultKeyboardFocusManager;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.event.KeyEvent;
import javax.swing.InputMap;
import javax.swing.JComponent;
import oracle.ide.keyboard.IdeInputMapUIResource;
import oracle.ide.keyboard.MultiInputMap;

public final class GrabbableFocusManager
implements KeyEventDispatcher {
    private static GrabbableFocusManager INSTANCE;
    private Component _lastFocusedComponent;
    private boolean _lastFocusedComponentHadMultiInputMap;
    private Component _lastPressed;
    private Component _eatTyped;
    private Component _eatReleased;

    private GrabbableFocusManager() {
    }

    public static GrabbableFocusManager install() {
        if (INSTANCE == null) {
            GrabbableFocusManager grabbableFocusManager = new GrabbableFocusManager();
            KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            if (keyboardFocusManager instanceof DefaultKeyboardFocusManager) {
                keyboardFocusManager.addKeyEventDispatcher(grabbableFocusManager);
                INSTANCE = grabbableFocusManager;
            }
        }
        return INSTANCE;
    }

    public static GrabbableFocusManager getGrabbableFocusManager() {
        return INSTANCE;
    }

    public void eatNextTypedReleased() {
        this._eatTyped = this._eatReleased = this._lastPressed;
    }

    public boolean dispatchKeyEvent(KeyEvent keyEvent) {
        Component component = keyEvent.getComponent();
        boolean bl = this.hasMultiInputMap(component);
        IdeInputMapUIResource.setMustIgnore(bl);
        return this.processKeyEvent_eat(component, keyEvent);
    }

    private boolean hasMultiInputMap(Component component) {
        if (this._lastFocusedComponent != component) {
            this._lastFocusedComponent = component;
            this._lastFocusedComponentHadMultiInputMap = false;
            while (!this._lastFocusedComponentHadMultiInputMap && component instanceof JComponent) {
                JComponent jComponent = (JComponent)component;
                InputMap inputMap = jComponent.getInputMap(1);
                while (!this._lastFocusedComponentHadMultiInputMap && inputMap != null) {
                    if (inputMap instanceof MultiInputMap) {
                        this._lastFocusedComponentHadMultiInputMap = true;
                    }
                    inputMap = inputMap.getParent();
                }
                component = component.getParent();
            }
        }
        return this._lastFocusedComponentHadMultiInputMap;
    }

    private boolean processKeyEvent_eat(Component component, KeyEvent keyEvent) {
        switch (keyEvent.getID()) {
            case 401: {
                this._lastPressed = component;
                if (this._eatTyped == null || this._eatTyped == component) break;
                this._eatReleased = null;
                this._eatTyped = null;
                break;
            }
            case 400: {
                if (this._eatTyped == null) break;
                if (this._eatTyped == component) {
                    this._eatTyped = null;
                    keyEvent.consume();
                    break;
                }
                this._eatReleased = null;
                this._eatTyped = null;
                break;
            }
            case 402: {
                if (this._eatReleased == null) break;
                if (this._eatReleased == component) {
                    this._eatTyped = null;
                    this._eatReleased = null;
                    keyEvent.consume();
                    break;
                }
                this._eatReleased = null;
                this._eatTyped = null;
            }
        }
        return keyEvent.isConsumed();
    }
}

