/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.keyboard;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import javax.swing.InputMap;
import javax.swing.KeyStroke;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.InputMapUIResource;
import oracle.ide.Ide;
import oracle.ide.keyboard.KeyStrokeMap;
import oracle.ide.keyboard.KeyStrokeOptions;

public class IdeInputMapUIResource
extends InputMapUIResource {
    private static HashSet _ignore;
    private static boolean _mustIgnore;
    private static int _lastChangeID;
    private InputMap _realInputMap;
    private int _lastKnownChangeID;
    private boolean _hasKeysToIgnore;

    static {
        _lastChangeID = 1;
    }

    public static void replaceInputMapUIResources() {
        UIDefaults uIDefaults = UIManager.getLookAndFeelDefaults();
        Enumeration enumeration = uIDefaults.keys();
        while (enumeration.hasMoreElements()) {
            InputMap inputMap;
            Object k = enumeration.nextElement();
            if (!(k instanceof String) || !((String)k).toLowerCase().endsWith(".focusinputmap") || (inputMap = (InputMap)uIDefaults.get(k)) instanceof IdeInputMapUIResource) continue;
            IdeInputMapUIResource ideInputMapUIResource = new IdeInputMapUIResource(inputMap);
            uIDefaults.put(k, ideInputMapUIResource);
        }
        1 var5_5 = new 1();
        Ide.getSettings().getKeyStrokeOptions().addChangeListener(var5_5);
    }

    private static void fillIgnoreList(KeyStrokeMap keyStrokeMap) {
        Collection collection = keyStrokeMap.getMultikeyKeystrokes();
        for (KeyStroke keyStroke : collection) {
            IdeInputMapUIResource.ignore(keyStroke);
        }
    }

    private static void ignore(KeyStroke keyStroke) {
        if (_ignore == null) {
            _ignore = new HashSet();
        }
        _ignore.add(keyStroke);
        IdeInputMapUIResource.whenIgnoreListChanges();
    }

    public static void clearIgnoreList() {
        _ignore = null;
        ++_lastChangeID;
    }

    private static void whenIgnoreListChanges() {
        ++_lastChangeID;
    }

    private IdeInputMapUIResource(InputMap inputMap) {
        this._realInputMap = inputMap;
    }

    public static boolean isMustIgnore() {
        return _mustIgnore;
    }

    public static void setMustIgnore(boolean bl) {
        _mustIgnore = bl;
    }

    private boolean hasChanged() {
        return _lastChangeID != this._lastKnownChangeID;
    }

    private void setChangedFlag(boolean bl) {
        this._lastKnownChangeID = bl ? _lastChangeID - 1 : _lastChangeID;
    }

    private boolean hasKeysToIgnore() {
        if (this.hasChanged()) {
            this._hasKeysToIgnore = false;
            if (_ignore != null) {
                KeyStroke[] keyStrokeArray = this._realInputMap.allKeys();
                int n = 0;
                while (n < keyStrokeArray.length) {
                    KeyStroke keyStroke = keyStrokeArray[n];
                    if (_ignore.contains(keyStroke)) {
                        this._hasKeysToIgnore = true;
                        break;
                    }
                    ++n;
                }
            }
            this.setChangedFlag(false);
        }
        return this._hasKeysToIgnore;
    }

    private KeyStroke[] filter(KeyStroke[] keyStrokeArray) {
        if (this.hasKeysToIgnore()) {
            ArrayList<KeyStroke> arrayList = new ArrayList<KeyStroke>(keyStrokeArray.length);
            int n = 0;
            while (n < keyStrokeArray.length) {
                KeyStroke keyStroke = keyStrokeArray[n];
                if (!_ignore.contains(keyStroke)) {
                    arrayList.add(keyStroke);
                }
                ++n;
            }
            keyStrokeArray = new KeyStroke[arrayList.size()];
            arrayList.toArray(keyStrokeArray);
        }
        return keyStrokeArray;
    }

    public Object get(KeyStroke keyStroke) {
        if (IdeInputMapUIResource.isMustIgnore() && _ignore != null && _ignore.contains(keyStroke)) {
            return null;
        }
        return this._realInputMap.get(keyStroke);
    }

    public void setParent(InputMap inputMap) {
        this._realInputMap.setParent(inputMap);
        this.setChangedFlag(true);
    }

    public InputMap getParent() {
        return this._realInputMap.getParent();
    }

    public void put(KeyStroke keyStroke, Object object) {
        this._realInputMap.put(keyStroke, object);
        this.setChangedFlag(true);
    }

    public void remove(KeyStroke keyStroke) {
        this._realInputMap.remove(keyStroke);
        this.setChangedFlag(true);
    }

    public void clear() {
        this._realInputMap.clear();
        this.setChangedFlag(true);
    }

    public KeyStroke[] keys() {
        KeyStroke[] keyStrokeArray = this._realInputMap.keys();
        if (IdeInputMapUIResource.isMustIgnore()) {
            keyStrokeArray = this.filter(keyStrokeArray);
        }
        return keyStrokeArray;
    }

    public int size() {
        int n;
        if (IdeInputMapUIResource.isMustIgnore() && this.hasKeysToIgnore()) {
            KeyStroke[] keyStrokeArray = this._realInputMap.keys();
            n = 0;
            int n2 = 0;
            while (n2 < keyStrokeArray.length) {
                KeyStroke keyStroke = keyStrokeArray[n2];
                if (!_ignore.contains(keyStroke)) {
                    ++n;
                }
                ++n2;
            }
        } else {
            n = this._realInputMap.size();
        }
        return n;
    }

    public KeyStroke[] allKeys() {
        KeyStroke[] keyStrokeArray = this._realInputMap.allKeys();
        if (IdeInputMapUIResource.isMustIgnore()) {
            this.filter(keyStrokeArray);
        }
        return keyStrokeArray;
    }

    static void maS$fillIgnoreList(KeyStrokeMap keyStrokeMap) {
        IdeInputMapUIResource.fillIgnoreList(keyStrokeMap);
    }

    public static final class 1
    implements ChangeListener {
        public void stateChanged(ChangeEvent changeEvent) {
            KeyStrokeOptions keyStrokeOptions = (KeyStrokeOptions)changeEvent.getSource();
            IdeInputMapUIResource.clearIgnoreList();
            KeyStrokeMap keyStrokeMap = keyStrokeOptions.getGlobalKeyMap();
            IdeInputMapUIResource.maS$fillIgnoreList(keyStrokeMap);
            HashMap hashMap = keyStrokeOptions.getLocalKeyMaps();
            if (hashMap != null) {
                for (KeyStrokeMap keyStrokeMap2 : hashMap.values()) {
                    IdeInputMapUIResource.maS$fillIgnoreList(keyStrokeMap2);
                }
            }
        }
    }
}

