/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.keyboard;

import java.awt.event.KeyEvent;
import java.util.StringTokenizer;
import javax.swing.KeyStroke;

public final class KeyStroke2String {
    public static Class supportedClass() {
        return KeyStroke.class;
    }

    private static boolean mustCheckSwingParser(int n) {
        if (65 <= n && n <= 90) {
            return false;
        }
        if (48 <= n && n <= 57) {
            return false;
        }
        return 112 > n || n > 123;
    }

    public static String toString(KeyStroke keyStroke) {
        String string;
        int n = keyStroke.getModifiers();
        StringBuffer stringBuffer = new StringBuffer();
        if ((n & 1) != 0) {
            stringBuffer.append("shift ");
        }
        if ((n & 2) != 0) {
            stringBuffer.append("control ");
        }
        if ((n & 4) != 0) {
            stringBuffer.append("meta ");
        }
        if ((n & 8) != 0) {
            stringBuffer.append("alt ");
        }
        boolean bl = false;
        char c = keyStroke.getKeyChar();
        if (c == '\u0000' || c == '\uffff') {
            int n2 = keyStroke.getKeyCode();
            string = KeyEvent.getKeyText(n2).toUpperCase();
            if (KeyStroke2String.mustCheckSwingParser(n2) && KeyStroke.getKeyStroke(string) == null) {
                string = Integer.toString(n2);
                bl = true;
            }
        } else {
            string = Integer.toString(c);
        }
        String string2 = bl ? stringBuffer + "[" + string + "]" : stringBuffer + string;
        return string2;
    }

    public static KeyStroke fromString(String string) {
        KeyStroke keyStroke;
        if (string.endsWith("]")) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, " []");
            int n = 0;
            int n2 = 0;
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                if (Character.isDigit(string2.charAt(0))) {
                    n2 = Integer.parseInt(string2);
                    continue;
                }
                if (string2.equals("control")) {
                    n |= 2;
                    continue;
                }
                if (string2.equals("alt")) {
                    n |= 8;
                    continue;
                }
                if (string2.equals("shift")) {
                    n |= 1;
                    continue;
                }
                if (!string2.equals("meta")) continue;
                n |= 4;
            }
            keyStroke = KeyStroke.getKeyStroke(n2, n);
        } else {
            keyStroke = KeyStroke.getKeyStroke(string);
        }
        return keyStroke;
    }
}

