/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.keyboard;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import oracle.ide.keyboard.KeyStrokeContext;
import oracle.ide.keyboard.ResKeystrokeContext;
import oracle.ide.keyboard.ResKeystrokeReader;
import oracle.ide.keyboard.XMLKeyStrokeContext;
import oracle.ide.keyboard.XMLKeystrokeContextDefs;
import oracle.ide.util.CollectionEvent;
import oracle.ide.util.CollectionListener;
import org.xml.sax.SAXException;

public final class KeyStrokeContextRegistry {
    private final ArrayList _allContexts;
    private ArrayList _listeners;
    private ArrayList _resContexts;
    private boolean _acceleratorDefinitionFilesLoaded;

    void $init$() {
        this._allContexts = new ArrayList();
        this._resContexts = new ArrayList(50);
        this._acceleratorDefinitionFilesLoaded = false;
    }

    public KeyStrokeContextRegistry() {
        this.$init$();
    }

    public void addListener(CollectionListener collectionListener) {
        if (this._listeners == null) {
            this._listeners = new ArrayList(1);
        }
        this._listeners.add(collectionListener);
    }

    public void removeListener(CollectionListener collectionListener) {
        this._listeners.remove(collectionListener);
    }

    private void fireEvent(int n, KeyStrokeContext keyStrokeContext) {
        if (this._listeners != null) {
            CollectionEvent collectionEvent = null;
            int n2 = this._listeners.size();
            int n3 = 0;
            while (n3 < n2) {
                CollectionListener collectionListener = (CollectionListener)this._listeners.get(n3);
                if (collectionEvent == null) {
                    collectionEvent = new CollectionEvent(n, this, keyStrokeContext);
                }
                switch (n) {
                    case 1: {
                        collectionListener.elementAdded(collectionEvent);
                        break;
                    }
                    case 2: {
                        collectionListener.elementRemoved(collectionEvent);
                    }
                }
                ++n3;
            }
        }
    }

    public void addContext(KeyStrokeContext keyStrokeContext) {
        block1: {
            XMLKeyStrokeContext xMLKeyStrokeContext;
            String string;
            if (this.isContextInAllContextList(keyStrokeContext)) break block1;
            this._allContexts.add(keyStrokeContext);
            if (keyStrokeContext instanceof XMLKeyStrokeContext && (string = (xMLKeyStrokeContext = (XMLKeyStrokeContext)keyStrokeContext).getAcceleratorFile()) != null) {
                XMLKeystrokeContextDefs xMLKeystrokeContextDefs = XMLKeystrokeContextDefs.getInstance();
                Class<?> clazz = xMLKeyStrokeContext.getClass();
                ClassLoader classLoader = clazz.getClassLoader();
                xMLKeystrokeContextDefs.addAcceleratorFile(classLoader, string);
            }
            this.fireEvent(1, keyStrokeContext);
        }
    }

    public void removeContext(KeyStrokeContext keyStrokeContext) {
        if (this._allContexts.contains(keyStrokeContext)) {
            this._allContexts.remove(keyStrokeContext);
            this.fireEvent(2, keyStrokeContext);
        }
    }

    public void addAcceleratorDefinitionFile(ClassLoader classLoader, String string) {
        ResKeystrokeContext resKeystrokeContext = new ResKeystrokeContext(classLoader, string);
        this._resContexts.add(resKeystrokeContext);
        this.addContext(resKeystrokeContext);
        this._acceleratorDefinitionFilesLoaded = false;
    }

    public void removeAcceleratorDefinitionFile(ClassLoader classLoader, String string) {
        int n = this._resContexts.size() - 1;
        while (n >= 0) {
            ResKeystrokeContext resKeystrokeContext = (ResKeystrokeContext)this._resContexts.get(n);
            if (resKeystrokeContext.getClassLoader() == classLoader && resKeystrokeContext.getName() == string) {
                ResKeystrokeContext resKeystrokeContext2 = (ResKeystrokeContext)this._resContexts.remove(n);
                this.removeContext(resKeystrokeContext2);
                return;
            }
            --n;
        }
    }

    void loadAcceleratorDefinitionFiles() {
        if (!this._acceleratorDefinitionFilesLoaded) {
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            sAXParserFactory.setValidating(false);
            try {
                SAXParser sAXParser = sAXParserFactory.newSAXParser();
                ResKeystrokeReader resKeystrokeReader = new ResKeystrokeReader(sAXParser);
                int n = 0;
                while (n < this._resContexts.size()) {
                    ResKeystrokeContext resKeystrokeContext = (ResKeystrokeContext)this._resContexts.get(n);
                    resKeystrokeContext.load(resKeystrokeReader);
                    ++n;
                }
                this._acceleratorDefinitionFilesLoaded = true;
            }
            catch (ParserConfigurationException parserConfigurationException) {
                parserConfigurationException.printStackTrace();
            }
            catch (SAXException sAXException) {
                sAXException.printStackTrace();
            }
        }
    }

    public KeyStrokeContext getContext(String string) {
        int n = this._allContexts.size();
        int n2 = 0;
        while (n2 < n) {
            KeyStrokeContext keyStrokeContext = (KeyStrokeContext)this._allContexts.get(n2);
            if (string.equalsIgnoreCase(keyStrokeContext.getName())) {
                return keyStrokeContext;
            }
            ++n2;
        }
        return null;
    }

    public Iterator getAllContexts() {
        return this._allContexts.iterator();
    }

    public Set getAllPresets() {
        HashSet<String> hashSet = new HashSet<String>();
        int n = this._allContexts.size();
        int n2 = 0;
        while (n2 < n) {
            KeyStrokeContext keyStrokeContext = (KeyStrokeContext)this._allContexts.get(n2);
            List list = keyStrokeContext.getAllPresets();
            if (list != null) {
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    String string = iterator.next().toString();
                    hashSet.add(string);
                }
            }
            ++n2;
        }
        return hashSet;
    }

    static Object searchPreset(KeyStrokeContext keyStrokeContext, String string) {
        Object var2_2 = null;
        List list = keyStrokeContext.getAllPresets();
        if (list != null) {
            int n = list.size();
            int n2 = 0;
            while (var2_2 == null && n2 < n) {
                Object e = list.get(n2);
                if (e.equals(string)) {
                    var2_2 = e;
                }
                ++n2;
            }
        }
        return var2_2;
    }

    private boolean isContextInAllContextList(KeyStrokeContext keyStrokeContext) {
        if (this._allContexts != null) {
            String string = keyStrokeContext.getName();
            int n = this._allContexts.size();
            int n2 = 0;
            while (n2 < n) {
                KeyStrokeContext keyStrokeContext2 = (KeyStrokeContext)this._allContexts.get(n2);
                String string2 = keyStrokeContext2.getName();
                if (string.equals(string2)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }
}

