/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.keyboard;

import java.awt.event.KeyEvent;
import javax.swing.KeyStroke;
import oracle.ide.keyboard.KeyStrokeFilter;
import oracle.ide.keyboard.KeyStrokeModel;
import oracle.ide.keyboard.KeyStrokesConstraint;

final class KeyStrokeControler {
    private final KeyStrokeModel _model;
    private KeyStrokesConstraint _constraints;
    private final KeyStrokeFilter _ksf;
    private KeyStroke _ksBack;

    void $init$() {
        this._ksf = new KeyStrokeFilter();
        this._ksBack = KeyStroke.getKeyStroke(8, 0);
    }

    public void setBackSpaceKey(KeyStroke keyStroke) {
        this._ksBack = keyStroke;
    }

    KeyStrokeControler() {
        this.$init$();
        this._model = new KeyStrokeModel();
    }

    KeyStrokeControler(KeyStrokeModel keyStrokeModel) {
        this.$init$();
        this._model = keyStrokeModel;
    }

    public void clear() {
        this._ksf.clear();
        this.getModel().clear();
    }

    public KeyStrokeModel getModel() {
        return this._model;
    }

    public void setConstraint(KeyStrokesConstraint keyStrokesConstraint) {
        this._constraints = keyStrokesConstraint;
    }

    private static String toString(KeyStroke keyStroke) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = keyStroke.getModifiers();
        int n2 = keyStroke.getKeyCode();
        if (n != 0) {
            stringBuffer.append(KeyEvent.getKeyModifiersText(n) + "+");
        }
        stringBuffer.append(KeyEvent.getKeyText(n2));
        return stringBuffer.toString();
    }

    public String toString() {
        String string;
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = "";
        int n = this._model.size();
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append(string2);
            KeyStroke keyStroke = this._model.get(n2);
            stringBuffer.append(KeyStrokeControler.toString(keyStroke));
            string2 = ", ";
            ++n2;
        }
        if (n == 0 && (string = this._ksf.toString(true)) != null) {
            stringBuffer.append(string2);
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    private void addKeyStroke(KeyStroke keyStroke) {
        if (keyStroke != null) {
            this._model.add(keyStroke);
        }
    }

    void keyPressed(KeyEvent keyEvent) {
        if (this._ksBack.equals(KeyStroke.getKeyStrokeForEvent(keyEvent))) {
            this._model.pop();
        } else if (this._ksf.keyPressed(keyEvent)) {
            KeyStroke keyStroke = this._ksf.getKeyStroke();
            if (!this._model.authorizeNewKeys()) {
                this._model.clear();
            }
            if (this.isAcceptableKey(keyStroke)) {
                this.addKeyStroke(keyStroke);
            }
        }
        keyEvent.consume();
    }

    static void keyTyped(KeyEvent keyEvent) {
        keyEvent.consume();
    }

    void keyReleased(KeyEvent keyEvent) {
        this._ksf.keyReleased(keyEvent);
        keyEvent.consume();
    }

    protected boolean isAcceptableKey(KeyStroke keyStroke) {
        return this._constraints == null || this._constraints.isAcceptableKey(this.getModel().getKeyStrokes(), keyStroke);
    }
}

