/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.keyboard;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.BreakIterator;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.accessibility.AccessibleText;
import javax.swing.FocusManager;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.text.AttributeSet;
import oracle.ide.keyboard.KeyStrokeControler;
import oracle.ide.keyboard.KeyStrokeModel;
import oracle.ide.keyboard.KeyStrokesConstraint;
import oracle.javatools.util.SwingUtils;

public final class KeyStrokeField
extends JComponent
implements Accessible,
FocusListener,
MouseListener,
KeyListener {
    private final KeyStrokeControler _controler;
    private final int _nColumns;
    private Dimension _charSize;
    private static final Color _clrBack = (Color)UIManager.get("window");
    private static final Color _clrText = (Color)UIManager.get("textText");
    private boolean _bAteATab;

    void $init$() {
        this._nColumns = 10;
        this._charSize = null;
        this._bAteATab = false;
    }

    public KeyStrokeField() {
        this.$init$();
        this._controler = new KeyStrokeControler();
        this.init();
    }

    public KeyStrokeField(KeyStrokeControler keyStrokeControler) {
        this.$init$();
        this._controler = keyStrokeControler;
        this.init();
    }

    public void clear() {
        this._controler.clear();
        this.whenFieldChanges();
    }

    public KeyStrokeModel getModel() {
        return this._controler.getModel();
    }

    public void setConstraint(KeyStrokesConstraint keyStrokesConstraint) {
        this._controler.setConstraint(keyStrokesConstraint);
    }

    private void init() {
        this.addKeyListener(this);
        this.addMouseListener(this);
        this.addFocusListener(this);
        Border border = UIManager.getBorder("TextField.border");
        this.setBorder(border);
    }

    public boolean isFocusTraversable() {
        return this.isEnabled();
    }

    protected Dimension getCharSize() {
        Font font;
        if (this._charSize == null && (font = this.getFont()) != null) {
            FontMetrics fontMetrics = this.getFontMetrics(font);
            this._charSize = new Dimension(fontMetrics.charWidth('m'), fontMetrics.getHeight() + 3);
            if (this._charSize.width % 2 == 0) {
                ++this._charSize.width;
            }
            if (this._charSize.height % 2 == 0) {
                ++this._charSize.height;
            }
        }
        return this._charSize;
    }

    public void setFont(Font font) {
        super.setFont(font);
        this._charSize = null;
    }

    public Dimension getPreferredSize() {
        Dimension dimension = this.getCharSize();
        if (dimension != null) {
            dimension = new Dimension(dimension);
            dimension.width = dimension.width * 10 + 3;
            dimension.height += 3;
        } else {
            dimension = new Dimension(400, 400);
        }
        return dimension;
    }

    protected void paintComponent(Graphics graphics) {
        graphics.setColor(_clrBack);
        Dimension dimension = this.getSize();
        Insets insets = this.getInsets();
        int n = insets.left;
        int n2 = insets.top;
        int n3 = dimension.width - (insets.left + insets.right);
        int n4 = dimension.height - (insets.top + insets.bottom);
        graphics.fillRect(n, n2, n3, n4);
        String string = this._controler.toString();
        graphics.setColor(_clrText);
        SwingUtils.drawString((Graphics)graphics, (String)string, (int)(n + 1), (int)(n4 - 1));
        if (this.hasFocus()) {
            graphics.setColor(_clrText);
            KeyStrokeField.drawDashedRect(graphics, n + 1, n2 + 1, n3 - 1, n4 - 1);
        }
    }

    private static void drawDashedRect(Graphics graphics, int n, int n2, int n3, int n4) {
        int n5 = n;
        while (n5 < n + n3) {
            graphics.drawLine(n5, n2, n5, n2);
            graphics.drawLine(n5, n2 + n4 - 1, n5, n2 + n4 - 1);
            n5 += 2;
        }
        int n6 = n2;
        while (n6 < n2 + n4) {
            graphics.drawLine(n, n6, n, n6);
            graphics.drawLine(n + n3 - 1, n6, n + n3 - 1, n6);
            n6 += 2;
        }
    }

    private void whenFieldChanges() {
        this.repaint();
        if (this.accessibleContext != null) {
            ((AccessibleKeyStrokeField)this.accessibleContext).actionPerformed(null);
        }
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleKeyStrokeField();
        }
        return this.accessibleContext;
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (this.isEnabled() && SwingUtilities.isLeftMouseButton(mouseEvent)) {
            this.requestFocus();
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void focusGained(FocusEvent focusEvent) {
        this.repaint();
    }

    public void focusLost(FocusEvent focusEvent) {
        this.repaint();
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (this.isEnabled()) {
            this._bAteATab = false;
            KeyStrokeModel keyStrokeModel = this.getModel();
            KeyStroke keyStroke = keyStrokeModel.top();
            if (keyStroke == null || keyStroke.getKeyCode() != 9) {
                this._controler.keyPressed(keyEvent);
            } else {
                keyStrokeModel.pop();
                FocusManager focusManager = FocusManager.getCurrentManager();
                if ((keyEvent.getModifiers() & 1) == 0) {
                    focusManager.focusNextComponent(this);
                } else {
                    focusManager.focusPreviousComponent(this);
                }
            }
            this.whenFieldChanges();
            keyEvent.consume();
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
        if (this.isEnabled()) {
            if (!this._bAteATab) {
                KeyStrokeControler.keyTyped(keyEvent);
                this.whenFieldChanges();
            }
            keyEvent.consume();
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
        if (this.isEnabled()) {
            if (!this._bAteATab) {
                this._controler.keyReleased(keyEvent);
                this.whenFieldChanges();
            }
            keyEvent.consume();
        }
    }

    public boolean isManagingFocus() {
        return this.isEnabled();
    }

    static KeyStrokeControler ra$_controler(KeyStrokeField keyStrokeField) {
        return keyStrokeField._controler;
    }

    private final class AccessibleKeyStrokeField
    extends JComponent.AccessibleJComponent
    implements AccessibleText,
    ActionListener {
        AccessibleKeyStrokeField() {
            super(KeyStrokeField.this);
        }

        public final AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet accessibleStateSet = super.getAccessibleStateSet();
            accessibleStateSet.add(AccessibleState.EDITABLE);
            accessibleStateSet.add(AccessibleState.SINGLE_LINE);
            accessibleStateSet.add(AccessibleState.OPAQUE);
            return accessibleStateSet;
        }

        public final AccessibleRole getAccessibleRole() {
            return AccessibleRole.TEXT;
        }

        public final AccessibleText getAccessibleText() {
            return this;
        }

        private String getNonNullText() {
            String string = KeyStrokeField.ra$_controler(KeyStrokeField.this).toString();
            return string == null ? "" : string;
        }

        private String getText(int n) {
            return this.getNonNullText().substring(n, n + 1);
        }

        public final void actionPerformed(ActionEvent actionEvent) {
            String string = this.getNonNullText();
            if (SwingUtilities.isEventDispatchThread()) {
                this.firePropertyChange("AccessibleText", null, string);
                this.firePropertyChange("AccessibleCaret", new Integer(0), new Integer(string.length()));
            } else {
                1 var3_3 = new 1(this, string);
                SwingUtilities.invokeLater(var3_3);
            }
        }

        public final int getIndexAtPoint(Point point) {
            return -1;
        }

        public final Rectangle getCharacterBounds(int n) {
            return new Rectangle();
        }

        public final int getCharCount() {
            int n = this.getNonNullText().length();
            return n;
        }

        public final int getCaretPosition() {
            int n = this.getNonNullText().length();
            return n;
        }

        public final String getAtIndex(int n, int n2) {
            String string = null;
            try {
                switch (n) {
                    case 1: {
                        string = this.getText(n2);
                        break;
                    }
                    case 2: {
                        String string2 = this.getNonNullText();
                        BreakIterator breakIterator = BreakIterator.getWordInstance();
                        breakIterator.setText(string2);
                        int n3 = breakIterator.following(n2);
                        string = string2.substring(breakIterator.previous(), n3);
                        break;
                    }
                    case 3: {
                        String string3 = this.getNonNullText();
                        BreakIterator breakIterator = BreakIterator.getSentenceInstance();
                        breakIterator.setText(string3);
                        int n4 = breakIterator.following(n2);
                        string = string3.substring(breakIterator.previous(), n4);
                    }
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            return string;
        }

        public final String getAfterIndex(int n, int n2) {
            String string = null;
            try {
                switch (n) {
                    case 1: {
                        string = this.getText(n2 + 1);
                        break;
                    }
                    case 2: {
                        int n3;
                        String string2 = this.getNonNullText();
                        BreakIterator breakIterator = BreakIterator.getWordInstance();
                        breakIterator.setText(string2);
                        int n4 = breakIterator.following(n2);
                        if (n4 != -1 && n4 < string2.length() && (n3 = breakIterator.following(n4)) != -1 && n3 < string2.length()) {
                            string = string2.substring(n4, n3);
                        }
                        break;
                    }
                    case 3: {
                        int n5;
                        String string3 = this.getNonNullText();
                        BreakIterator breakIterator = BreakIterator.getSentenceInstance();
                        breakIterator.setText(string3);
                        int n6 = breakIterator.following(n2);
                        if (n6 == -1 || n6 >= string3.length() || (n5 = breakIterator.following(n6)) == -1 || n5 >= string3.length()) break;
                        string = string3.substring(n6, n5);
                    }
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            return string;
        }

        public final String getBeforeIndex(int n, int n2) {
            String string = null;
            if (n2 >= 0 && n2 <= this.getCharCount() - 1) {
                try {
                    switch (n) {
                        case 1: {
                            string = this.getText(n2 - 1);
                            break;
                        }
                        case 2: {
                            String string2 = this.getNonNullText();
                            BreakIterator breakIterator = BreakIterator.getWordInstance();
                            breakIterator.setText(string2);
                            int n3 = breakIterator.following(n2);
                            n3 = breakIterator.previous();
                            int n4 = breakIterator.previous();
                            if (n4 != -1) {
                                string = string2.substring(n4, n3);
                            }
                            break;
                        }
                        case 3: {
                            String string3 = this.getNonNullText();
                            BreakIterator breakIterator = BreakIterator.getSentenceInstance();
                            breakIterator.setText(string3);
                            int n5 = breakIterator.following(n2);
                            n5 = breakIterator.previous();
                            int n6 = breakIterator.previous();
                            if (n6 == -1) break;
                            string = string3.substring(n6, n5);
                        }
                    }
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            return string;
        }

        public final AttributeSet getCharacterAttribute(int n) {
            return null;
        }

        public final int getSelectionStart() {
            int n = this.getCharCount();
            return n;
        }

        public final int getSelectionEnd() {
            int n = this.getCharCount();
            return n;
        }

        public final String getSelectedText() {
            return "";
        }

        public final class 1
        implements Runnable {
            private final /* synthetic */ String v$s;
            final /* synthetic */ AccessibleKeyStrokeField this$0;

            public void run() {
                this.this$0.firePropertyChange("AccessibleText", null, this.v$s);
                this.this$0.firePropertyChange("AccessibleCaret", new Integer(0), new Integer(this.v$s.length()));
            }

            public 1(AccessibleKeyStrokeField accessibleKeyStrokeField, String string) {
                this.v$s = string;
                this.this$0 = accessibleKeyStrokeField;
            }
        }
    }
}

