/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.keyboard;

import java.awt.event.KeyEvent;
import java.util.BitSet;
import javax.swing.KeyStroke;
import oracle.ide.keyboard.KeyUtil;

public final class KeyStrokeFilter {
    private final BitSet _bs;
    private KeyStroke _ks;
    private int _lastKeyCode;
    private int _lastMod;

    void $init$() {
        this._bs = new BitSet();
    }

    public void clear() {
        this._bs.andNot(this._bs);
        this._ks = null;
        this._lastKeyCode = 0;
        this._lastMod = 0;
    }

    public boolean keyPressed(int n, int n2) {
        boolean bl = false;
        this._lastMod = n2;
        if (n != 0) {
            if (!KeyUtil.isModifierKey(n)) {
                this._ks = KeyStroke.getKeyStroke(n, this._lastMod);
                this._lastKeyCode = n;
                bl = true;
            }
            this._bs.set(n);
        }
        return bl;
    }

    boolean isRepeat(KeyStroke keyStroke) {
        int n = keyStroke.getKeyCode();
        boolean bl = this._bs.get(n);
        return bl;
    }

    public void keyReleased(int n, int n2) {
        this._lastMod = n2;
        this._bs.clear(n);
        this._lastKeyCode = 0;
    }

    public boolean keyPressed(KeyEvent keyEvent) {
        return this.keyPressed(keyEvent.getKeyCode(), keyEvent.getModifiers());
    }

    public void keyReleased(KeyEvent keyEvent) {
        this.keyReleased(keyEvent.getKeyCode(), keyEvent.getModifiers());
    }

    public boolean keyStroke(KeyStroke keyStroke) {
        if (keyStroke.isOnKeyRelease()) {
            this.keyReleased(keyStroke.getKeyCode(), keyStroke.getModifiers());
            return false;
        }
        return this.keyPressed(keyStroke.getKeyCode(), keyStroke.getModifiers());
    }

    public KeyStroke getKeyStroke() {
        return this._ks;
    }

    boolean areAllKeysUp() {
        return this._bs.length() == 0;
    }

    public String toString(boolean bl) {
        StringBuffer stringBuffer = null;
        if (bl && this._lastMod != 0) {
            stringBuffer = new StringBuffer();
            stringBuffer.append(KeyEvent.getKeyModifiersText(this._lastMod));
            stringBuffer.append("+");
        }
        if (this._lastKeyCode != 0) {
            if (stringBuffer == null) {
                stringBuffer = new StringBuffer();
            }
            stringBuffer.append(KeyEvent.getKeyText(this._lastKeyCode));
        }
        return stringBuffer == null ? null : stringBuffer.toString();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("[_bs=");
        int n = this._bs.length();
        int n2 = 0;
        while (n2 < n) {
            if (this._bs.get(n2)) {
                stringBuffer.append(KeyEvent.getKeyText(n2));
                stringBuffer.append(" ");
            }
            ++n2;
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public KeyStrokeFilter() {
        this.$init$();
    }
}

