/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.keyboard;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.KeyStroke;
import oracle.ide.Ide;
import oracle.ide.keyboard.KeyStrokes;
import oracle.ide.util.Pair;

public final class KeyStrokeMap
implements Serializable {
    private final HashMap _map;
    private final ArrayList _list;
    private ArrayList _postponedLoad;

    public KeyStrokeMap() {
        this.$init$();
    }

    void $init$() {
        this._map = new HashMap();
        this._list = new ArrayList();
    }

    public KeyStrokeMap cloneObject() {
        KeyStrokeMap keyStrokeMap = new KeyStrokeMap();
        keyStrokeMap.assign(this);
        return keyStrokeMap;
    }

    public void assign(KeyStrokeMap keyStrokeMap) {
        this.removeAll();
        this.putAll(keyStrokeMap);
        if (keyStrokeMap._postponedLoad != null) {
            this._postponedLoad = new ArrayList(keyStrokeMap._postponedLoad);
        }
    }

    private Integer getBindAt(int n) {
        Pair pair = (Pair)this._list.get(n);
        return (Integer)pair.first;
    }

    private KeyStrokes getKeyStrokesAt(int n) {
        Pair pair = (Pair)this._list.get(n);
        return (KeyStrokes)pair.second;
    }

    private int binarySearchAny(int n) {
        int n2 = 0;
        int n3 = this._list.size() - 1;
        while (n2 <= n3) {
            int n4 = (n2 + n3) / 2;
            int n5 = this.getBindAt(n4);
            if (n5 < n) {
                n2 = n4 + 1;
                continue;
            }
            if (n5 > n) {
                n3 = n4 - 1;
                continue;
            }
            return n4;
        }
        return -(n2 + 1);
    }

    private int binarySearchFirst(int n) {
        int n2 = this.binarySearchAny(n);
        while (n2 > 0 && this.getBindAt(n2 - 1) == n) {
            --n2;
        }
        return n2;
    }

    public boolean put(KeyStrokes keyStrokes, Integer n) {
        boolean bl = false;
        if (!this._map.containsKey(keyStrokes)) {
            int n2 = this.binarySearchFirst(n);
            if (n2 >= 0) {
                int n3 = this._list.size();
                while (n2 < n3 && this.getBindAt(n2).equals(n)) {
                    ++n2;
                }
            } else {
                n2 = -n2 - 1;
            }
            this._list.add(n2, new Pair(n, keyStrokes));
            this._map.put(keyStrokes, n);
            bl = true;
        }
        return bl;
    }

    public void putAll(KeyStrokeMap keyStrokeMap) {
        int n = keyStrokeMap._list.size();
        int n2 = 0;
        while (n2 < n) {
            Integer n3 = keyStrokeMap.getBindAt(n2);
            KeyStrokes keyStrokes = keyStrokeMap.getKeyStrokesAt(n2);
            this.put(keyStrokes, n3);
            ++n2;
        }
    }

    void removeAll() {
        this._list.clear();
        this._map.clear();
    }

    public void remove(KeyStrokes keyStrokes) {
        Iterator iterator = this._list.iterator();
        while (iterator.hasNext()) {
            Pair pair = (Pair)iterator.next();
            KeyStrokes keyStrokes2 = (KeyStrokes)pair.second;
            if (!keyStrokes.equals(keyStrokes2)) continue;
            iterator.remove();
        }
        this._map.remove(keyStrokes);
    }

    public Set keySet() {
        return this._map.keySet();
    }

    public Collection values() {
        return this._map.values();
    }

    public List getKeyStrokesFor(Integer n) {
        return this.getKeyStrokesFor((int)n);
    }

    public List getKeyStrokesFor(int n) {
        ArrayList<KeyStrokes> arrayList = null;
        int n2 = this.binarySearchFirst(n);
        if (n2 >= 0) {
            int n3 = this._list.size();
            while (n2 < n3 && this.getBindAt(n2) == n) {
                if (arrayList == null) {
                    arrayList = new ArrayList<KeyStrokes>(1);
                }
                arrayList.add(this.getKeyStrokesAt(n2));
                ++n2;
            }
        }
        return arrayList == null ? Collections.EMPTY_LIST : arrayList;
    }

    public Integer getBindingFor(KeyStrokes keyStrokes) {
        return (Integer)this._map.get(keyStrokes);
    }

    Collection getMultikeyKeystrokes() {
        HashSet<KeyStroke> hashSet = new HashSet<KeyStroke>();
        int n = 0;
        while (n < this._list.size()) {
            KeyStrokes keyStrokes = this.getKeyStrokesAt(n);
            int n2 = keyStrokes.getLength();
            int n3 = 0;
            while (n3 < n2 - 1) {
                hashSet.add(keyStrokes.getKeyStroke(n3));
                ++n3;
            }
            ++n;
        }
        return hashSet;
    }

    public List getKeyStrokesStartingWith(KeyStrokes keyStrokes) {
        ArrayList<KeyStrokes> arrayList = new ArrayList<KeyStrokes>();
        int n = this._list.size();
        int n2 = 0;
        while (n2 < n) {
            KeyStrokes keyStrokes2 = this.getKeyStrokesAt(n2);
            if (keyStrokes2.startWith(keyStrokes)) {
                arrayList.add(keyStrokes2);
            }
            ++n2;
        }
        return arrayList;
    }

    public ArrayList getData() {
        ArrayList<Pair> arrayList = new ArrayList<Pair>();
        int n = this._list.size();
        int n2 = 0;
        while (n2 < n) {
            String string;
            KeyStrokes keyStrokes = this.getKeyStrokesAt(n2);
            Integer n3 = this.getBindAt(n2);
            if (n3 != null && (string = Ide.findCmdName(n3)) != null) {
                arrayList.add(new Pair(string, keyStrokes));
            }
            ++n2;
        }
        if (this._postponedLoad != null) {
            for (Pair pair : this._postponedLoad) {
                KeyStrokes keyStrokes = (KeyStrokes)pair.first;
                String string = (String)pair.second;
                arrayList.add(new Pair(string, keyStrokes));
            }
        }
        return arrayList;
    }

    public void setData(ArrayList arrayList) {
        if (arrayList != null) {
            this.removeAll();
            int n = arrayList.size();
            int n2 = 0;
            while (n2 < n) {
                Pair pair = (Pair)arrayList.get(n2);
                KeyStrokes keyStrokes = (KeyStrokes)pair.second;
                if (keyStrokes != null && keyStrokes.isValid()) {
                    String string = (String)pair.first;
                    this.addPostponedLoad(keyStrokes, string);
                }
                ++n2;
            }
        }
    }

    boolean addMap(KeyStrokes keyStrokes, String string) {
        Integer n = Ide.findCmdID(string);
        if (n == null) {
            return false;
        }
        if (!this.put(keyStrokes, n)) {
            // empty if block
        }
        return true;
    }

    private void addPostponedLoad(KeyStrokes keyStrokes, String string) {
        if (this._postponedLoad == null) {
            this._postponedLoad = new ArrayList(50);
        }
        this._postponedLoad.add(new Pair(keyStrokes, string));
    }

    public boolean solvePostponedLoad() {
        boolean bl = true;
        if (this._postponedLoad != null) {
            Iterator iterator = this._postponedLoad.iterator();
            while (iterator.hasNext()) {
                Pair pair = (Pair)iterator.next();
                KeyStrokes keyStrokes = (KeyStrokes)pair.first;
                String string = (String)pair.second;
                if (!this.addMap(keyStrokes, string)) continue;
                iterator.remove();
            }
            if (this._postponedLoad.isEmpty()) {
                this._postponedLoad = null;
            } else {
                bl = false;
            }
        }
        return bl;
    }
}

