/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.keyboard;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.KeyStroke;
import javax.swing.event.EventListenerList;
import oracle.ide.keyboard.KeyStrokes;

final class KeyStrokeModel {
    private final ArrayList _ks;
    private final EventListenerList _listenerList;
    private ActionEvent _actionEvent;
    private static final int _nMaxKeySequence = 2;

    void $init$() {
        this._ks = new ArrayList(2);
        this._listenerList = new EventListenerList();
        this._actionEvent = null;
    }

    public void addActionListener(ActionListener actionListener) {
        this._listenerList.add(ActionListener.class, actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this._listenerList.remove(ActionListener.class, actionListener);
    }

    protected void fireActionEvent() {
        Object[] objectArray = this._listenerList.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == ActionListener.class) {
                if (this._actionEvent == null) {
                    this._actionEvent = new ActionEvent(this, 0, null);
                }
                ActionListener actionListener = (ActionListener)objectArray[n + 1];
                actionListener.actionPerformed(this._actionEvent);
            }
            n -= 2;
        }
    }

    KeyStrokes getKeyStrokes() {
        switch (this._ks.size()) {
            case 0: {
                return new KeyStrokes();
            }
            case 1: {
                return new KeyStrokes(this.get(0));
            }
            case 2: {
                return new KeyStrokes(this.get(0), this.get(1));
            }
        }
        return null;
    }

    KeyStroke get(int n) {
        return (KeyStroke)this._ks.get(n);
    }

    KeyStroke top() {
        KeyStroke keyStroke = null;
        int n = this.size();
        if (n != 0) {
            keyStroke = this.get(n - 1);
        }
        return keyStroke;
    }

    void add(KeyStroke keyStroke) {
        this._ks.add(keyStroke);
        this.fireActionEvent();
    }

    void pop() {
        int n = this._ks.size();
        if (n != 0) {
            this._ks.remove(n - 1);
            this.fireActionEvent();
        }
    }

    void clear() {
        this._ks.clear();
        this.fireActionEvent();
    }

    int size() {
        return this._ks.size();
    }

    boolean isEmpty() {
        return this._ks.isEmpty();
    }

    boolean authorizeNewKeys() {
        return this.size() < 2;
    }

    KeyStrokeModel() {
        this.$init$();
    }
}

