/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.keyboard;

import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import oracle.ide.Ide;
import oracle.ide.config.ChangeEventSource;
import oracle.ide.keyboard.KeyStrokeContext;
import oracle.ide.keyboard.KeyStrokeContextRegistry;
import oracle.ide.keyboard.KeyStrokeMap;
import oracle.ide.keyboard.KeyboardDockable;
import oracle.ide.layout.IdeProperties;
import oracle.javatools.marshal.TransientMarker;
import oracle.javatools.util.Copyable;

public final class KeyStrokeOptions
extends ChangeEventSource
implements Copyable {
    static final boolean DEBUG = false;
    public static final String KEY_SETTINGS = KeyStrokeOptions.class.getName();
    private ArrayList _postponedContexts;
    private String _presetName;
    private boolean _bModifiedPreset;
    private KeyStrokeMap _ksmGlobal;
    private HashMap _mapKsmLocal;
    private final ArrayList _knownContexts;
    private ActionListener _keyboardPanelEventDispatcher;

    void $init$() {
        this._knownContexts = new ArrayList(20);
    }

    public KeyStrokeOptions() {
        this.$init$();
    }

    public Object copyTo(Object object) {
        KeyStrokeOptions keyStrokeOptions = object != null ? (KeyStrokeOptions)object : new KeyStrokeOptions();
        this.copyToImpl(keyStrokeOptions);
        return keyStrokeOptions;
    }

    private final void copyToImpl(KeyStrokeOptions keyStrokeOptions) {
        keyStrokeOptions.assign(this, true);
    }

    public KeyStrokeOptions cloneObject(boolean bl) {
        KeyStrokeOptions keyStrokeOptions = new KeyStrokeOptions();
        keyStrokeOptions.assign(this, bl);
        return keyStrokeOptions;
    }

    void assign(KeyStrokeOptions keyStrokeOptions, boolean bl) {
        this._presetName = keyStrokeOptions._presetName;
        this._bModifiedPreset = keyStrokeOptions._bModifiedPreset;
        this._keyboardPanelEventDispatcher = keyStrokeOptions._keyboardPanelEventDispatcher;
        if (bl) {
            this._ksmGlobal = keyStrokeOptions._ksmGlobal.cloneObject();
            if (keyStrokeOptions._mapKsmLocal != null) {
                this._mapKsmLocal = new HashMap(keyStrokeOptions._mapKsmLocal.size());
                for (Map.Entry entry : keyStrokeOptions._mapKsmLocal.entrySet()) {
                    KeyStrokeMap keyStrokeMap = (KeyStrokeMap)entry.getValue();
                    this._mapKsmLocal.put(entry.getKey(), keyStrokeMap.cloneObject());
                }
            }
        } else {
            this._ksmGlobal = keyStrokeOptions._ksmGlobal;
            this._mapKsmLocal = keyStrokeOptions._mapKsmLocal;
        }
        this.fireChangeEvent();
    }

    public String getPresetName() {
        if (this._presetName == null) {
            this._presetName = Ide.getProperty("DefaultKeyMapping", "Default");
        }
        return this._presetName;
    }

    public void setPresetName(String string) {
        this._presetName = string;
    }

    public boolean isModifiedPreset() {
        return this._bModifiedPreset;
    }

    public void setModifiedPreset(boolean bl) {
        this._bModifiedPreset = bl;
    }

    public KeyStrokeMap getLocalKeyMap(KeyStrokeContext keyStrokeContext) {
        KeyStrokeMap keyStrokeMap = null;
        if (this._mapKsmLocal != null) {
            keyStrokeMap = (KeyStrokeMap)this._mapKsmLocal.get(keyStrokeContext.getName());
        }
        return keyStrokeMap;
    }

    void loadPreset(KeyStrokeContextRegistry keyStrokeContextRegistry, String string) {
        this._ksmGlobal.removeAll();
        Iterator iterator = keyStrokeContextRegistry.getAllContexts();
        while (iterator.hasNext()) {
            KeyStrokeMap keyStrokeMap;
            KeyStrokeContext keyStrokeContext = (KeyStrokeContext)iterator.next();
            String string2 = keyStrokeContext.getName();
            Object object = KeyStrokeContextRegistry.searchPreset(keyStrokeContext, string);
            KeyStrokeMap keyStrokeMap2 = keyStrokeContext.getPresetKeyStrokeMap(object, true);
            if (keyStrokeMap2 != null) {
                this._ksmGlobal.putAll(keyStrokeMap2);
            }
            if ((keyStrokeMap = keyStrokeContext.getPresetKeyStrokeMap(object, false)) != null) {
                this._mapKsmLocal.put(string2, keyStrokeMap);
                continue;
            }
            this._mapKsmLocal.remove(string2);
        }
        this.setPresetName(string);
        this._bModifiedPreset = false;
        this.fireChangeEvent();
    }

    public void addContext(KeyStrokeContext keyStrokeContext) {
        if (this._postponedContexts == null) {
            this._postponedContexts = new ArrayList(20);
        }
        this._postponedContexts.add(keyStrokeContext);
    }

    public void solvePostponedMaps() {
        this.checkShowKeyboardDockable();
        String string = this.getPresetName();
        int n = this._postponedContexts.size();
        if (this._mapKsmLocal == null) {
            this._mapKsmLocal = new HashMap();
        }
        int n2 = 0;
        while (n2 < n) {
            KeyStrokeContext keyStrokeContext = (KeyStrokeContext)this._postponedContexts.get(n2);
            if (!this._knownContexts.contains(keyStrokeContext.getName())) {
                this._knownContexts.add(keyStrokeContext.getName());
                Object object = KeyStrokeContextRegistry.searchPreset(keyStrokeContext, string);
                KeyStrokeMap keyStrokeMap = keyStrokeContext.getPresetKeyStrokeMap(object, true);
                if (keyStrokeMap != null) {
                    KeyStrokeMap keyStrokeMap2 = this.getGlobalKeyMap();
                    keyStrokeMap2.putAll(keyStrokeMap);
                }
                if ((keyStrokeMap = keyStrokeContext.getPresetKeyStrokeMap(object, false)) != null) {
                    this._mapKsmLocal.put(keyStrokeContext.getName(), keyStrokeMap);
                }
            }
            ++n2;
        }
        if (this._ksmGlobal != null) {
            this._ksmGlobal.solvePostponedLoad();
        }
        for (KeyStrokeMap keyStrokeMap : this._mapKsmLocal.values()) {
            keyStrokeMap.solvePostponedLoad();
        }
        this.fireChangeEvent();
    }

    private void checkShowKeyboardDockable() {
        IdeProperties ideProperties = Ide.getIdeProperties();
        if (Ide.getIdeArgs().hasArg("-abracadabra") || Boolean.valueOf(ideProperties.getProperty("SHOW_KEYBOARD_DOCKABLE", "false")).booleanValue()) {
            this.showKeyboardDockable();
        }
    }

    private void showKeyboardDockable() {
        KeyboardDockable.initialize();
    }

    public void removeContext(KeyStrokeContext keyStrokeContext) {
        if (this._mapKsmLocal != null) {
            this._mapKsmLocal.remove(keyStrokeContext.getName());
        }
    }

    public void setKeyboardPanelEventDispatcher(ActionListener actionListener) throws TransientMarker {
        this._keyboardPanelEventDispatcher = actionListener;
    }

    ActionListener getKeyboardPanelEventDispatcher() throws TransientMarker {
        return this._keyboardPanelEventDispatcher;
    }

    public KeyStrokeMap getGlobalKeyMap() {
        if (this._ksmGlobal == null) {
            this._ksmGlobal = new KeyStrokeMap();
        }
        return this._ksmGlobal;
    }

    public void setGlobalKeyMap(KeyStrokeMap keyStrokeMap) {
        this._ksmGlobal = keyStrokeMap;
    }

    public void setLocalKeyMaps(HashMap hashMap) {
        this._mapKsmLocal = hashMap;
    }

    public HashMap getLocalKeyMaps() {
        return this._mapKsmLocal;
    }

    public ArrayList getRegisteredContexts() {
        return this._knownContexts;
    }

    public void setRegisteredContexts(ArrayList arrayList) {
        this._knownContexts.addAll(arrayList);
    }
}

