/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.keyboard;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.ide.Ide;
import oracle.ide.config.IdeSettings;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.JMultiLineLabel;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.help.HelpSystem;
import oracle.ide.keyboard.KeyStrokeContext;
import oracle.ide.keyboard.KeyStrokeContextRegistry;
import oracle.ide.keyboard.KeyStrokeField;
import oracle.ide.keyboard.KeyStrokeMap;
import oracle.ide.keyboard.KeyStrokeOptions;
import oracle.ide.keyboard.KeyStrokes;
import oracle.ide.keyboard.KeyStrokesConstraint;
import oracle.ide.keyboard.KeyStrokesConstraintFactory;
import oracle.ide.keyboard.PresetsPanel;
import oracle.ide.keyboard.XMLKeystrokeContextDefs;
import oracle.ide.nulls.NullIcon;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.resource.IdeArb;
import oracle.ide.util.ResourceUtils;

public final class KeyStrokePanel
extends DefaultTraversablePanel
implements ActionListener,
ListSelectionListener,
KeyStrokesConstraint {
    private static final int WIDTH_COL1 = 200;
    private static final int WIDTH_COL2 = 150;
    private final Icon NULL_ICON;
    private String _sOthersCategory;
    private String _sAllCategory;
    private KeyStrokeOptions _kso;
    private final DefaultComboBoxModel _catModel;
    private JComboBox _jcbCategory;
    private JList _jlActions;
    private JList _jlShortcuts;
    private KeyStrokeField _jksNewShortcut;
    private JTextField _jlblCurrentAssign;
    private JButton _jbRemove;
    private JButton _jbPresets;
    private JButton _jbAdd;

    void $init$() {
        this.NULL_ICON = new NullIcon();
        this._catModel = new DefaultComboBoxModel();
    }

    public KeyStrokePanel() {
        this.$init$();
        this.setHelpID("f1_idedidesetshortcuts_html");
        this._sOthersCategory = IdeArb.getString(308);
        this._sAllCategory = IdeArb.getString(307);
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this._jksNewShortcut.setConstraint(this);
        this.fillCategories();
    }

    public void onEntry(TraversableContext traversableContext) {
        if (this._kso == null) {
            KeyStrokeContextRegistry keyStrokeContextRegistry = Ide.getKeyStrokeContextRegistry();
            keyStrokeContextRegistry.loadAcceleratorDefinitionFiles();
            IdeSettings ideSettings = (IdeSettings)traversableContext.find("ide-options");
            this._kso = ideSettings.getKeyStrokeOptions();
            ActionEvent actionEvent = new ActionEvent(this, 1001, "showing");
            this._kso.getKeyboardPanelEventDispatcher().actionPerformed(actionEvent);
        }
    }

    public void onExit(TraversableContext traversableContext) {
    }

    public boolean isAcceptableKey(KeyStrokes keyStrokes, KeyStroke keyStroke) {
        KeyStrokesConstraint keyStrokesConstraint = KeyStrokesConstraintFactory.getConstraint(0);
        return keyStrokesConstraint == null ? true : keyStrokesConstraint.isAcceptableKey(keyStrokes, keyStroke);
    }

    private void jbInit() throws Exception {
        this._jcbCategory = new JComboBox(this._catModel);
        this._jlActions = new JList(new DefaultListModel());
        this._jlShortcuts = new JList(new DefaultListModel());
        this._jksNewShortcut = new KeyStrokeField();
        this._jlblCurrentAssign = new JTextField();
        this._jbRemove = new JButton();
        this._jbAdd = new JButton();
        this._jbPresets = new JButton();
        JLabel jLabel = new JLabel();
        JScrollPane jScrollPane = new JScrollPane(this._jlActions);
        this.setActionRenderer(this._jlActions);
        JLabel jLabel2 = new JLabel();
        JScrollPane jScrollPane2 = new JScrollPane(this._jlShortcuts);
        JLabel jLabel3 = new JLabel();
        JLabel jLabel4 = new JLabel();
        JPanel jPanel = new JPanel();
        ResourceUtils.resLabel(jLabel, this._jlActions, IdeArb.getString(309));
        ResourceUtils.resLabel(jLabel2, this._jlShortcuts, IdeArb.getString(310));
        ResourceUtils.resButton(this._jbRemove, IdeArb.getString(311));
        ResourceUtils.resLabel(jLabel3, this._jksNewShortcut, IdeArb.getString(312));
        ResourceUtils.resButton(this._jbAdd, IdeArb.getString(313));
        ResourceUtils.resButton(this._jbPresets, IdeArb.getString(319));
        ResourceUtils.resLabel(jLabel4, this._jlblCurrentAssign, IdeArb.getString(314));
        this._jbAdd.setEnabled(false);
        this._jlActions.setSelectionMode(0);
        this._jlShortcuts.setSelectionMode(2);
        this._jksNewShortcut.setMinimumSize(new Dimension(4, 21));
        this._jksNewShortcut.setEnabled(false);
        this._jbRemove.setEnabled(false);
        this._jbRemove.addActionListener(this);
        this._jbAdd.addActionListener(this);
        this._jbPresets.addActionListener(this);
        this._jlblCurrentAssign.setColumns(5);
        this._jlblCurrentAssign.setEditable(false);
        this.setLayout(new GridBagLayout());
        this._jcbCategory.addActionListener(this);
        this._jlActions.getSelectionModel().addListSelectionListener(this);
        this._jlShortcuts.getSelectionModel().addListSelectionListener(this);
        this._jksNewShortcut.getModel().addActionListener(this);
        int n = 0;
        if (this.hasCategories()) {
            JLabel jLabel5 = new JLabel();
            ResourceUtils.resLabel(jLabel5, this._jcbCategory, IdeArb.getString(315));
            this.add((Component)jLabel5, new GridBagConstraints(0, n++, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 2, 1, 5), 0, 0));
            this.add((Component)this._jcbCategory, new GridBagConstraints(0, n++, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 2, 5, 5), 0, 0));
        }
        this.add((Component)jLabel, new GridBagConstraints(0, n++, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 2, 1, 5), 0, 0));
        this.add((Component)jScrollPane, new GridBagConstraints(0, n, 1, 10 - n, 1.0, 1.0, 10, 1, new Insets(0, 2, 1, 5), 0, 0));
        this.add((Component)jLabel2, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 2, 1, 5), 0, 0));
        this.add((Component)jScrollPane2, new GridBagConstraints(1, 1, 1, 3, 0.0, 1.0, 10, 1, new Insets(0, 2, 5, 5), 0, 0));
        this.add((Component)this._jbRemove, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 2, 1, 0), 0, 0));
        this.add((Component)jLabel3, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 2, 1, 5), 0, 0));
        this.add((Component)this._jksNewShortcut, new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 18, 2, new Insets(0, 2, 5, 5), 0, 0));
        this.add((Component)this._jbAdd, new GridBagConstraints(2, 5, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 2, 5, 0), 0, 0));
        this.add((Component)jLabel4, new GridBagConstraints(1, 6, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 2, 1, 5), 0, 0));
        this.add((Component)this._jlblCurrentAssign, new GridBagConstraints(1, 7, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 2, 1, 5), 0, 0));
        this.add((Component)this._jbPresets, new GridBagConstraints(1, 8, 2, 2, 0.0, 0.0, 14, 0, new Insets(0, 2, 1, 0), 0, 0));
        this.add((Component)jPanel, new GridBagConstraints(1, 9, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 2, 1));
        KeyStrokePanel.adjustPreferredWidth(this._jcbCategory, 200);
        jScrollPane.setPreferredSize(new Dimension(200, 300));
        jScrollPane2.setPreferredSize(new Dimension(150, 100));
        KeyStrokePanel.adjustPreferredWidth(this._jksNewShortcut, 150);
        KeyStrokePanel.adjustPreferredWidth(this._jlblCurrentAssign, 150);
    }

    private static final void adjustPreferredWidth(JComponent jComponent, int n) {
        Dimension dimension = jComponent.getPreferredSize();
        dimension.width = n;
        jComponent.setPreferredSize(dimension);
    }

    private void setActionRenderer(JList jList) {
        jList.setCellRenderer(new 1());
    }

    private void fillCategories() {
        Set set = this.getDistinctCategories();
        this._catModel.addElement(this._sAllCategory);
        boolean bl = false;
        for (String string : set) {
            if (string != this._sOthersCategory) {
                this._catModel.addElement(string);
                continue;
            }
            bl = true;
        }
        if (bl) {
            this._catModel.addElement(this._sOthersCategory);
        }
    }

    private void fillActions() {
        String string = (String)this._jcbCategory.getSelectedItem();
        TreeSet treeSet = new TreeSet();
        Iterator iterator = KeyStrokePanel.getAllContexts();
        while (iterator.hasNext()) {
            KeyStrokeContext keyStrokeContext = (KeyStrokeContext)iterator.next();
            this.fillActions(treeSet, string, keyStrokeContext, true);
            this.fillActions(treeSet, string, keyStrokeContext, false);
        }
        this._jlActions.getSelectionModel().clearSelection();
        DefaultListModel defaultListModel = (DefaultListModel)this._jlActions.getModel();
        defaultListModel.removeAllElements();
        Iterator iterator2 = treeSet.iterator();
        while (iterator2.hasNext()) {
            defaultListModel.addElement(iterator2.next());
        }
    }

    private void fillActions(Set set, String string, KeyStrokeContext keyStrokeContext, boolean bl) {
        Set set2 = KeyStrokePanel.getAllActions(keyStrokeContext, bl);
        if (set2 != null) {
            for (IdeAction ideAction : set2) {
                if (string != this._sAllCategory && !string.equalsIgnoreCase(this.getCategory(ideAction))) continue;
                set.add(new ActionElement(keyStrokeContext, ideAction, bl));
            }
        }
    }

    private void fillShortcuts() {
        ListSelectionModel listSelectionModel = this._jlShortcuts.getSelectionModel();
        listSelectionModel.clearSelection();
        DefaultListModel defaultListModel = (DefaultListModel)this._jlShortcuts.getModel();
        defaultListModel.removeAllElements();
        ActionElement actionElement = (ActionElement)this._jlActions.getSelectedValue();
        if (actionElement != null) {
            IdeAction ideAction = actionElement._act;
            KeyStrokeMap keyStrokeMap = this._kso.getGlobalKeyMap();
            KeyStrokePanel.fillShortcuts(keyStrokeMap, ideAction, defaultListModel);
            Iterator iterator = KeyStrokePanel.getAllContexts();
            while (iterator.hasNext()) {
                KeyStrokeContext keyStrokeContext = (KeyStrokeContext)iterator.next();
                keyStrokeMap = this._kso.getLocalKeyMap(keyStrokeContext);
                KeyStrokePanel.fillShortcuts(keyStrokeMap, ideAction, defaultListModel);
            }
        }
        listSelectionModel.setSelectionInterval(0, defaultListModel.getSize() - 1);
    }

    private static void fillShortcuts(KeyStrokeMap keyStrokeMap, IdeAction ideAction, DefaultListModel defaultListModel) {
        if (keyStrokeMap != null) {
            List list = keyStrokeMap.getKeyStrokesFor(new Integer(ideAction.getCommandId()));
            for (KeyStrokes keyStrokes : list) {
                defaultListModel.addElement(new ShortcutElement(keyStrokeMap, keyStrokes));
            }
        }
    }

    private int getCurrentAssign(KeyStrokeMap keyStrokeMap, KeyStrokes keyStrokes, int n, StringBuffer stringBuffer) {
        KeyStrokes keyStrokes2;
        Integer n2;
        IdeAction ideAction;
        List list;
        int n3;
        if (keyStrokeMap != null && (n += (n3 = (list = keyStrokeMap.getKeyStrokesStartingWith(keyStrokes)).size())) == 1 && n == list.size() && (ideAction = this.searchAction(n2 = keyStrokeMap.getBindingFor(keyStrokes2 = (KeyStrokes)list.get(0)))) != null) {
            String string = this.getCategory(ideAction);
            if (string != null) {
                stringBuffer.append(string + ".");
            }
            stringBuffer.append(KeyStrokePanel.getName(ideAction));
        }
        return n;
    }

    private void fillCurrentAssign(KeyStrokes keyStrokes) {
        int n = 0;
        StringBuffer stringBuffer = new StringBuffer();
        if (!keyStrokes.isEmpty()) {
            KeyStrokeMap keyStrokeMap = this._kso.getGlobalKeyMap();
            n = this.getCurrentAssign(keyStrokeMap, keyStrokes, n, stringBuffer);
            Iterator iterator = KeyStrokePanel.getAllContexts();
            while (iterator.hasNext()) {
                KeyStrokeContext keyStrokeContext = (KeyStrokeContext)iterator.next();
                keyStrokeMap = this._kso.getLocalKeyMap(keyStrokeContext);
                n = this.getCurrentAssign(keyStrokeMap, keyStrokes, n, stringBuffer);
            }
        }
        switch (n) {
            case 0: {
                this._jlblCurrentAssign.setText("");
                break;
            }
            case 1: {
                this._jlblCurrentAssign.setText(stringBuffer.toString());
                break;
            }
            default: {
                this._jlblCurrentAssign.setText(IdeArb.getString(316));
            }
        }
    }

    private IdeAction searchAction(int n) {
        for (IdeAction ideAction : KeyStrokePanel.getAllActions()) {
            if (ideAction.getCommandId() != n) continue;
            return ideAction;
        }
        return null;
    }

    private void loadPreset(String string) {
        KeyStrokeContextRegistry keyStrokeContextRegistry = Ide.getKeyStrokeContextRegistry();
        this._kso.loadPreset(keyStrokeContextRegistry, string);
        this.fillShortcuts();
        this._jksNewShortcut.clear();
    }

    private void whenPreset() {
        String string = this._kso.getPresetName();
        Frame frame = (Frame)SwingUtilities.getAncestorOfClass(Frame.class, this);
        XMLKeystrokeContextDefs xMLKeystrokeContextDefs = XMLKeystrokeContextDefs.getInstance();
        String string2 = PresetsPanel.run(frame, string);
        if (string2 != null) {
            boolean bl = true;
            if (this._kso.isModifiedPreset()) {
                String string3 = IdeArb.getString(320);
                String string4 = IdeArb.getString(317);
                JMultiLineLabel jMultiLineLabel = new JMultiLineLabel(string3);
                HelpSystem.getHelpSystem().registerTopic((JComponent)((Object)jMultiLineLabel), "f1_idedloadpreset_html");
                bl = OnePageWizardDialogFactory.runDialog((Component)((Object)jMultiLineLabel), null, string4);
            }
            if (bl) {
                this.loadPreset(string2);
            }
        }
        xMLKeystrokeContextDefs.unload();
    }

    private void whenCategorySelectionChange() {
        this.fillActions();
    }

    private void actionSelectionChange() {
        this.fillShortcuts();
        Object e = this._jlActions.getSelectedValue();
        this._jksNewShortcut.getModel().clear();
        this._jksNewShortcut.setEnabled(e != null);
    }

    private void shortcutSelectionChange() {
        this._jbRemove.setEnabled(this._jlShortcuts.getSelectionModel().isSelectionEmpty() ^ true);
    }

    private void whenShortcutFieldChange() {
        KeyStrokes keyStrokes = this._jksNewShortcut.getModel().getKeyStrokes();
        this.fillCurrentAssign(keyStrokes);
        this._jbAdd.setEnabled(!keyStrokes.isEmpty());
    }

    private void whenRemove() {
        Object[] objectArray = this._jlShortcuts.getSelectedValues();
        int n = 0;
        while (n < objectArray.length) {
            ShortcutElement shortcutElement = (ShortcutElement)objectArray[n];
            shortcutElement._map.remove(shortcutElement._kss);
            this._kso.setModifiedPreset(true);
            ++n;
        }
        this.fillShortcuts();
    }

    private void whenAdd() {
        ActionElement actionElement;
        KeyStrokes keyStrokes = this._jksNewShortcut.getModel().getKeyStrokes();
        if (keyStrokes != null && (actionElement = (ActionElement)this._jlActions.getSelectedValue()) != null) {
            boolean bl = actionElement._bGlobal;
            KeyStrokeContext keyStrokeContext = actionElement._ksc;
            Iterator iterator = KeyStrokePanel.getAllContexts();
            while (iterator.hasNext()) {
                KeyStrokeContext keyStrokeContext2 = (KeyStrokeContext)iterator.next();
                this.removeShortcutsStartingWith(keyStrokeContext2, keyStrokes, true);
                if (!bl && keyStrokeContext2 != keyStrokeContext) continue;
                this.removeShortcutsStartingWith(keyStrokeContext2, keyStrokes, false);
            }
            KeyStrokeMap keyStrokeMap = bl ? this._kso.getGlobalKeyMap() : this._kso.getLocalKeyMap(keyStrokeContext);
            IdeAction ideAction = actionElement._act;
            keyStrokeMap.put(keyStrokes, new Integer(ideAction.getCommandId()));
            this._jksNewShortcut.clear();
            this._kso.setModifiedPreset(true);
            this.fillShortcuts();
        }
    }

    private void removeShortcutsStartingWith(KeyStrokeContext keyStrokeContext, KeyStrokes keyStrokes, boolean bl) {
        KeyStrokeMap keyStrokeMap = bl ? this._kso.getGlobalKeyMap() : this._kso.getLocalKeyMap(keyStrokeContext);
        KeyStrokePanel.removeShortcutsStartingWith(keyStrokeMap, keyStrokes);
    }

    private static void removeShortcutsStartingWith(KeyStrokeMap keyStrokeMap, KeyStrokes keyStrokes) {
        if (keyStrokeMap != null) {
            List list = keyStrokeMap.getKeyStrokesStartingWith(keyStrokes);
            for (KeyStrokes keyStrokes2 : list) {
                keyStrokeMap.remove(keyStrokes2);
            }
        }
    }

    private static String getName(IdeAction ideAction) {
        return (String)ideAction.getValue("Name");
    }

    private String getCategory(IdeAction ideAction) {
        String string = (String)ideAction.getValue("Category");
        if (string == null) {
            string = this._sOthersCategory;
        }
        return string;
    }

    private static Iterator getAllContexts() {
        KeyStrokeContextRegistry keyStrokeContextRegistry = Ide.getKeyStrokeContextRegistry();
        return keyStrokeContextRegistry.getAllContexts();
    }

    private static Set getAllActions() {
        HashSet hashSet = new HashSet();
        KeyStrokeContextRegistry keyStrokeContextRegistry = Ide.getKeyStrokeContextRegistry();
        Iterator iterator = keyStrokeContextRegistry.getAllContexts();
        while (iterator.hasNext()) {
            KeyStrokeContext keyStrokeContext = (KeyStrokeContext)iterator.next();
            int n = 0;
            while (n < 2) {
                Set set = KeyStrokePanel.getAllActions(keyStrokeContext, n == 0);
                if (set != null) {
                    hashSet.addAll(set);
                }
                ++n;
            }
        }
        return hashSet;
    }

    private static Set getAllActions(KeyStrokeContext keyStrokeContext, boolean bl) {
        Set set = keyStrokeContext.getAllActions(bl);
        if (set == null || set.remove(null)) {
            // empty if block
        }
        return set;
    }

    private Set getDistinctCategories() {
        TreeSet<String> treeSet = new TreeSet<String>();
        for (IdeAction ideAction : KeyStrokePanel.getAllActions()) {
            treeSet.add(this.getCategory(ideAction));
        }
        return treeSet;
    }

    private boolean hasCategories() {
        Set set = this.getDistinctCategories();
        return set.size() > 1;
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        Object object = listSelectionEvent.getSource();
        if (object == this._jlActions.getSelectionModel()) {
            this.actionSelectionChange();
        } else if (object == this._jlShortcuts.getSelectionModel()) {
            this.shortcutSelectionChange();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this._jbRemove) {
            this.whenRemove();
        } else if (object == this._jbAdd) {
            this.whenAdd();
        } else if (object == this._jbPresets) {
            this.whenPreset();
        } else if (object == this._jksNewShortcut.getModel()) {
            this.whenShortcutFieldChange();
        } else if (object == this._jcbCategory) {
            this.whenCategorySelectionChange();
        }
    }

    static Icon ra$NULL_ICON(KeyStrokePanel keyStrokePanel) {
        return keyStrokePanel.NULL_ICON;
    }

    public final class 1
    extends DefaultListCellRenderer {
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            Component component = super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            ActionElement actionElement = (ActionElement)object;
            Icon icon = (Icon)actionElement._act.getValue("SmallIcon");
            if (icon == null) {
                icon = KeyStrokePanel.ra$NULL_ICON(KeyStrokePanel.this);
            }
            this.setIcon(icon);
            return component;
        }
    }

    private static final class ActionElement
    implements Comparable {
        final IdeAction _act;
        final KeyStrokeContext _ksc;
        final boolean _bGlobal;

        ActionElement(KeyStrokeContext keyStrokeContext, IdeAction ideAction, boolean bl) {
            this._ksc = keyStrokeContext;
            this._act = ideAction;
            this._bGlobal = bl;
        }

        public final String toString() {
            String string = (String)this._act.getValue("NoCtxName");
            if (string != null && string.length() > 0) {
                return string;
            }
            return (String)this._act.getValue("Name");
        }

        public final int compareTo(Object object) {
            return String.CASE_INSENSITIVE_ORDER.compare(this.toString(), object.toString());
        }
    }

    private static final class ShortcutElement
    implements Comparable {
        final KeyStrokeMap _map;
        final KeyStrokes _kss;

        ShortcutElement(KeyStrokeMap keyStrokeMap, KeyStrokes keyStrokes) {
            this._map = keyStrokeMap;
            this._kss = keyStrokes;
        }

        public final String toString() {
            return this._kss.toString();
        }

        public final int compareTo(Object object) {
            KeyStrokes keyStrokes = (KeyStrokes)object;
            return this.toString().compareTo(keyStrokes.toString());
        }
    }
}

