/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.keyboard;

import java.io.Serializable;
import java.util.ArrayList;
import javax.swing.KeyStroke;
import oracle.ide.keyboard.KeyUtil;

public final class KeyStrokes
implements Serializable {
    private ArrayList _ks;

    public KeyStrokes() {
        this(null, null);
    }

    public KeyStrokes(KeyStroke keyStroke) {
        this(keyStroke, null);
    }

    public KeyStrokes(KeyStroke keyStroke, KeyStroke keyStroke2) {
        this._ks = new ArrayList(2);
        if (keyStroke != null) {
            this.add(keyStroke);
            if (keyStroke2 != null) {
                this.add(keyStroke2);
            }
        }
    }

    public KeyStrokes(int n, int n2) {
        this(KeyStroke.getKeyStroke(n2, n));
    }

    public KeyStrokes(int n, int n2, int n3) {
        this(KeyStroke.getKeyStroke(n2, n), KeyStroke.getKeyStroke(n3, 0));
    }

    public KeyStrokes(KeyStrokes keyStrokes) {
        this._ks = (ArrayList)keyStrokes._ks.clone();
    }

    public KeyStrokes(KeyStrokes keyStrokes, int n, int n2) {
        this(keyStrokes);
        this.add(KeyStroke.getKeyStroke(n2, n));
    }

    public void add(KeyStroke keyStroke) {
        if (keyStroke != null) {
            this._ks.add(keyStroke);
        }
    }

    public void removeLast() {
        int n = this.getLength();
        if (n > 0) {
            this._ks.remove(n - 1);
        }
    }

    public void clear() {
        this._ks.clear();
    }

    public KeyStroke getLast() {
        KeyStroke keyStroke = null;
        int n = this.getLength();
        if (n > 0) {
            keyStroke = this.getKeyStroke(n - 1);
        }
        return keyStroke;
    }

    public int getLength() {
        return this._ks.size();
    }

    public KeyStroke getKeyStroke(int n) {
        return (KeyStroke)this._ks.get(n);
    }

    public boolean isEmpty() {
        return this._ks.isEmpty();
    }

    public boolean startWith(KeyStrokes keyStrokes) {
        int n = Math.min(this.getLength(), keyStrokes.getLength());
        int n2 = 0;
        while (n2 < n) {
            if (!this._ks.get(n2).equals(keyStrokes._ks.get(n2))) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = null;
        int n = 0;
        while (n < this.getLength()) {
            KeyStroke keyStroke = this.getKeyStroke(n);
            if (string != null) {
                stringBuffer.append(string);
            }
            stringBuffer.append(KeyUtil.toString(keyStroke));
            string = ", ";
            ++n;
        }
        return stringBuffer.toString();
    }

    public int hashCode() {
        int n = 0;
        int n2 = this.getLength();
        int n3 = 0;
        while (n3 < n2) {
            n ^= this.getKeyStroke(n3).hashCode();
            ++n3;
        }
        return n;
    }

    public boolean equals(Object object) {
        if (object instanceof KeyStrokes) {
            KeyStrokes keyStrokes = (KeyStrokes)object;
            int n = this.getLength();
            if (n == keyStrokes.getLength()) {
                int n2 = 0;
                while (n2 < n) {
                    if (!this._ks.get(n2).equals(keyStrokes.getKeyStroke(n2))) {
                        return false;
                    }
                    ++n2;
                }
                return true;
            }
        }
        return false;
    }

    public ArrayList getData() {
        return this._ks;
    }

    public void setData(ArrayList arrayList) {
        this._ks.addAll(arrayList);
    }

    public boolean isValid() {
        return this.hasNullElements() ^ true;
    }

    private boolean hasNullElements() {
        int n = this.getLength();
        int n2 = 0;
        while (n2 < n) {
            if (this.getKeyStroke(n2) == null) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

