/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.keyboard;

import javax.swing.KeyStroke;
import oracle.ide.keyboard.KeyStrokes;
import oracle.ide.keyboard.KeyStrokesConstraint;
import oracle.ide.keyboard.KeyUtil;

public final class KeyStrokesConstraintFactory
implements KeyStrokesConstraint {
    public static final int TYPE_ALL = 0;
    public static final int TYPE_TEXT_EDITOR = 1;
    private static final KeyStrokesConstraint[] _store = new KeyStrokesConstraint[]{null, null};
    private final int _nType;

    private KeyStrokesConstraintFactory(int n) {
        this._nType = n;
    }

    public boolean isAcceptableKey(KeyStrokes keyStrokes, KeyStroke keyStroke) {
        switch (this._nType) {
            case 0: {
                return true;
            }
            case 1: {
                return !keyStrokes.isEmpty() || KeyUtil.isActionKey(keyStroke) || keyStroke.getKeyCode() == 127 || (keyStroke.getModifiers() & 0xFFFFFFFE) != 0;
            }
        }
        return false;
    }

    public static KeyStrokesConstraint getConstraint(int n) {
        if (_store[n] == null) {
            KeyStrokesConstraintFactory._store[n] = new KeyStrokesConstraintFactory(n);
        }
        return _store[n];
    }
}

