/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.keyboard;

import java.awt.AWTKeyStroke;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import oracle.ide.Ide;
import oracle.ide.config.IdeSettings;
import oracle.ide.controller.IdeAction;
import oracle.ide.keyboard.KeyStrokeMap;
import oracle.ide.keyboard.KeyStrokeOptions;
import oracle.ide.keyboard.KeyStrokes;
import oracle.ide.util.BitField;
import oracle.ide.util.JDK;
import oracle.ide.util.ModelUtil;
import oracle.javatools.util.SwingUtils;

public final class KeyUtil {
    private static final JPanel _actionKeyPanel = new JPanel();
    private static String ACCELERATOR_DELIMITER;

    public static String toString(KeyStroke keyStroke) {
        if (keyStroke == null) {
            return "";
        }
        int n = keyStroke.getKeyCode();
        if (n == 0) {
            return "";
        }
        int n2 = keyStroke.getModifiers();
        StringBuffer stringBuffer = new StringBuffer();
        if (n2 != 0) {
            stringBuffer.append(KeyUtil.getKeyModifiersText(n2) + KeyUtil.getAccelDelimiter());
        }
        stringBuffer.append(KeyEvent.getKeyText(keyStroke.getKeyCode()));
        return stringBuffer.toString();
    }

    private static String getAccelDelimiter() {
        if (ACCELERATOR_DELIMITER == null && (ACCELERATOR_DELIMITER = UIManager.getString("MenuItem.acceleratorDelimiter")) == null) {
            ACCELERATOR_DELIMITER = "+";
        }
        return ACCELERATOR_DELIMITER;
    }

    private static String getKeyModifiersText(int n) {
        if (!JDK.HAS_BUG_GETKEYMODIFIERSTEXT) {
            return KeyEvent.getKeyModifiersText(n);
        }
        StringBuffer stringBuffer = new StringBuffer();
        if ((n & 4) != 0) {
            stringBuffer.append(Toolkit.getProperty("AWT.meta", "Meta"));
            stringBuffer.append(KeyUtil.getAccelDelimiter());
        }
        if ((n & 2) != 0) {
            stringBuffer.append(Toolkit.getProperty("AWT.control", "Ctrl"));
            stringBuffer.append(KeyUtil.getAccelDelimiter());
        }
        if ((n & 8) != 0) {
            stringBuffer.append(Toolkit.getProperty("AWT.alt", "Alt"));
            stringBuffer.append(KeyUtil.getAccelDelimiter());
        }
        if ((n & 1) != 0) {
            stringBuffer.append(Toolkit.getProperty("AWT.shift", "Shift"));
            stringBuffer.append(KeyUtil.getAccelDelimiter());
        }
        if ((n & 0x20) != 0) {
            stringBuffer.append(Toolkit.getProperty("AWT.altGraph", "Alt Graph"));
            stringBuffer.append(KeyUtil.getAccelDelimiter());
        }
        if (stringBuffer.length() > 0) {
            stringBuffer.setLength(stringBuffer.length() - 1);
        }
        return stringBuffer.toString();
    }

    public static boolean isActionKey(KeyStroke keyStroke) {
        KeyEvent keyEvent = new KeyEvent(_actionKeyPanel, keyStroke.isOnKeyRelease() ? 401 : 402, 0L, keyStroke.getModifiers(), keyStroke.getKeyCode(), keyStroke.getKeyChar());
        return keyEvent.isActionKey();
    }

    public static boolean isModifierKey(int n) {
        return n == 17 || n == 16 || n == 18 || n == 65406 || n == 157;
    }

    public static boolean isModifierKey(KeyStroke keyStroke) {
        return KeyUtil.isModifierKey(keyStroke.getKeyCode());
    }

    public static void removeKeyStrokesFromInputMaps(JComponent jComponent, KeyStroke[] keyStrokeArray) {
        SwingUtils.removeKeyStrokesFromInputMaps((JComponent)jComponent, (KeyStroke[])keyStrokeArray);
    }

    public static void removeKeyStrokesFromInputMap(JComponent jComponent, KeyStroke[] keyStrokeArray, int n) {
        SwingUtils.removeKeyStrokesFromInputMap((JComponent)jComponent, (KeyStroke[])keyStrokeArray, (int)n);
    }

    public static String getAcceleratorTooltip(int n) {
        IdeSettings ideSettings = Ide.getSettings();
        KeyStrokeOptions keyStrokeOptions = ideSettings.getKeyStrokeOptions();
        KeyStrokeMap keyStrokeMap = keyStrokeOptions.getGlobalKeyMap();
        return KeyUtil.getAcceleratorTooltip(keyStrokeMap, n);
    }

    public static String getAcceleratorTooltip(KeyStrokeMap keyStrokeMap, int n) {
        KeyStroke keyStroke = KeyUtil.getBestAccelerator(keyStrokeMap, n);
        return keyStroke != null ? KeyUtil.toString(keyStroke) : "";
    }

    public static String buildTooltip(int n) {
        IdeAction ideAction = IdeAction.find(n);
        return ideAction != null ? KeyUtil.buildToolTip(ideAction) : "";
    }

    public static String buildToolTip(IdeAction ideAction) {
        String string;
        Object object = ideAction.getValue("ShortDescription");
        if (object == null) {
            object = ideAction.getValue("Name");
        }
        String string2 = string = object != null ? object.toString() : null;
        if (!ModelUtil.hasLength((String)string)) {
            return null;
        }
        String string3 = KeyUtil.getAcceleratorTooltip(ideAction.getCommandId());
        return ModelUtil.hasLength((String)string3) ? string + " (" + string3 + ")" : string;
    }

    private static void removeCtrlTabFromTraversalKeys(Component component, int n) {
        Set<AWTKeyStroke> set = component.getFocusTraversalKeys(n);
        HashSet<AWTKeyStroke> hashSet = new HashSet<AWTKeyStroke>();
        for (AWTKeyStroke aWTKeyStroke : set) {
            if (aWTKeyStroke.getKeyCode() == 9 && BitField.isSet(aWTKeyStroke.getModifiers(), 2)) continue;
            hashSet.add(aWTKeyStroke);
        }
        component.setFocusTraversalKeys(n, hashSet);
    }

    public static void removeCtrlTabFromTraversalKeys(Component component) {
        KeyUtil.removeCtrlTabFromTraversalKeys(component, 0);
        KeyUtil.removeCtrlTabFromTraversalKeys(component, 1);
    }

    public static KeyStroke getBestAccelerator(KeyStrokeMap keyStrokeMap, int n) {
        KeyStroke keyStroke = null;
        List list = keyStrokeMap.getKeyStrokesFor(n);
        if (!list.isEmpty()) {
            for (KeyStrokes keyStrokes : list) {
                KeyStroke keyStroke2;
                if (keyStrokes.getLength() != 1 || (keyStroke2 = keyStrokes.getKeyStroke(0)) == null) continue;
                if (keyStroke == null) {
                    keyStroke = keyStroke2;
                    continue;
                }
                int n2 = KeyUtil.getKeyClass(keyStroke);
                int n3 = KeyUtil.getKeyClass(keyStroke2);
                if (n3 > n2) {
                    keyStroke = keyStroke2;
                    continue;
                }
                if (n3 != n2) continue;
                int n4 = keyStroke.getModifiers();
                int n5 = KeyUtil.countModifiers(n4);
                int n6 = keyStroke2.getModifiers();
                int n7 = KeyUtil.countModifiers(n6);
                if (n7 >= n5) continue;
                keyStroke = keyStroke2;
            }
        }
        return keyStroke;
    }

    private static int getKeyClass(KeyStroke keyStroke) {
        int n = keyStroke.getKeyCode();
        return 112 <= n && n <= 123 ? 2 : (65 <= n && n <= 90 ? 1 : 0);
    }

    private static int countModifiers(int n) {
        boolean bl = BitField.isSet(n, 8);
        boolean bl2 = BitField.isSet(n, 2);
        boolean bl3 = BitField.isSet(n, 1);
        boolean bl4 = BitField.isSet(n, 4);
        return (bl ? 1 : 0) + (bl2 ? 1 : 0) + (bl3 ? 1 : 0) + (bl4 ? 1 : 0);
    }
}

