/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.keyboard;

import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.Action;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumnModel;
import oracle.ide.ExtensionRegistry;
import oracle.ide.Ide;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuManager;
import oracle.ide.docking.DockStation;
import oracle.ide.docking.Dockable;
import oracle.ide.docking.DockableFactory;
import oracle.ide.docking.DockableWindow;
import oracle.ide.docking.DockingParam;
import oracle.ide.keyboard.Dumpable;
import oracle.ide.keyboard.KeyStroke2String;
import oracle.ide.keyboard.KeyStrokeContext;
import oracle.ide.keyboard.KeyStrokeContextRegistry;
import oracle.ide.keyboard.KeyStrokeMap;
import oracle.ide.keyboard.KeyStrokeOptions;
import oracle.ide.keyboard.KeyStrokes;
import oracle.ide.keyboard.MyModel;
import oracle.ide.keyboard.ResKeystrokeContext;
import oracle.ide.layout.Layout;
import oracle.ide.layout.ViewId;
import oracle.ide.util.GraphicsUtils;
import oracle.ide.util.Pair;
import oracle.javatools.clipboard.ClipboardStack;

final class KeyboardDockable
extends DockableWindow
implements DockableFactory {
    private static final String VIEW_TYPE_ID = "KF";
    private static final String DOCKABLE_ID = "KF.KF";
    private static KeyboardDockable INSTANCE = null;
    private JTable _table;
    private JComponent _GUI;
    private MyModel _model;
    private JList _list;

    private KeyboardDockable() {
        super(DOCKABLE_ID);
        DockStation dockStation = DockStation.getDockStation();
        dockStation.registerDockableFactory(VIEW_TYPE_ID, this);
        KeyStrokeOptions keyStrokeOptions = Ide.getSettings().getKeyStrokeOptions();
        this._model = new MyModel();
        keyStrokeOptions.addChangeListener(this._model);
        JMenu jMenu = MenuManager.getJMenu("View");
        JMenuItem jMenuItem = jMenu.add("Keyboard");
        jMenuItem.addActionListener(new 8(this, jMenuItem, dockStation));
    }

    static void initialize() {
        if (INSTANCE == null) {
            INSTANCE = new KeyboardDockable();
        }
    }

    public String getTitleName() {
        return "Keyboard Dockable";
    }

    public String getTabName() {
        return this.getTitleName();
    }

    public int getDefaultVisibility(Layout layout) {
        return super.getDefaultVisibility(layout) | 1;
    }

    public Component getGUI() {
        if (this._GUI == null) {
            KeyStrokeContextRegistry keyStrokeContextRegistry = Ide.getKeyStrokeContextRegistry();
            keyStrokeContextRegistry.loadAcceleratorDefinitionFiles();
            this._table = new JTable(this._model);
            this._table.setColumnSelectionAllowed(false);
            this._table.getTableHeader().addMouseListener(new 7());
            this._table.addMouseListener(new 6());
            JScrollPane jScrollPane = new JScrollPane(this._table);
            JTabbedPane jTabbedPane = new JTabbedPane();
            jTabbedPane.addTab("1", jScrollPane);
            DefaultListModel<Pair> defaultListModel = new DefaultListModel<Pair>();
            this._list = new 5(this, defaultListModel, defaultListModel);
            this._list.setCellRenderer(new 4());
            Iterator iterator = keyStrokeContextRegistry.getAllContexts();
            while (iterator.hasNext()) {
                KeyStrokeContext keyStrokeContext = (KeyStrokeContext)iterator.next();
                int n = 0;
                while (n < 2) {
                    boolean bl = n == 0;
                    Set set = keyStrokeContext.getAllActions(bl);
                    if (set != null && !set.isEmpty()) {
                        defaultListModel.addElement(new Pair(keyStrokeContext, bl));
                    }
                    ++n;
                }
            }
            this._list.addListSelectionListener(new 3());
            JScrollPane jScrollPane2 = new JScrollPane(this._list);
            jTabbedPane.addTab("2", jScrollPane2);
            this._GUI = jTabbedPane;
        }
        return this._GUI;
    }

    private void whenContextSelectionChanges() {
        Pair pair = (Pair)this._list.getSelectedValue();
        KeyStrokeContext keyStrokeContext = (KeyStrokeContext)pair.first;
        boolean bl = Boolean.TRUE.equals(pair.second);
        StringBuffer stringBuffer = new StringBuffer();
        Set set = keyStrokeContext.getAllActions(bl);
        stringBuffer.append("<context scope=\"" + (bl ? "global" : "local") + "\">\n");
        List list = keyStrokeContext.getAllPresets();
        if (list != null && !list.isEmpty()) {
            int n = 0;
            while (n < list.size()) {
                Object e = list.get(n);
                StringBuffer stringBuffer2 = new StringBuffer();
                KeyStrokeMap keyStrokeMap = keyStrokeContext.getPresetKeyStrokeMap(e, bl);
                Set set2 = keyStrokeMap.keySet();
                for (KeyStrokes keyStrokes : set2) {
                    Integer n2 = keyStrokeMap.getBindingFor(keyStrokes);
                    int n3 = n2;
                    String string = Ide.findCmdName(n3);
                    if (string != null) {
                        stringBuffer2.append("    <map action=\"" + string + "\">\n");
                        int n4 = keyStrokes.getLength();
                        int n5 = 0;
                        while (n5 < n4) {
                            KeyStroke keyStroke = keyStrokes.getKeyStroke(n5);
                            stringBuffer2.append("      <accel>" + KeyStroke2String.toString(keyStroke) + "</accel>\n");
                            ++n5;
                        }
                        stringBuffer2.append("    </map>\n");
                    }
                    IdeAction ideAction = IdeAction.find(n3);
                    set.remove(ideAction);
                }
                if (stringBuffer2.length() > 0) {
                    stringBuffer.append("  <preset name=\"" + e + "\">\n");
                    stringBuffer.append(stringBuffer2);
                    stringBuffer.append("  </preset>\n");
                }
                ++n;
            }
        }
        if (!set.isEmpty()) {
            stringBuffer.append("  <allActions>\n");
            for (IdeAction ideAction : set) {
                int n = ideAction.getCommandId();
                String string = Ide.findCmdName(n);
                if (string == null) continue;
                stringBuffer.append("    <map action=\"" + string + "\"/>\n");
            }
            stringBuffer.append("  </allActions>\n");
        }
        stringBuffer.append("</context>\n");
        StringSelection stringSelection = new StringSelection(stringBuffer.toString());
        ClipboardStack.pushCurrentClipboard();
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(stringSelection, null);
    }

    public Dockable getDockable(ViewId viewId) {
        return this;
    }

    public void install() {
        DockStation dockStation = DockStation.getDockStation();
        DockingParam dockingParam = new DockingParam();
        dockingParam.setPosition(0);
        dockStation.dock(this, dockingParam);
    }

    private boolean whenMouseEvent(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.showCtxMenu(mouseEvent);
            return true;
        }
        return false;
    }

    private void showCtxMenu(MouseEvent mouseEvent) {
        JPopupMenu jPopupMenu = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem("Dump");
        jMenuItem.addActionListener(new 2());
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Copy");
        jMenuItem.addActionListener(new 1());
        jPopupMenu.add(jMenuItem);
        Point point = GraphicsUtils.getPopupMenuShowPoint(jPopupMenu, mouseEvent);
        jPopupMenu.show(this._GUI, point.x, point.y);
    }

    private ArrayList collect(KeyStrokeContextRegistry keyStrokeContextRegistry, String string) {
        ArrayList arrayList = new ArrayList(200);
        Iterator iterator = keyStrokeContextRegistry.getAllContexts();
        while (iterator.hasNext()) {
            KeyStrokeContext keyStrokeContext = (KeyStrokeContext)iterator.next();
            String string2 = keyStrokeContext.getName();
            Object object = KeyStrokeContextRegistry.searchPreset(keyStrokeContext, string);
            int n = 0;
            while (n < 2) {
                boolean bl = n == 0;
                Set set = keyStrokeContext.getAllActions(bl);
                if (set != null) {
                    KeyStrokeMap keyStrokeMap = keyStrokeContext.getPresetKeyStrokeMap(object, bl);
                    KeyboardDockable.collect(arrayList, string2, keyStrokeMap, set, bl);
                }
                ++n;
            }
        }
        return arrayList;
    }

    private ArrayList collectCurrent(KeyStrokeContextRegistry keyStrokeContextRegistry, KeyStrokeOptions keyStrokeOptions) {
        ArrayList arrayList = new ArrayList(200);
        KeyStrokeMap keyStrokeMap = keyStrokeOptions.getGlobalKeyMap();
        Iterator iterator = keyStrokeContextRegistry.getAllContexts();
        while (iterator.hasNext()) {
            KeyStrokeContext keyStrokeContext = (KeyStrokeContext)iterator.next();
            String string = keyStrokeContext.getName();
            KeyStrokeMap keyStrokeMap2 = keyStrokeOptions.getLocalKeyMap(keyStrokeContext);
            int n = 0;
            while (n < 2) {
                boolean bl = n == 0;
                Set set = keyStrokeContext.getAllActions(bl);
                if (set != null) {
                    KeyboardDockable.collect(arrayList, string, bl ? keyStrokeMap : keyStrokeMap2, set, bl);
                }
                ++n;
            }
        }
        return arrayList;
    }

    private static void collect(ArrayList arrayList, String string, KeyStrokeMap keyStrokeMap, Set set, boolean bl) {
        for (Action action : set) {
            IdeAction ideAction;
            int n;
            if (!(action instanceof IdeAction) || (n = (ideAction = (IdeAction)action).getCommandId()) == -1) continue;
            IdeAction ideAction2 = IdeAction.find(n);
            if (ideAction2 != null) {
                List list;
                String string2 = (String)ideAction2.getValue("Name");
                if (keyStrokeMap == null || (list = keyStrokeMap.getKeyStrokesFor(new Integer(n))).isEmpty()) continue;
                for (KeyStrokes keyStrokes : list) {
                    if (keyStrokes == null) continue;
                    Dumpable dumpable = new Dumpable(string, string2, bl, keyStrokes);
                    arrayList.add(dumpable);
                }
                continue;
            }
            System.out.println("Strange: " + action.getValue("Name") + (bl ? "" : "(local)") + " is not found by IdeAction.find()");
        }
    }

    private String dump2(KeyStrokeContextRegistry keyStrokeContextRegistry, String string) {
        ArrayList arrayList = this.collect(keyStrokeContextRegistry, string);
        Collections.sort(arrayList);
        String string2 = "_" + string + ".kdf";
        this.dump2(arrayList, string2, "_" + string);
        return string2;
    }

    private void dumpCurrent(KeyStrokeContextRegistry keyStrokeContextRegistry, KeyStrokeOptions keyStrokeOptions) {
        ArrayList arrayList = this.collectCurrent(keyStrokeContextRegistry, keyStrokeOptions);
        Collections.sort(arrayList);
        this.dump2(arrayList, "_noname.kdf", "New Preset");
    }

    private void dump2(List list, String string, String string2) {
        try {
            ExtensionRegistry extensionRegistry = ExtensionRegistry.getOracleRegistry();
            URL uRL = extensionRegistry.getSystemDirectory(Ide.getProductID());
            File file = new File(uRL.getPath(), string);
            FileWriter fileWriter = new FileWriter(file);
            BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
            PrintWriter printWriter = new PrintWriter(bufferedWriter);
            printWriter.println("<document>");
            printWriter.println("  <preset name=\"" + string2 + "\">");
            String string3 = "!@!@";
            boolean bl = true;
            for (Dumpable dumpable : list) {
                if (!string3.equals(dumpable._sContext)) {
                    if (bl) {
                        bl = false;
                    } else {
                        printWriter.println("    </context>");
                    }
                    printWriter.println("    <context name=\"" + dumpable._sContext + "\">");
                    string3 = dumpable._sContext;
                }
                KeyboardDockable.dump(printWriter, dumpable._kss, dumpable._sActionName, dumpable._bGlobal);
            }
            printWriter.println("    </context>");
            printWriter.println("  </preset>");
            printWriter.println("</document>");
            printWriter.close();
            bufferedWriter.close();
            fileWriter.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static void dump(PrintWriter printWriter, KeyStrokes keyStrokes, String string, boolean bl) {
        printWriter.println("      <map action=\"" + string + "\" scope=\"" + (bl ? "global" : "local") + "\">");
        if (keyStrokes != null) {
            int n = 0;
            while (n < keyStrokes.getLength()) {
                KeyStroke keyStroke = keyStrokes.getKeyStroke(n);
                String string2 = KeyStroke2String.toString(keyStroke);
                printWriter.println("        <accel>" + string2 + "</accel>");
                ++n;
            }
        }
        printWriter.println("      </map>");
    }

    private void whenDump() {
        StringBuffer stringBuffer = new StringBuffer();
        KeyStrokeContextRegistry keyStrokeContextRegistry = Ide.getKeyStrokeContextRegistry();
        Iterator iterator = keyStrokeContextRegistry.getAllPresets().iterator();
        String string = " ";
        stringBuffer.append("Created ");
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            System.out.println("==================================================");
            System.out.println("Generating " + string2);
            String string3 = this.dump2(keyStrokeContextRegistry, string2);
            stringBuffer.append(string + string3);
            string = ", ";
        }
        KeyStrokeOptions keyStrokeOptions = Ide.getSettings().getKeyStrokeOptions();
        this.dumpCurrent(keyStrokeContextRegistry, keyStrokeOptions);
        stringBuffer.append(" and _noname.kdf in the System directory");
        JOptionPane.showMessageDialog(this.getHostedComponent(), stringBuffer, "KeyboardDockable addin", 1);
    }

    private void whenCopy() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this._model.getRowCount()) {
            int n2 = 0;
            while (n2 < this._model.getColumnCount()) {
                if (n2 != 0) {
                    stringBuffer.append('\t');
                }
                Object object = this._model.getValueAt(n, n2);
                String string = "";
                if (object != null) {
                    string = object.toString();
                }
                stringBuffer.append(string);
                ++n2;
            }
            stringBuffer.append('\n');
            ++n;
        }
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        StringSelection stringSelection = new StringSelection(stringBuffer.toString());
        ClipboardStack.pushCurrentClipboard();
        clipboard.setContents(stringSelection, null);
    }

    static boolean mav$whenMouseEvent(KeyboardDockable keyboardDockable, MouseEvent mouseEvent) {
        return keyboardDockable.whenMouseEvent(mouseEvent);
    }

    static JTable ra$_table(KeyboardDockable keyboardDockable) {
        return keyboardDockable._table;
    }

    static MyModel ra$_model(KeyboardDockable keyboardDockable) {
        return keyboardDockable._model;
    }

    static JList ra$_list(KeyboardDockable keyboardDockable) {
        return keyboardDockable._list;
    }

    static void mav$whenContextSelectionChanges(KeyboardDockable keyboardDockable) {
        keyboardDockable.whenContextSelectionChanges();
    }

    static void mav$whenDump(KeyboardDockable keyboardDockable) {
        keyboardDockable.whenDump();
    }

    static void mav$whenCopy(KeyboardDockable keyboardDockable) {
        keyboardDockable.whenCopy();
    }

    final class 8
    implements ActionListener {
        private final /* synthetic */ JMenuItem v$item;
        private final /* synthetic */ DockStation v$ds;
        final /* synthetic */ KeyboardDockable this$0;

        public void actionPerformed(ActionEvent actionEvent) {
            boolean bl = this.v$item.isSelected() ^ true;
            this.v$item.setSelected(bl);
            this.v$ds.setDockableVisible(this.this$0, bl);
        }

        public 8(KeyboardDockable keyboardDockable, JMenuItem jMenuItem, DockStation dockStation) {
            this.v$ds = dockStation;
            this.v$item = jMenuItem;
            this.this$0 = keyboardDockable;
        }
    }

    final class 7
    extends MouseAdapter {
        public void mousePressed(MouseEvent mouseEvent) {
            KeyboardDockable.mav$whenMouseEvent(KeyboardDockable.this, mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            KeyboardDockable.mav$whenMouseEvent(KeyboardDockable.this, mouseEvent);
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (!KeyboardDockable.mav$whenMouseEvent(KeyboardDockable.this, mouseEvent)) {
                TableColumnModel tableColumnModel = KeyboardDockable.ra$_table(KeyboardDockable.this).getColumnModel();
                int n = tableColumnModel.getColumnIndexAtX(mouseEvent.getX());
                int n2 = KeyboardDockable.ra$_table(KeyboardDockable.this).convertColumnIndexToModel(n);
                if (mouseEvent.getClickCount() == 1 && n2 != -1) {
                    KeyboardDockable.ra$_model(KeyboardDockable.this).sort(n2);
                }
            }
        }
    }

    final class 6
    extends MouseAdapter {
        public void mousePressed(MouseEvent mouseEvent) {
            KeyboardDockable.mav$whenMouseEvent(KeyboardDockable.this, mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            KeyboardDockable.mav$whenMouseEvent(KeyboardDockable.this, mouseEvent);
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            KeyboardDockable.mav$whenMouseEvent(KeyboardDockable.this, mouseEvent);
        }
    }

    final class 5
    extends JList {
        private final /* synthetic */ DefaultListModel v$listModel;
        final /* synthetic */ KeyboardDockable this$0;

        public String getToolTipText(MouseEvent mouseEvent) {
            String string = null;
            int n = KeyboardDockable.ra$_list(this.this$0).locationToIndex(mouseEvent.getPoint());
            Pair pair = (Pair)this.v$listModel.getElementAt(n);
            KeyStrokeContext keyStrokeContext = (KeyStrokeContext)pair.first;
            string = keyStrokeContext.getClass().getName();
            return string;
        }

        public 5(KeyboardDockable keyboardDockable, ListModel listModel, DefaultListModel defaultListModel) {
            this.v$listModel = defaultListModel;
            this.this$0 = keyboardDockable;
            super(listModel);
        }
    }

    final class 4
    extends DefaultListCellRenderer {
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            Pair pair = (Pair)object;
            KeyStrokeContext keyStrokeContext = (KeyStrokeContext)pair.first;
            boolean bl3 = Boolean.TRUE.equals(pair.second);
            boolean bl4 = keyStrokeContext instanceof ResKeystrokeContext;
            String string = keyStrokeContext.getName();
            if (!bl3) {
                string = string + "_local";
            }
            if (!bl4) {
                string = string + " (" + keyStrokeContext.getClass().getName() + ")";
            }
            Component component = super.getListCellRendererComponent((JList<?>)jList, string, n, bl, bl2);
            if (!bl) {
                if (bl4) {
                    this.setForeground(jList.getForeground());
                } else {
                    this.setForeground(Color.RED);
                }
            }
            return component;
        }
    }

    final class 3
    implements ListSelectionListener {
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            KeyboardDockable.mav$whenContextSelectionChanges(KeyboardDockable.this);
        }
    }

    final class 2
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            KeyboardDockable.mav$whenDump(KeyboardDockable.this);
        }
    }

    final class 1
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            KeyboardDockable.mav$whenCopy(KeyboardDockable.this);
        }
    }
}

