/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.keyboard;

import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.InputMap;
import javax.swing.KeyStroke;
import oracle.ide.Ide;
import oracle.ide.controller.IdeAction;
import oracle.ide.keyboard.GrabbableFocusManager;
import oracle.ide.keyboard.KeyStrokes;
import oracle.ide.keyboard.KeyUtil;

public final class MultiInputMap
extends InputMap {
    public static final Action NULL_ACTION = new 1();
    public static final Object NULL_ACTION_BIND = NULL_ACTION;
    private final HashMap _map;
    private static final KeyStrokes _sequence = new KeyStrokes();
    private boolean _bTerminator;

    void $init$() {
        this._map = new HashMap();
        this._bTerminator = false;
    }

    public MultiInputMap() {
        this(false);
    }

    public MultiInputMap(boolean bl) {
        this.$init$();
        this._bTerminator = bl;
    }

    public static boolean isInKeySequence() {
        return _sequence.getLength() != 0;
    }

    private static void reset() {
        _sequence.clear();
    }

    private static boolean isRepeat(KeyStroke keyStroke) {
        boolean bl = false;
        KeyStroke keyStroke2 = _sequence.getLast();
        if (keyStroke2 != null && keyStroke.equals(keyStroke2)) {
            bl = true;
        }
        return bl;
    }

    public Object get(KeyStroke keyStroke) {
        Object object = null;
        if (!(keyStroke.getKeyChar() != '\uffff' || keyStroke.isOnKeyRelease() || KeyUtil.isModifierKey(keyStroke) || MultiInputMap.isRepeat(keyStroke))) {
            _sequence.add(keyStroke);
            object = this._map.get(_sequence);
            if (object == null) {
                InputMap inputMap;
                if (_sequence.getLength() == 1 && (inputMap = this.getParent()) != null) {
                    object = inputMap.get(keyStroke);
                }
                if (this._bTerminator) {
                    _sequence.clear();
                } else {
                    _sequence.removeLast();
                }
            } else if (object != NULL_ACTION_BIND) {
                _sequence.clear();
                Action action = Ide.getIdeActionMap().get(object);
                if (action instanceof IdeAction) {
                    ((IdeAction)action).updateAction();
                }
            }
        }
        if (object != null) {
            GrabbableFocusManager grabbableFocusManager = GrabbableFocusManager.getGrabbableFocusManager();
            grabbableFocusManager.eatNextTypedReleased();
        }
        return object;
    }

    public void put(KeyStrokes keyStrokes, Object object) {
        this._map.put(keyStrokes, object);
        if (keyStrokes.getLength() > 1) {
            this.put(keyStrokes.getKeyStroke(0), NULL_ACTION_BIND);
        }
    }

    public void put(KeyStroke keyStroke, Object object) {
        this.put(new KeyStrokes(keyStroke), object);
    }

    public void remove(KeyStroke keyStroke) {
        this._map.remove(keyStroke);
        MultiInputMap.reset();
    }

    public void clear() {
        this._map.clear();
        MultiInputMap.reset();
    }

    public KeyStroke[] keys() {
        Set set = this._map.keySet();
        KeyStroke[] keyStrokeArray = new KeyStroke[set.size()];
        Iterator iterator = set.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            KeyStrokes keyStrokes = (KeyStrokes)iterator.next();
            if (keyStrokes.getLength() != 1) continue;
            keyStrokeArray[n++] = keyStrokes.getKeyStroke(0);
        }
        return keyStrokeArray;
    }

    public int size() {
        return this._map.size();
    }

    public static final class 1
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
        }
    }
}

