/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.keyboard;

import oracle.ide.keyboard.KeyStrokeContext;
import oracle.ide.keyboard.KeyStrokeMap;
import oracle.ide.keyboard.KeyStrokeOptions;
import oracle.ide.keyboard.KeyStrokes;
import oracle.ide.keyboard.MultiInputMap;

public final class MultiMapAdapter {
    private static void fillMap(MultiInputMap multiInputMap, KeyStrokeMap keyStrokeMap) {
        multiInputMap.clear();
        for (KeyStrokes keyStrokes : keyStrokeMap.keySet()) {
            Integer n = keyStrokeMap.getBindingFor(keyStrokes);
            multiInputMap.put(keyStrokes, (Object)n);
        }
    }

    private static MultiInputMap getMap(KeyStrokeMap keyStrokeMap) {
        MultiInputMap multiInputMap = new MultiInputMap();
        if (keyStrokeMap != null) {
            MultiMapAdapter.fillMap(multiInputMap, keyStrokeMap);
        }
        return multiInputMap;
    }

    public static MultiInputMap getGlobalMap(KeyStrokeOptions keyStrokeOptions) {
        MultiInputMap multiInputMap = MultiMapAdapter.getMap(keyStrokeOptions.getGlobalKeyMap());
        return multiInputMap;
    }

    public static void fillGlobalMap(MultiInputMap multiInputMap, KeyStrokeOptions keyStrokeOptions) {
        MultiMapAdapter.fillMap(multiInputMap, keyStrokeOptions.getGlobalKeyMap());
    }

    public static MultiInputMap getLocalMap(KeyStrokeOptions keyStrokeOptions, KeyStrokeContext keyStrokeContext) {
        KeyStrokeMap keyStrokeMap = keyStrokeOptions.getLocalKeyMap(keyStrokeContext);
        MultiInputMap multiInputMap = MultiMapAdapter.getMap(keyStrokeMap);
        return multiInputMap;
    }

    public static void fillLocalMap(MultiInputMap multiInputMap, KeyStrokeOptions keyStrokeOptions, KeyStrokeContext keyStrokeContext) {
        MultiMapAdapter.fillMap(multiInputMap, keyStrokeOptions.getLocalKeyMap(keyStrokeContext));
    }
}

