/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.keyboard;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.AbstractTableModel;
import oracle.ide.Ide;
import oracle.ide.keyboard.KeyStrokeMap;
import oracle.ide.keyboard.KeyStrokeOptions;
import oracle.ide.util.Pair;

final class MyModel
extends AbstractTableModel
implements ChangeListener {
    private int _nSortedCol;
    private ArrayList _data;

    final void refresh() {
        this._data = new ArrayList(100);
        KeyStrokeOptions keyStrokeOptions = Ide.getSettings().getKeyStrokeOptions();
        KeyStrokeMap keyStrokeMap = keyStrokeOptions.getGlobalKeyMap();
        ArrayList arrayList = keyStrokeMap.getData();
        int n = 0;
        while (n < arrayList.size()) {
            Pair pair = (Pair)arrayList.get(n);
            String string = "(global) " + (String)pair.getFirst();
            String string2 = pair.getSecond().toString();
            this._data.add(new Pair(string, string2));
            ++n;
        }
        HashMap hashMap = keyStrokeOptions.getLocalKeyMaps();
        if (hashMap != null) {
            for (Map.Entry entry : hashMap.entrySet()) {
                Object k = entry.getKey();
                KeyStrokeMap keyStrokeMap2 = (KeyStrokeMap)entry.getValue();
                ArrayList arrayList2 = keyStrokeMap2.getData();
                int n2 = 0;
                while (n2 < arrayList2.size()) {
                    Pair pair = (Pair)arrayList2.get(n2);
                    String string = "(" + k + ") " + (String)pair.getFirst();
                    String string3 = pair.getSecond().toString();
                    this._data.add(new Pair(string, string3));
                    ++n2;
                }
            }
        }
        this.sort();
    }

    public final int getRowCount() {
        return this._data.size();
    }

    public final int getColumnCount() {
        return 2;
    }

    public final String getColumnName(int n) {
        if (n == 0) {
            return "Command";
        }
        return "Key";
    }

    public final Object getValueAt(int n, int n2) {
        Object object = null;
        Pair pair = (Pair)this._data.get(n);
        switch (n2) {
            case 0: {
                object = pair.getFirst();
                break;
            }
            case 1: {
                object = pair.getSecond();
            }
        }
        return object;
    }

    final void sort(int n) {
        this._nSortedCol = n;
        this.sort();
    }

    private void sort() {
        Comparator comparator = this._nSortedCol == 0 ? new 2() : new 1();
        Collections.sort(this._data, comparator);
        this.fireTableDataChanged();
    }

    public final void stateChanged(ChangeEvent changeEvent) {
        this.refresh();
    }

    MyModel() {
    }

    final class 2
    implements Comparator {
        public int compare(Object object, Object object2) {
            Pair pair = (Pair)object;
            Pair pair2 = (Pair)object2;
            String string = pair.getFirst().toString();
            String string2 = pair2.getFirst().toString();
            return String.CASE_INSENSITIVE_ORDER.compare(string, string2);
        }
    }

    final class 1
    implements Comparator {
        public int compare(Object object, Object object2) {
            Pair pair = (Pair)object;
            Pair pair2 = (Pair)object2;
            String string = pair.getSecond().toString();
            String string2 = pair2.getSecond().toString();
            return String.CASE_INSENSITIVE_ORDER.compare(string, string2);
        }
    }
}

