/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.keyboard;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Ide;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.help.HelpSystem;
import oracle.ide.keyboard.KeyStrokeContext;
import oracle.ide.keyboard.KeyStrokeContextRegistry;
import oracle.ide.resource.IdeArb;
import oracle.ide.util.ResourceUtils;

public final class PresetsPanel
extends JPanel
implements MouseListener {
    private final DefaultListModel _presetModel;
    private final JList _jlPresets;
    private DismissableJEWTDialog _container;

    void $init$() {
        this._presetModel = new DefaultListModel();
        this._jlPresets = new JList(this._presetModel);
    }

    static String run(Frame frame, String string) {
        DismissableJEWTDialog dismissableJEWTDialog;
        String string2 = null;
        PresetsPanel presetsPanel = new PresetsPanel();
        presetsPanel.setPreset(string);
        HelpSystem.getHelpSystem().registerTopic(presetsPanel, "f1_idedloadpreset_html");
        presetsPanel._container = dismissableJEWTDialog = new DismissableJEWTDialog(frame);
        dismissableJEWTDialog.setInitialFocus(presetsPanel._jlPresets);
        dismissableJEWTDialog.setContent(presetsPanel);
        if (WizardLauncher.runDialog((JDialog)((Object)dismissableJEWTDialog))) {
            string2 = presetsPanel.getPreset();
        }
        return string2;
    }

    private PresetsPanel() {
        this.$init$();
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        JLabel jLabel = new JLabel();
        ResourceUtils.resLabel(jLabel, this._jlPresets, IdeArb.getString(317));
        JScrollPane jScrollPane = new JScrollPane(this._jlPresets);
        this.add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)jScrollPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 167, 84));
        this.fillPresets();
        this._jlPresets.addMouseListener(this);
    }

    private String getPreset() {
        String string = null;
        Object e = this._jlPresets.getSelectedValue();
        if (e != null) {
            string = e.toString();
        }
        return string;
    }

    private void setPreset(String string) {
        this._jlPresets.setSelectedValue(string, true);
    }

    private void fillPresets() {
        HashSet hashSet = new HashSet(5);
        KeyStrokeContextRegistry keyStrokeContextRegistry = Ide.getKeyStrokeContextRegistry();
        Iterator iterator = keyStrokeContextRegistry.getAllContexts();
        while (iterator.hasNext()) {
            KeyStrokeContext keyStrokeContext = (KeyStrokeContext)iterator.next();
            List list = keyStrokeContext.getAllPresets();
            if (list == null) continue;
            int n = 0;
            while (n < list.size()) {
                list.set(n, list.get(n).toString());
                ++n;
            }
            hashSet.addAll(list);
        }
        int n = hashSet.size();
        String[] stringArray = hashSet.toArray(new String[n]);
        Arrays.sort(stringArray, String.CASE_INSENSITIVE_ORDER);
        this._presetModel.removeAllElements();
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            this._presetModel.addElement(string);
            ++n2;
        }
    }

    public final void mouseClicked(MouseEvent mouseEvent) {
        int n;
        if (mouseEvent.getClickCount() == 2 && (n = this._jlPresets.locationToIndex(mouseEvent.getPoint())) != -1) {
            DismissableJEWTDialog.mav$dismiss(this._container);
        }
    }

    public final void mousePressed(MouseEvent mouseEvent) {
    }

    public final void mouseReleased(MouseEvent mouseEvent) {
    }

    public final void mouseEntered(MouseEvent mouseEvent) {
    }

    public final void mouseExited(MouseEvent mouseEvent) {
    }

    private static final class DismissableJEWTDialog
    extends JEWTDialog {
        public DismissableJEWTDialog(Frame frame) {
            super(frame, IdeArb.getString(317), 7);
        }

        private void dismiss() {
            this.dismissDialog(false);
        }

        static void mav$dismiss(DismissableJEWTDialog dismissableJEWTDialog) {
            dismissableJEWTDialog.dismiss();
        }
    }
}

