/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.keyboard;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import oracle.ide.Ide;
import oracle.ide.controller.IdeAction;
import oracle.ide.keyboard.KeyStrokeContext;
import oracle.ide.keyboard.KeyStrokeContextRegistry;
import oracle.ide.keyboard.KeyStrokeMap;
import oracle.ide.keyboard.KeyStrokes;
import oracle.ide.keyboard.ResKeystrokeReader;

class ResKeystrokeContext
implements KeyStrokeContext {
    private ClassLoader _classLoader;
    private String _fileName;
    private boolean _global;
    private HashSet _actionNames;
    private HashSet _knownPresets;
    private HashMap _presets;

    public ResKeystrokeContext(ClassLoader classLoader, String string) {
        this._classLoader = classLoader;
        this._fileName = string;
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.getName() + "]";
    }

    void load(ResKeystrokeReader resKeystrokeReader) {
        this._actionNames = new HashSet();
        this._knownPresets = new HashSet(5);
        this._presets = new HashMap();
        try {
            resKeystrokeReader.read(this);
        }
        catch (Exception exception) {
            System.err.println("Failed to read " + this._fileName);
            exception.printStackTrace();
        }
    }

    void unload() {
        this._global = true;
        this._actionNames = null;
        this._knownPresets = null;
        this._presets = null;
    }

    public ClassLoader getClassLoader() {
        return this._classLoader;
    }

    public String getAcceleratorFile() {
        return null;
    }

    public Set getAllActions(boolean bl) {
        HashSet<IdeAction> hashSet = null;
        if (this.isInitialized() && bl == this._global) {
            HashSet<IdeAction> hashSet2 = new HashSet<IdeAction>();
            for (String string : this._actionNames) {
                IdeAction ideAction;
                int n;
                Integer n2 = Ide.findCmdID(string);
                if (n2 == null || (n = n2.intValue()) == -1 || (ideAction = IdeAction.find(n)) == null) continue;
                hashSet2.add(ideAction);
            }
            hashSet = hashSet2;
        }
        return hashSet;
    }

    public List getAllPresets() {
        ArrayList arrayList = this.isInitialized() ? new ArrayList(this._knownPresets) : null;
        return arrayList;
    }

    public String getName() {
        return this._fileName;
    }

    public KeyStrokeMap getPresetKeyStrokeMap(Object object, boolean bl) {
        KeyStrokeMap keyStrokeMap = null;
        if (this.isInitialized() && bl == this._global) {
            keyStrokeMap = new KeyStrokeMap();
            ArrayList arrayList = (ArrayList)this._presets.get(object);
            if (arrayList != null) {
                int n = 0;
                while (n < arrayList.size()) {
                    Mapping mapping = (Mapping)arrayList.get(n);
                    String string = mapping._actionName;
                    KeyStrokes keyStrokes = mapping._keyStrokes;
                    keyStrokeMap.addMap(keyStrokes, string);
                    ++n;
                }
            }
        }
        return keyStrokeMap;
    }

    InputStream getInputStream() {
        ClassLoader classLoader = this._classLoader != null ? this._classLoader : this.getClass().getClassLoader();
        InputStream inputStream = classLoader.getResourceAsStream(this._fileName);
        return inputStream;
    }

    void setGlobal(boolean bl) {
        this._global = bl;
    }

    void addActionName(String string) {
        this._actionNames.add(string);
    }

    void addPresetName(String string) {
        this._knownPresets.add(string);
    }

    void addMapping(String string, String string2, KeyStrokes keyStrokes) {
        ArrayList<Mapping> arrayList = (ArrayList<Mapping>)this._presets.get(string);
        if (arrayList == null) {
            arrayList = new ArrayList<Mapping>(5);
            this._presets.put(string, arrayList);
        }
        Mapping mapping = new Mapping(string2, keyStrokes);
        arrayList.add(mapping);
    }

    private boolean isInitialized() {
        if (this._presets == null) {
            KeyStrokeContextRegistry keyStrokeContextRegistry = Ide.getKeyStrokeContextRegistry();
            keyStrokeContextRegistry.loadAcceleratorDefinitionFiles();
        }
        return this._presets != null;
    }

    private static class Mapping {
        String _actionName;
        KeyStrokes _keyStrokes;

        public Mapping(String string, KeyStrokes keyStrokes) {
            this._actionName = string;
            this._keyStrokes = keyStrokes;
        }
    }
}

