/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.keyboard;

import java.io.IOException;
import java.io.InputStream;
import javax.swing.KeyStroke;
import javax.xml.parsers.SAXParser;
import oracle.ide.keyboard.KeyStroke2String;
import oracle.ide.keyboard.KeyStrokes;
import oracle.ide.keyboard.ResKeystrokeContext;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class ResKeystrokeReader
extends DefaultHandler {
    private SAXParser _saxParser;
    private ResKeystrokeContext _currentKeystrokeContext;
    private String _currentPresetName;
    private String _currentActionName;
    private KeyStrokes _currentKeyStrokes;
    private static final int NODE_CONTEXT = 0;
    private static final int NODE_PRESET = 1;
    private static final int NODE_MAP = 2;
    private static final int NODE_ACCEL = 3;

    public ResKeystrokeReader(SAXParser sAXParser) {
        this._saxParser = sAXParser;
    }

    void read(ResKeystrokeContext resKeystrokeContext) throws IOException, SAXException {
        this._currentKeystrokeContext = resKeystrokeContext;
        InputStream inputStream = this._currentKeystrokeContext.getInputStream();
        this._saxParser.parse(inputStream, (DefaultHandler)this);
        inputStream.close();
    }

    private static int getNodeType(String string) {
        if ("accel".equalsIgnoreCase(string)) {
            return 3;
        }
        if ("map".equalsIgnoreCase(string)) {
            return 2;
        }
        if ("preset".equalsIgnoreCase(string)) {
            return 1;
        }
        if ("context".equalsIgnoreCase(string)) {
            return 0;
        }
        return -1;
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        int n = ResKeystrokeReader.getNodeType(string3);
        switch (n) {
            case 3: {
                break;
            }
            case 2: {
                this._currentActionName = attributes.getValue("action");
                this._currentKeystrokeContext.addActionName(this._currentActionName);
                this._currentKeyStrokes = new KeyStrokes();
                break;
            }
            case 1: {
                this._currentPresetName = attributes.getValue("name");
                this._currentKeystrokeContext.addPresetName(this._currentPresetName);
                break;
            }
            case 0: {
                String string4 = attributes.getValue("scope");
                boolean bl = !"local".equalsIgnoreCase(string4);
                this._currentKeystrokeContext.setGlobal(bl);
            }
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        int n = ResKeystrokeReader.getNodeType(string3);
        switch (n) {
            case 3: {
                if (this._currentKeyStrokes.getLength() <= 0) break;
                this._currentKeystrokeContext.addMapping(this._currentPresetName, this._currentActionName, this._currentKeyStrokes);
                break;
            }
            case 2: {
                this._currentActionName = null;
                this._currentKeyStrokes = null;
                break;
            }
            case 1: {
                this._currentPresetName = null;
                break;
            }
        }
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (this._currentKeyStrokes != null) {
            String string = new String(cArray, n, n2);
            KeyStroke keyStroke = KeyStroke2String.fromString(string);
            this._currentKeyStrokes.add(keyStroke);
        }
    }
}

