/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.keyboard;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.List;
import java.util.Set;
import javax.swing.KeyStroke;
import oracle.ide.Ide;
import oracle.ide.controller.IdeAction;
import oracle.ide.keyboard.KeyStroke2String;
import oracle.ide.keyboard.KeyStrokeMap;
import oracle.ide.keyboard.KeyStrokes;
import oracle.ide.keyboard.MyNodeIterator;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.DTD;
import oracle.xml.parser.v2.XMLDocument;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

final class XMLKeystrokeContextDef {
    private Element _def;
    private static final String KPRESET = "preset";
    private static final String KPRESET_NAME = "name";
    private static final String KCONTEXT = "context";
    private static final String KCONTEXT_NAME = "name";
    private static final String KMAP = "map";
    private static final String KMAP_ACTION = "action";
    private static final String KMAP_SCOPE = "scope";
    private static final String KMAP_SCOPE_GLOBAL = "global";
    private static final String KACCEL = "accel";

    private XMLKeystrokeContextDef() {
    }

    final void addAllPresets(List list) {
        MyNodeIterator myNodeIterator = new MyNodeIterator(this._def, KPRESET);
        while (myNodeIterator.hasNext()) {
            Element element = myNodeIterator.nextElement();
            String string = element.getAttribute("name");
            if (string.length() == 0) continue;
            list.add(string);
        }
    }

    final void addAllActions(Set set, String string, boolean bl) {
        MyNodeIterator myNodeIterator = new MyNodeIterator();
        MyNodeIterator myNodeIterator2 = new MyNodeIterator();
        MyNodeIterator myNodeIterator3 = new MyNodeIterator();
        myNodeIterator.set(this._def, KPRESET);
        while (myNodeIterator.hasNext()) {
            Element element = myNodeIterator.nextElement();
            myNodeIterator2.set(element, KCONTEXT);
            while (myNodeIterator2.hasNext()) {
                Element element2 = myNodeIterator2.nextElement();
                String string2 = element2.getAttribute("name");
                if (!string2.equalsIgnoreCase(string)) continue;
                myNodeIterator3.set(element2, KMAP);
                while (myNodeIterator3.hasNext()) {
                    IdeAction ideAction;
                    String string3;
                    Integer n;
                    Element element3 = myNodeIterator3.nextElement();
                    String string4 = element3.getAttribute(KMAP_SCOPE);
                    if (string4.equalsIgnoreCase(KMAP_SCOPE_GLOBAL) != bl || (n = Ide.findCmdID(string3 = element3.getAttribute(KMAP_ACTION))) == null || (ideAction = IdeAction.find(n)) == null) continue;
                    set.add(ideAction);
                }
            }
        }
    }

    final void addPresetKeyStrokeMap(KeyStrokeMap keyStrokeMap, String string, String string2, boolean bl) {
        MyNodeIterator myNodeIterator = new MyNodeIterator();
        MyNodeIterator myNodeIterator2 = new MyNodeIterator();
        MyNodeIterator myNodeIterator3 = new MyNodeIterator();
        MyNodeIterator myNodeIterator4 = new MyNodeIterator();
        myNodeIterator.set(this._def, KPRESET);
        while (myNodeIterator.hasNext()) {
            Element element = myNodeIterator.nextElement();
            String string3 = element.getAttribute("name");
            if (!string3.equalsIgnoreCase(string2)) continue;
            myNodeIterator2.set(element, KCONTEXT);
            while (myNodeIterator2.hasNext()) {
                Element element2 = myNodeIterator2.nextElement();
                String string4 = element2.getAttribute("name");
                if (!string4.equalsIgnoreCase(string)) continue;
                myNodeIterator3.set(element2, KMAP);
                while (myNodeIterator3.hasNext()) {
                    String string5;
                    Integer n;
                    Element element3 = myNodeIterator3.nextElement();
                    String string6 = element3.getAttribute(KMAP_SCOPE);
                    if (string6.equalsIgnoreCase(KMAP_SCOPE_GLOBAL) != bl || (n = Ide.findCmdID(string5 = element3.getAttribute(KMAP_ACTION))) == null) continue;
                    KeyStrokes keyStrokes = null;
                    myNodeIterator4.set(element3, KACCEL);
                    while (myNodeIterator4.hasNext()) {
                        String string7;
                        Element element4 = myNodeIterator4.nextElement();
                        Node node = element4.getFirstChild();
                        if (node == null || (string7 = node.getNodeValue()) == null || string7.length() == 0) continue;
                        KeyStroke keyStroke = KeyStroke2String.fromString(string7);
                        if (keyStrokes == null) {
                            keyStrokes = new KeyStrokes();
                        }
                        keyStrokes.add(keyStroke);
                    }
                    if (keyStrokes == null) continue;
                    keyStrokeMap.put(keyStrokes, n);
                }
            }
        }
    }

    static XMLKeystrokeContextDef load(String string) {
        XMLKeystrokeContextDef xMLKeystrokeContextDef = null;
        File file = new File(string);
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            XMLKeystrokeContextDef xMLKeystrokeContextDef2 = new XMLKeystrokeContextDef();
            if (xMLKeystrokeContextDef2.load(fileInputStream)) {
                xMLKeystrokeContextDef = xMLKeystrokeContextDef2;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return xMLKeystrokeContextDef;
    }

    static XMLKeystrokeContextDef load(ClassLoader classLoader, String string) {
        XMLKeystrokeContextDef xMLKeystrokeContextDef;
        XMLKeystrokeContextDef xMLKeystrokeContextDef2 = null;
        InputStream inputStream = classLoader.getResourceAsStream(string);
        if (inputStream != null && (xMLKeystrokeContextDef = new XMLKeystrokeContextDef()).load(inputStream)) {
            xMLKeystrokeContextDef2 = xMLKeystrokeContextDef;
        }
        return xMLKeystrokeContextDef2;
    }

    private boolean load(InputStream inputStream) {
        boolean bl = false;
        try {
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            DOMParser dOMParser = new DOMParser();
            dOMParser.setPreserveWhitespace(false);
            dOMParser.setDoctype(new DTD());
            try {
                dOMParser.parse((Reader)bufferedReader);
                bufferedReader.close();
                XMLDocument xMLDocument = dOMParser.getDocument();
                this._def = xMLDocument.getDocumentElement();
                bl = true;
            }
            catch (SAXException sAXException) {
                sAXException.printStackTrace();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return bl;
    }
}

