/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.keyboard;

import java.io.File;
import java.io.FilenameFilter;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import oracle.ide.ExtensionRegistry;
import oracle.ide.Ide;
import oracle.ide.keyboard.KeyStrokeMap;
import oracle.ide.keyboard.XMLKeystrokeContextDef;
import oracle.ide.net.URLFileSystem;

public final class XMLKeystrokeContextDefs
implements FilenameFilter {
    private static final String KDEF_EXTENSION = ".kdf";
    private final ArrayList _acceleratorFiles;
    private ArrayList _listAllPresets;
    private static XMLKeystrokeContextDefs INSTANCE;

    void $init$() {
        this._acceleratorFiles = new ArrayList();
    }

    private XMLKeystrokeContextDefs() {
        this.$init$();
    }

    public static synchronized XMLKeystrokeContextDefs getInstance() {
        if (INSTANCE == null) {
            String string;
            INSTANCE = new XMLKeystrokeContextDefs();
            ExtensionRegistry extensionRegistry = ExtensionRegistry.getOracleRegistry();
            URL uRL = extensionRegistry.getSystemDirectory(Ide.getProductID());
            if (uRL != null) {
                INSTANCE.addDirectory(URLFileSystem.getPlatformPathName(uRL));
            }
            if ((string = Ide.getSystemDirectory()) != null) {
                INSTANCE.addDirectory(string);
            }
        }
        return INSTANCE;
    }

    private void addFile(String string) {
        this._acceleratorFiles.add(new Entry(string));
        this._listAllPresets = null;
    }

    public void addAcceleratorFile(ClassLoader classLoader, String string) {
        Entry entry = new Entry(classLoader, string);
        this._acceleratorFiles.add(entry);
    }

    public final boolean accept(File file, String string) {
        return string.toLowerCase().endsWith(KDEF_EXTENSION);
    }

    private void addDirectory(String string) {
        File file = new File(string);
        if (file.exists()) {
            File[] fileArray = file.listFiles(this);
            int n = 0;
            while (n < fileArray.length) {
                File file2 = fileArray[n];
                this.addFile(file2.getPath());
                ++n;
            }
        }
    }

    public final synchronized void unload() {
        int n = 0;
        while (n < this._acceleratorFiles.size()) {
            Entry entry = (Entry)this._acceleratorFiles.get(n);
            entry.unload();
            ++n;
        }
        this._listAllPresets = null;
    }

    private XMLKeystrokeContextDef[] getAllContextDefs() {
        ArrayList<XMLKeystrokeContextDef> arrayList = new ArrayList<XMLKeystrokeContextDef>(this._acceleratorFiles.size());
        int n = 0;
        while (n < this._acceleratorFiles.size()) {
            Entry entry = (Entry)this._acceleratorFiles.get(n);
            XMLKeystrokeContextDef xMLKeystrokeContextDef = entry.getXmlKeystrokeContextDef();
            if (xMLKeystrokeContextDef == null) {
                this._acceleratorFiles.remove(n);
                --n;
            } else {
                arrayList.add(xMLKeystrokeContextDef);
            }
            ++n;
        }
        return arrayList.toArray(new XMLKeystrokeContextDef[arrayList.size()]);
    }

    public final synchronized List getAllPresets() {
        if (this._listAllPresets == null) {
            this._listAllPresets = new ArrayList(5);
            XMLKeystrokeContextDef[] xMLKeystrokeContextDefArray = this.getAllContextDefs();
            int n = 0;
            while (n < xMLKeystrokeContextDefArray.length) {
                XMLKeystrokeContextDef xMLKeystrokeContextDef = xMLKeystrokeContextDefArray[n];
                xMLKeystrokeContextDef.addAllPresets(this._listAllPresets);
                ++n;
            }
        }
        return this._listAllPresets;
    }

    public final Set getAllActions(String string, boolean bl) {
        HashSet hashSet = new HashSet();
        XMLKeystrokeContextDef[] xMLKeystrokeContextDefArray = this.getAllContextDefs();
        int n = 0;
        while (n < xMLKeystrokeContextDefArray.length) {
            XMLKeystrokeContextDef xMLKeystrokeContextDef = xMLKeystrokeContextDefArray[n];
            xMLKeystrokeContextDef.addAllActions(hashSet, string, bl);
            ++n;
        }
        return hashSet;
    }

    public final KeyStrokeMap getPresetKeyStrokeMap(String string, Object object, boolean bl) {
        KeyStrokeMap keyStrokeMap = new KeyStrokeMap();
        String string2 = object.toString();
        XMLKeystrokeContextDef[] xMLKeystrokeContextDefArray = this.getAllContextDefs();
        int n = 0;
        while (n < xMLKeystrokeContextDefArray.length) {
            XMLKeystrokeContextDef xMLKeystrokeContextDef = xMLKeystrokeContextDefArray[n];
            xMLKeystrokeContextDef.addPresetKeyStrokeMap(keyStrokeMap, string, string2, bl);
            ++n;
        }
        return keyStrokeMap;
    }

    private static class Entry {
        private String _filename;
        private ClassLoader _classLoader;
        private XMLKeystrokeContextDef _xmlKeystrokeContextDef;

        Entry(String string) {
            this(null, string);
        }

        Entry(ClassLoader classLoader, String string) {
            this._classLoader = classLoader;
            this._filename = string;
        }

        XMLKeystrokeContextDef getXmlKeystrokeContextDef() {
            if (this._xmlKeystrokeContextDef == null) {
                this._xmlKeystrokeContextDef = this._classLoader == null ? XMLKeystrokeContextDef.load(this._filename) : XMLKeystrokeContextDef.load(this._classLoader, this._filename);
            }
            return this._xmlKeystrokeContextDef;
        }

        void unload() {
            this._xmlKeystrokeContextDef = null;
        }
    }
}

