/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.layout;

import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import oracle.ide.layout.Layout;
import oracle.ide.layout.LayoutListener;
import oracle.ide.layout.URL2String;
import oracle.ide.layout.ViewId;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.PropertyAccess;
import oracle.ide.view.View;

public abstract class AbstractLayoutListener
implements LayoutListener {
    private HashMap views;

    void $init$() {
        this.views = new HashMap();
    }

    public AbstractLayoutListener() {
        this.$init$();
    }

    public synchronized void close(Layout layout) {
        this.save(layout);
        for (View view : this.views.values()) {
            view.close();
        }
    }

    public synchronized View getView(ViewId viewId) {
        return (View)this.views.get(viewId.getId());
    }

    public synchronized void addView(ViewId viewId, View view) {
        this.views.put(viewId.getId(), view);
    }

    public synchronized void removeView(View view) {
        this.views.remove(view.getId());
    }

    public synchronized void addOpenedViews(Layout layout, List list) {
        Iterator iterator = this.views.values().iterator();
        while (iterator.hasNext()) {
            list.add(iterator.next());
        }
    }

    protected boolean isVisible(String string, Layout layout) {
        String string2 = string + ".visible";
        String string3 = layout.getProperty(string2, null);
        Boolean bl = new Boolean(false);
        if (string3 != null && string3.length() > 0) {
            bl = Boolean.valueOf(string3);
        }
        return bl;
    }

    public static URL getURL(String string, PropertyAccess propertyAccess) {
        String string2 = propertyAccess.getProperty(string, null);
        URL uRL = null;
        if (string2 != null && string2.length() > 0) {
            uRL = URL2String.toURL(string2);
        }
        return uRL;
    }

    public static Node getNode(String string, PropertyAccess propertyAccess, boolean bl) {
        URL uRL = AbstractLayoutListener.getURL(string, propertyAccess);
        Node node = null;
        if (uRL != null && (bl || URLFileSystem.exists(uRL))) {
            try {
                node = NodeFactory.findOrCreate(uRL);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return node;
    }

    public static Node getNode(String string, Layout layout) {
        return AbstractLayoutListener.getNode(string, layout, true);
    }

    public static Project getProject(String string, Layout layout) {
        String string2 = string + ".project";
        return (Project)AbstractLayoutListener.getNode(string2, layout);
    }

    public static Workspace getWorkspace(String string, Layout layout) {
        String string2 = string + ".workspace";
        return (Workspace)AbstractLayoutListener.getNode(string2, layout);
    }
}

