/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.layout;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.Icon;
import oracle.ide.ExtensionRegistry;
import oracle.ide.layout.Layout;
import oracle.ide.layout.SimpleLayout;
import oracle.ide.model.Element;
import oracle.ide.model.Folder;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.ArrayResourceBundle;
import oracle.ide.util.ModelUtil;

public final class IdeLayout
extends Layout
implements Folder {
    private static final String LAYOUT = "Layout.";
    private static final String COUNT_PROP = "Layout.count";
    private static final String ACTIVE_PROP = "Layout.active";
    private HashMap _layoutMap;
    private Layout _activeLayout;
    private SimpleLayout _defaults;
    private transient String _shortLabel;
    private transient Icon _icon;
    private transient ArrayResourceBundle _iconBundle;
    private transient int _iconBundleKey;

    void $init$() {
        this._layoutMap = new HashMap();
    }

    public IdeLayout(URL uRL, String string, Icon icon) {
        this(uRL, string, null, -1);
        this._icon = icon;
    }

    public IdeLayout(URL uRL, String string, ArrayResourceBundle arrayResourceBundle, int n) {
        super(uRL);
        this.$init$();
        this._shortLabel = string;
        this._iconBundle = arrayResourceBundle;
        this._iconBundleKey = n;
    }

    protected IdeLayout() {
        super(null);
        this.$init$();
    }

    public String getProperty(String string, String string2) {
        this.ensureOpen();
        return this._activeLayout.getProperty(string, string2);
    }

    public Object setProperty(String string, String string2) {
        this.ensureOpen();
        this.markDirty(true);
        if (string2 != null) {
            return this._activeLayout.setProperty(string, string2);
        }
        return this._activeLayout.removeProperty(string);
    }

    public Object removeProperty(String string) {
        this.ensureOpen();
        return this._activeLayout.removeProperty(string);
    }

    public Layout getActiveLayout() {
        this.ensureOpen();
        return this._activeLayout;
    }

    public Layout findLayout(URL uRL) {
        this.ensureOpen();
        if (uRL.equals(this.getDefaults().getURL())) {
            return this.getDefaults();
        }
        return IdeLayout.findLayout(uRL, this);
    }

    private static Layout findLayout(URL uRL, Element element) {
        Iterator iterator = element.getChildren();
        if (iterator != null) {
            while (iterator.hasNext()) {
                Layout layout = (Layout)iterator.next();
                if (URLFileSystem.equals(layout.getURL(), uRL)) {
                    return layout;
                }
                if ((layout = IdeLayout.findLayout(uRL, layout)) == null) continue;
                return layout;
            }
        }
        return null;
    }

    public InputStream getInputStream() throws IOException {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void openImpl() throws IOException {
        this._defaults = new SimpleLayout(this.getURL());
        this._defaults.setOwner(this);
        this.setActiveLayout(this._defaults);
        Integer n = Integer.valueOf(this._defaults.getProperty(COUNT_PROP, "0"));
        ExtensionRegistry extensionRegistry = ExtensionRegistry.getOracleRegistry();
        URL uRL = extensionRegistry.getSystemDirectory("oracle.ide");
        String string = uRL.getPath();
        int n2 = 0;
        while (n2 < n) {
            String string2;
            URL uRL2;
            String string3 = LAYOUT + Integer.toString(n2);
            String string4 = this._defaults.getProperty(string3, "");
            if (string4.length() > 0 && URLFileSystem.exists(uRL2 = URLFactory.newFileURL(string2 = string + string4 + ".layout"))) {
                SimpleLayout simpleLayout = new SimpleLayout(uRL2);
                this.add(simpleLayout);
            }
            ++n2;
        }
        String string5 = this._defaults.getProperty(ACTIVE_PROP, null);
        if (string5 != null) {
            String string6 = string + string5 + ".layout";
            URL uRL3 = URLFactory.newFileURL(string6);
            HashMap hashMap = this._layoutMap;
            synchronized (hashMap) {
                Layout layout = (Layout)this._layoutMap.get(uRL3);
                if (layout != null) {
                    this.setActiveLayout(layout);
                }
            }
        }
        this.markDirty(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeImpl() throws IOException {
        super.closeImpl();
        HashMap hashMap = this._layoutMap;
        synchronized (hashMap) {
            this._layoutMap.clear();
            this._layoutMap = null;
        }
        this._activeLayout = null;
        this._defaults = null;
        this._shortLabel = null;
        this._icon = null;
        this._iconBundle = null;
        this._iconBundleKey = -1;
    }

    protected void saveImpl() throws IOException {
        this._activeLayout.save();
        Iterator iterator = this.getChildren();
        if (iterator != null) {
            while (iterator.hasNext()) {
                Layout layout = (Layout)iterator.next();
                layout.save();
            }
        }
        this.saveDefaults();
    }

    public Layout getDefaults() {
        this.ensureOpen();
        return this._defaults;
    }

    public String getShortLabel() {
        return this._shortLabel;
    }

    public Icon getIcon() {
        if (this._icon == null && this._iconBundle != null) {
            this._icon = this._iconBundle.getIconImpl(this._iconBundleKey);
            this._iconBundle = null;
            this._iconBundleKey = -1;
        }
        return this._icon;
    }

    public String getLongLabel() {
        return this.getShortLabel();
    }

    public String getToolTipText() {
        return this.getShortLabel();
    }

    public boolean mayHaveChildren() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator getChildren() {
        this.ensureOpen();
        HashMap hashMap = this._layoutMap;
        synchronized (hashMap) {
            Iterator iterator = this._layoutMap.values().iterator();
            return iterator;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(Element element) {
        HashMap hashMap = this._layoutMap;
        synchronized (hashMap) {
            this._layoutMap.put(((Layout)element).getURL(), element);
        }
        ((Layout)element).setOwner(this);
        this.markDirty(true);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(Element element) {
        HashMap hashMap = this._layoutMap;
        synchronized (hashMap) {
            this._layoutMap.remove(((Layout)element).getURL());
        }
        this.markDirty(true);
        return true;
    }

    public boolean canRemove(Element element) {
        return element != this._activeLayout;
    }

    public boolean canAdd(Element element) {
        return element instanceof Layout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsChild(Element element) {
        HashMap hashMap = this._layoutMap;
        synchronized (hashMap) {
            boolean bl = this._layoutMap.containsValue(element);
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        HashMap hashMap = this._layoutMap;
        synchronized (hashMap) {
            int n = this._layoutMap.size();
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAll() {
        HashMap hashMap = this._layoutMap;
        synchronized (hashMap) {
            if (this._layoutMap.size() > 0) {
                this._layoutMap.clear();
                this.markDirty(true);
            }
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || object.getClass() != this.getClass()) {
            return false;
        }
        return this.equalsImpl((IdeLayout)object);
    }

    protected final boolean equalsImpl(IdeLayout ideLayout) {
        if (!super.equalsImpl(ideLayout)) {
            return false;
        }
        return this._activeLayout.equals(ideLayout._activeLayout) && ModelUtil.areEqual((Object)this._layoutMap, (Object)ideLayout._layoutMap);
    }

    protected void setActiveLayout(Layout layout) {
        if (this._activeLayout != null) {
            this._activeLayout.setActive(false);
        }
        this._activeLayout = layout;
        this._activeLayout.setActive(true);
        this.markDirty(true);
    }

    protected Map getLayoutMap() {
        return this._layoutMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveDefaults() {
        this.cleanupDefaultsLayout();
        int n = 0;
        HashMap hashMap = this._layoutMap;
        synchronized (hashMap) {
            n = this._layoutMap.size();
        }
        if (n > 0) {
            if (this._activeLayout != null) {
                this._defaults.setProperty(ACTIVE_PROP, this._activeLayout.getName());
            }
            this._defaults.setProperty(COUNT_PROP, Integer.toString(n));
            Iterator iterator = this.getChildren();
            n = 0;
            if (iterator != null) {
                while (iterator.hasNext()) {
                    Layout layout = (Layout)iterator.next();
                    String string = LAYOUT + Integer.toString(n++);
                    this._defaults.setProperty(string, layout.getName());
                }
            }
        } else {
            this._defaults.setProperty(COUNT_PROP, Integer.toString(0));
        }
        try {
            this._defaults.save();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void cleanupDefaultsLayout() {
        int n = 0;
        String string = LAYOUT + Integer.toString(n++);
        String string2 = this._defaults.getProperty(string, null);
        while (string2 != null) {
            this._defaults.removeProperty(string);
            string = LAYOUT + Integer.toString(n++);
            string2 = this._defaults.getProperty(string, null);
        }
        this._defaults.setProperty(ACTIVE_PROP, "");
    }
}

