/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.layout;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import oracle.bali.ewt.util.MenuUtils;
import oracle.ide.IdeConstants;
import oracle.ide.layout.IdeLayout;
import oracle.ide.layout.Layout;
import oracle.ide.layout.Layouts;
import oracle.ide.model.Element;
import oracle.ide.model.Observer;
import oracle.ide.model.UpdateMessage;

final class LayoutActivator
implements ActionListener,
MouseListener,
Observer {
    public static final boolean USE_COMBO = false;
    private JComboBox _comboBox;
    private JLabel _label;
    private ComboBoxModel _model;
    private Layouts _layouts;
    private IdeLayout _lastActive;
    private boolean _modelInit;
    private static final boolean MOUSE_OVER_EFFECT = false;

    private void whenSelectionChanges() {
        Layout layout = this.getSelectedLayout();
        if (!this._modelInit && layout != null && this._layouts.getActive() != layout && layout.getOwner().isActive()) {
            this._layouts.activateLayout(layout);
        }
        this.getLabel().setText(layout.getName());
    }

    public LayoutActivator(Layouts layouts) {
        this._layouts = layouts;
    }

    public JComponent getGUI() {
        return this.getLabel();
    }

    public Layout getSelectedLayout() {
        Layout layout = null;
        if (this._model != null) {
            layout = (Layout)this._model.getSelectedItem();
        }
        return layout;
    }

    public void setSelectedLayout(Layout layout) {
        if (this._model != null) {
            this._model.setSelectedItem(layout);
            this.whenSelectionChanges();
        }
    }

    public void update() {
        this.initModel(this._layouts.getActiveLayout());
    }

    public void hide() {
        JComponent jComponent = this.getGUI();
        if (jComponent != null) {
            jComponent.setVisible(false);
            if (this._lastActive != null) {
                this._lastActive.detach(this);
            }
        }
    }

    public void show() {
        JComponent jComponent = this.getGUI();
        if (jComponent != null && !jComponent.isVisible()) {
            this.update();
            jComponent.setVisible(true);
        }
    }

    public void update(Object object, UpdateMessage updateMessage) {
        int n;
        if (object == this._lastActive && (n = updateMessage.getMessageID()) == UpdateMessage.STRUCTURE_CHANGED) {
            this.update();
        }
    }

    protected void initModel(IdeLayout ideLayout) {
        if (this._lastActive != null) {
            this._lastActive.detach(this);
        }
        this._lastActive = ideLayout;
        this._lastActive.attach(this);
        Vector<Layout> vector = new Vector<Layout>();
        vector.add(ideLayout.getDefaults());
        this.addItems(ideLayout, vector);
        this._model = new DefaultComboBoxModel(vector);
        Layout layout = ideLayout.getActiveLayout() != null ? ideLayout.getActiveLayout() : ideLayout.getDefaults();
        this._modelInit = true;
        this._model.setSelectedItem(layout);
        this.whenSelectionChanges();
        this.getGUI().updateUI();
        this._modelInit = false;
    }

    protected IdeLayout getLastActive() {
        return this._lastActive;
    }

    private JComboBox getComboBox() {
        return this._comboBox;
    }

    private JLabel getLabel() {
        if (this._label == null) {
            this._label = new JLabel();
            Border border = this.getMouseOutBorder();
            this._label.setBorder(border);
            this._label.addMouseListener(this);
        }
        return this._label;
    }

    private Border getMouseOverBorder() {
        Border border = BorderFactory.createLineBorder(IdeConstants.COLOR_IDE_LINES, 1);
        Border border2 = BorderFactory.createEmptyBorder(2, 2, 2, 2);
        CompoundBorder compoundBorder = BorderFactory.createCompoundBorder(border, border2);
        return compoundBorder;
    }

    private Border getMouseOutBorder() {
        return BorderFactory.createEmptyBorder(3, 3, 3, 3);
    }

    private void addItems(Element element, List list) {
        Iterator iterator = element.getChildren();
        if (iterator != null) {
            while (iterator.hasNext()) {
                Element element2 = (Element)iterator.next();
                list.add(element2);
                this.addItems(element2, list);
            }
        }
    }

    private void whenMouseEvent(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            JPopupMenu jPopupMenu = new JPopupMenu();
            Layout layout = this.getSelectedLayout();
            int n = this._model.getSize();
            int n2 = 0;
            while (n2 < n) {
                Layout layout2 = (Layout)this._model.getElementAt(n2);
                boolean bl = layout2 == layout;
                String string = layout2.getName();
                JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(string, bl);
                jCheckBoxMenuItem.putClientProperty(this, layout2);
                jCheckBoxMenuItem.addActionListener(this);
                jPopupMenu.add(jCheckBoxMenuItem);
                ++n2;
            }
            MenuUtils.showPopupMenu((JPopupMenu)jPopupMenu, (Component)mouseEvent.getComponent(), (int)mouseEvent.getX(), (int)mouseEvent.getY());
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object instanceof JComponent) {
            JComponent jComponent = (JComponent)object;
            Object object2 = jComponent.getClientProperty(this);
            this._model.setSelectedItem(object2);
        }
        this.whenSelectionChanges();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        this.whenMouseEvent(mouseEvent);
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.whenMouseEvent(mouseEvent);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.whenMouseEvent(mouseEvent);
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }
}

