/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.layout;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.naming.Context;
import javax.swing.Icon;
import oracle.ide.Addin;
import oracle.ide.ExtensionRegistry;
import oracle.ide.Ide;
import oracle.ide.controls.Toolbar;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.layout.BaseLayoutListener;
import oracle.ide.layout.IdeLayout;
import oracle.ide.layout.Layout;
import oracle.ide.layout.LayoutActivator;
import oracle.ide.layout.LayoutListener;
import oracle.ide.layout.LayoutSelector;
import oracle.ide.layout.SimpleLayout;
import oracle.ide.layout.ViewId;
import oracle.ide.model.Attributes;
import oracle.ide.model.DefaultAttributes;
import oracle.ide.model.Element;
import oracle.ide.model.Folder;
import oracle.ide.model.UpdateMessage;
import oracle.ide.net.DefaultNameGenerator;
import oracle.ide.net.URLFactory;
import oracle.ide.resource.LayoutArb;
import oracle.ide.util.ModelUtil;
import oracle.ide.view.View;
import oracle.javatools.jndi.Names;

public class Layouts
implements Addin,
Folder {
    public static final String DATA_KEY = "layout-options";
    public static final String LAYOUT_EXT = ".layout";
    private static final String DESIGN_LAYOUT_NAME = LayoutArb.getString(1);
    public static final String DESIGN_FILENAME_BASE = "Editing";
    public static final String DESIGN_FILENAME = "Editing.layout";
    private static final String LAYOUTS_NAME = "ide/layouts";
    private static String _basename = LayoutArb.getString(3);
    private static DefaultNameGenerator _nameGenerator = new DefaultNameGenerator(_basename, ".layout");
    private static URL _directoryURL;
    private HashMap _layoutsMap;
    private IdeLayout _activeLayout;
    private IdeLayout _design;
    private boolean _useEditorPreferredLayout;
    private boolean _showLayoutActivator;
    private boolean _useActiveLayoutInEditor;
    private transient HashMap _startupListeners;
    private transient HashMap _listeners;
    private transient String _layoutsLabel;
    private transient LayoutActivator _layoutActivator;

    void $init$() {
        this._layoutsMap = new HashMap();
        this._useEditorPreferredLayout = true;
        this._showLayoutActivator = true;
        this._useActiveLayoutInEditor = true;
        this._startupListeners = new HashMap();
        this._listeners = new HashMap();
    }

    public Layouts() {
        this.$init$();
    }

    public static Layouts getLayouts() {
        return (Layouts)Names.lookup((Context)Names.newInitialContext(), (String)LAYOUTS_NAME);
    }

    public static void setLayouts(Layouts layouts) {
        Names.bind((Context)Names.newInitialContext(), (String)LAYOUTS_NAME, (Object)layouts);
    }

    public synchronized void addLayoutListener(String string, LayoutListener layoutListener) {
        this._listeners.put(string, layoutListener);
    }

    public synchronized void addStartupLayoutListener(String string, LayoutListener layoutListener) {
        this._startupListeners.put(string, layoutListener);
    }

    public void initialize() {
        if (this.isShowLayoutActivator()) {
            Toolbar toolbar = Ide.getStatusBar().getToolbar();
            this._layoutActivator = new LayoutActivator(this);
            toolbar.addComponent(this._layoutActivator.getGUI(), 0);
        }
    }

    public IdeLayout getActiveLayout() {
        if (this._activeLayout == null) {
            this._activeLayout = this.getDesignLayout();
        }
        return this._activeLayout;
    }

    public Layout getActiveSubLayout() {
        return this.getActiveLayout().getActiveLayout();
    }

    public Layout getActive() {
        Layout layout = this.getActiveSubLayout();
        return layout == null ? this.getActiveLayout() : layout;
    }

    public void activateLayout(IdeLayout ideLayout) {
        if (this._activeLayout != null) {
            this.close(this._activeLayout);
        }
        this._activeLayout = ideLayout;
        if (this._activeLayout != null) {
            this.activate(this._activeLayout, this._listeners);
            this._activeLayout.setActive(true);
            if (this._layoutActivator != null && this._layoutActivator.getLastActive() != ideLayout) {
                this._layoutActivator.update();
            }
        }
    }

    public void activateLayout(IdeLayout ideLayout, boolean bl) {
        if (bl) {
            this._activeLayout = ideLayout;
            this.activate(this._activeLayout, this._listeners);
            this.activate(Ide.getIdeProperties(), this._startupListeners);
            this._activeLayout.setActive(true);
            if (this._layoutActivator != null) {
                this._layoutActivator.update();
            }
        } else {
            this.activateLayout(ideLayout);
        }
    }

    public boolean isDesignActive() {
        return this.getActiveLayout() == this.getDesignLayout();
    }

    public void activatePreferredLayout(LayoutSelector layoutSelector) {
        Layout layout;
        if (!(this.isUseEditorPreferredLayout() && this.isDesignActive() && layoutSelector.isReady())) {
            return;
        }
        URL uRL = layoutSelector.getPreferredLayoutURL();
        if (uRL != null && (layout = this.getDesignLayout().findLayout(uRL)) != null && !uRL.equals(this.getDesignLayout().getActiveLayout().getURL())) {
            layoutSelector.initializeLayout(layout);
            this.activateLayout(layout);
            layoutSelector.initializeActiveLayout();
        }
    }

    public void activateLayout(Layout layout) {
        if (layout == null) {
            return;
        }
        IdeLayout ideLayout = layout.getOwner();
        if (!ideLayout.isActive()) {
            ideLayout.setActiveLayout(layout);
            return;
        }
        if (this._activeLayout != null) {
            this.close(this._activeLayout);
        }
        ideLayout.setActiveLayout(layout);
        this._activeLayout = ideLayout;
        this.activate(this._activeLayout, this._listeners);
        ideLayout.setActive(true);
        if (this.isUseEditorPreferredLayout() && this.isUseActiveLayoutInEditor() && this.isDesignActive()) {
            this.updateEditorPreferredLayout(layout);
        }
        if (this._layoutActivator != null && this._layoutActivator.getSelectedLayout() != layout) {
            this._layoutActivator.setSelectedLayout(layout);
        }
    }

    public void activateDefaultDesignLayout() {
        Layout layout = this.getDesignLayout().getDefaults();
        if (!layout.isActive()) {
            boolean bl = this.isUseActiveLayoutInEditor();
            this.setUseActiveLayoutInEditor(false);
            this.activateLayout(layout);
            this.setUseActiveLayoutInEditor(bl);
        }
    }

    public URL buildLayoutURL(String string) {
        URL uRL = Layouts.getDirectoryURL();
        String string2 = string + LAYOUT_EXT;
        return URLFactory.newURL(uRL, string2);
    }

    public Layout newDesignLayout(URL uRL) {
        SimpleLayout simpleLayout = new SimpleLayout(uRL);
        IdeLayout ideLayout = this.getDesignLayout();
        ideLayout.add(simpleLayout);
        UpdateMessage.fireStructureChanged(ideLayout);
        return simpleLayout;
    }

    public Layout newLayout(IdeLayout ideLayout) {
        URL uRL = this.generateLayoutURL();
        return this.newLayout(ideLayout, uRL);
    }

    public Layout newLayout(IdeLayout ideLayout, URL uRL) {
        SimpleLayout simpleLayout = new SimpleLayout(uRL);
        simpleLayout.ensureOpen();
        this.update(simpleLayout);
        try {
            simpleLayout.save();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        ideLayout.add(simpleLayout);
        return simpleLayout;
    }

    public synchronized IdeLayout getDesignLayout() {
        if (this._design == null) {
            URL uRL = URLFactory.newURL(Layouts.getDirectoryURL(), DESIGN_FILENAME);
            this._design = new IdeLayout(uRL, DESIGN_LAYOUT_NAME, LayoutArb.getInstance(), 0);
            this.add(this._design);
        }
        return this._design;
    }

    public void update(Layout layout) {
        this.update(layout, this._listeners.values().iterator());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void saveAll() {
        var1_1 = null;
        var4_2 = this._layoutsMap;
        synchronized (var4_2) {
            var1_1 = this._layoutsMap.values().iterator();
            // MONITOREXIT @DISABLED, blocks:[0, 2] lbl6 : MonitorExitStatement: MONITOREXIT : var4_2
            if (true) ** GOTO lbl18
        }
        do {
            if (!(var2_3 = (Layout)var1_1.next()).isDirty()) continue;
            this.update(var2_3);
            try {
                var2_3.save();
            }
            catch (IOException var3_4) {
                var3_4.printStackTrace();
            }
lbl18:
            // 4 sources

        } while (var1_1.hasNext());
        this.updateStartupLayout();
    }

    public View getView(ViewId viewId) {
        if (!viewId.isValid()) {
            return null;
        }
        LayoutListener layoutListener = (LayoutListener)this._listeners.get(viewId.getType());
        if (layoutListener == null && (layoutListener = (LayoutListener)this._startupListeners.get(viewId.getType())) == null) {
            return null;
        }
        return layoutListener.getView(viewId);
    }

    public void addView(ViewId viewId, View view) {
        if (!viewId.isValid()) {
            return;
        }
        LayoutListener layoutListener = (LayoutListener)this._listeners.get(viewId.getType());
        if (layoutListener == null && (layoutListener = (LayoutListener)this._startupListeners.get(viewId.getType())) == null) {
            return;
        }
        layoutListener.addView(viewId, view);
    }

    public BaseLayoutListener getLayoutListener(String string) {
        return (BaseLayoutListener)this._listeners.get(string);
    }

    public String getShortLabel() {
        if (this._layoutsLabel == null) {
            this._layoutsLabel = LayoutArb.getString(2);
        }
        return this._layoutsLabel;
    }

    public String getLongLabel() {
        return this.getShortLabel();
    }

    public Icon getIcon() {
        return null;
    }

    public boolean mayHaveChildren() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator getChildren() {
        HashMap hashMap = this._layoutsMap;
        synchronized (hashMap) {
            Iterator iterator = this._layoutsMap.values().iterator();
            return iterator;
        }
    }

    public String getToolTipText() {
        return this.getShortLabel();
    }

    public Object getData() {
        return this;
    }

    public Attributes getAttributes() {
        return DefaultAttributes.EMPTY_ATTRIBUTES;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(Element element) {
        HashMap hashMap = this._layoutsMap;
        synchronized (hashMap) {
            this._layoutsMap.put(((IdeLayout)element).getURL(), element);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(Element element) {
        HashMap hashMap = this._layoutsMap;
        synchronized (hashMap) {
            this._layoutsMap.remove(((IdeLayout)element).getURL());
        }
        return true;
    }

    public boolean canRemove(Element element) {
        return element != this._activeLayout;
    }

    public boolean canAdd(Element element) {
        return element instanceof IdeLayout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsChild(Element element) {
        HashMap hashMap = this._layoutsMap;
        synchronized (hashMap) {
            boolean bl = this._layoutsMap.containsValue(element);
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        HashMap hashMap = this._layoutsMap;
        synchronized (hashMap) {
            int n = this._layoutsMap.size();
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAll() {
        HashMap hashMap = this._layoutsMap;
        synchronized (hashMap) {
            this._layoutsMap.clear();
        }
    }

    public boolean isUseEditorPreferredLayout() {
        return this._useEditorPreferredLayout;
    }

    public void setUseEditorPreferredLayout(boolean bl) {
        this._useEditorPreferredLayout = bl;
    }

    public boolean isShowLayoutActivator() {
        return this._showLayoutActivator;
    }

    public void setShowLayoutActivator(boolean bl) {
        this._showLayoutActivator = bl;
        if (this._layoutActivator == null) {
            return;
        }
        if (bl) {
            this._layoutActivator.show();
        } else {
            this._layoutActivator.hide();
        }
    }

    public boolean isUseActiveLayoutInEditor() {
        return this._useActiveLayoutInEditor;
    }

    public void setUseActiveLayoutInEditor(boolean bl) {
        this._useActiveLayoutInEditor = bl;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || object.getClass() != this.getClass()) {
            return false;
        }
        return this.equalsImpl((Layouts)object);
    }

    protected final boolean equalsImpl(Layouts layouts) {
        return this._useEditorPreferredLayout == layouts._useEditorPreferredLayout && this._useActiveLayoutInEditor == layouts._useActiveLayoutInEditor && this._showLayoutActivator == layouts._showLayoutActivator && ModelUtil.areEqual((Object)this._layoutsMap, (Object)layouts._layoutsMap);
    }

    protected final void copyToImpl(Layouts layouts) {
        layouts._useEditorPreferredLayout = this._useEditorPreferredLayout;
        layouts._useActiveLayoutInEditor = this._useActiveLayoutInEditor;
        layouts._showLayoutActivator = this._showLayoutActivator;
        layouts._showLayoutActivator = this._showLayoutActivator;
        ModelUtil.deepCopy((Map)this._layoutsMap, (Map)layouts._layoutsMap);
        layouts._activeLayout = (IdeLayout)layouts._layoutsMap.get(this._activeLayout.getURL());
        layouts._activeLayout.setActive(true);
        layouts._design = (IdeLayout)layouts._layoutsMap.get(this._design.getURL());
    }

    protected static String getBaseName() {
        return _basename;
    }

    protected static URL getDirectoryURL() {
        if (_directoryURL == null) {
            ExtensionRegistry extensionRegistry = ExtensionRegistry.getOracleRegistry();
            _directoryURL = extensionRegistry.getSystemDirectory("oracle.ide");
        }
        return _directoryURL;
    }

    protected URL generateLayoutURL() {
        return URLFactory.newUniqueURL(Layouts.getDirectoryURL(), _nameGenerator);
    }

    protected void close(Layout layout) {
        for (BaseLayoutListener baseLayoutListener : this._listeners.values()) {
            baseLayoutListener.close(layout);
        }
        layout.setActive(false);
    }

    protected void activate(Layout layout, HashMap hashMap) {
        for (BaseLayoutListener baseLayoutListener : hashMap.values()) {
            baseLayoutListener.init(layout);
        }
        Iterator<Object> iterator = hashMap.values().iterator();
        ArrayList arrayList = new ArrayList();
        while (iterator.hasNext()) {
            LayoutListener layoutListener = (LayoutListener)iterator.next();
            layoutListener.addOpenedViews(layout, arrayList);
        }
        for (View view : arrayList) {
            view.show();
        }
    }

    protected void updateStartupLayout() {
        this.update(Ide.getIdeProperties(), this._startupListeners.values().iterator());
    }

    protected void update(Layout layout, Iterator iterator) {
        while (iterator.hasNext()) {
            BaseLayoutListener baseLayoutListener = (BaseLayoutListener)iterator.next();
            baseLayoutListener.save(layout);
        }
    }

    private void updateEditorPreferredLayout(Layout layout) {
        Editor editor = EditorManager.getEditorManager().getCurrentEditor();
        if (editor != null && !editor.getPreferredLayoutURL().equals(layout.getURL())) {
            editor.setPreferredLayoutURL(layout.getURL());
        }
    }
}

