/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.layout;

import java.io.BufferedInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import javax.swing.Icon;
import oracle.ide.layout.IdeLayout;
import oracle.ide.layout.Layout;
import oracle.ide.model.ElementAttributes;
import oracle.ide.net.URLFileSystem;
import oracle.ide.resource.LayoutArb;
import oracle.ide.util.OrderedProperties;

public class SimpleLayout
extends Layout {
    private OrderedProperties _properties;
    private IdeLayout _owner;

    public SimpleLayout(URL uRL) {
        super(uRL);
        this.getAttributes().set(ElementAttributes.DELETEABLE);
    }

    public String getProperty(String string, String string2) {
        this.ensureOpen();
        return this._properties.getProperty(string, string2);
    }

    public Object setProperty(String string, String string2) {
        this.ensureOpen();
        this.markDirty(true);
        if (string2 != null) {
            return this._properties.setProperty(string, string2);
        }
        return this._properties.remove(string);
    }

    public Object removeProperty(String string) {
        return this._properties.remove(string);
    }

    public boolean isPropertySet(String string, String string2, String string3) {
        String string4 = this.getProperty(string, string3);
        if (string4 == null) {
            return false;
        }
        return string4.equalsIgnoreCase(string2);
    }

    public IdeLayout getOwner() {
        return this._owner;
    }

    public void setOwner(IdeLayout ideLayout) {
        this._owner = ideLayout;
    }

    public Icon getIcon() {
        return LayoutArb.getIcon(0);
    }

    public InputStream getInputStream() throws IOException {
        URL uRL = this.getURL();
        return new BufferedInputStream(URLFileSystem.openInputStream(uRL));
    }

    private OutputStream getOutputStream() throws IOException {
        URL uRL = this.getURL();
        return URLFileSystem.openOutputStream(uRL);
    }

    protected void openImpl() throws IOException {
        this._properties = new OrderedProperties();
        super.openImpl();
        try {
            InputStream inputStream = this.getInputStream();
            this._properties.load(inputStream);
            inputStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    protected void closeImpl() throws IOException {
        super.closeImpl();
        this._properties = null;
        this._owner = null;
    }

    protected void saveImpl() throws IOException {
        if (this._properties != null) {
            OutputStream outputStream = this.getOutputStream();
            try {
                this._properties.store(outputStream, "Layout 5.0");
            }
            finally {
                if (outputStream != null) {
                    try {
                        outputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || object.getClass() != this.getClass()) {
            return false;
        }
        return this.equalsImpl((SimpleLayout)object);
    }

    protected final boolean equalsImpl(SimpleLayout simpleLayout) {
        return super.equalsImpl(simpleLayout);
    }
}

