/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.layout;

import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.StringTokenizer;
import oracle.ide.net.URLFactory;

public final class URL2String {
    private static final String PART_DELIMETER = " ";
    private static final String NULL_PART = ";";

    private URL2String() {
    }

    public static String toString(URL uRL) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(URL2String.encodeString(uRL.getProtocol()));
        stringBuffer.append(PART_DELIMETER);
        stringBuffer.append(URL2String.encodeString(uRL.getUserInfo()));
        stringBuffer.append(PART_DELIMETER);
        stringBuffer.append(URL2String.encodeString(uRL.getHost()));
        stringBuffer.append(PART_DELIMETER);
        stringBuffer.append(URL2String.encodeString(Integer.toString(uRL.getPort())));
        stringBuffer.append(PART_DELIMETER);
        stringBuffer.append(URL2String.encodeString(uRL.getPath()));
        stringBuffer.append(PART_DELIMETER);
        stringBuffer.append(URL2String.encodeString(uRL.getQuery()));
        stringBuffer.append(PART_DELIMETER);
        stringBuffer.append(URL2String.encodeString(uRL.getRef()));
        return stringBuffer.toString();
    }

    public static URL toURL(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, PART_DELIMETER);
        String[] stringArray = new String[7];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2 == null && n == 0) {
                return null;
            }
            stringArray[n++] = URL2String.decodeString(string2);
        }
        URL uRL = URLFactory.newURL(stringArray[0], stringArray[1], stringArray[2], URL2String.getIntValue(stringArray[3]), stringArray[4], stringArray[5], stringArray[6]);
        return uRL;
    }

    private static int getIntValue(String string) {
        if (string == null || string.length() == 0) {
            return -1;
        }
        return Integer.parseInt(string);
    }

    private static String encodeString(String string) {
        if (string != null && string.length() > 0) {
            try {
                String string2 = URLEncoder.encode(string, "UTF-8");
                return string2;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return NULL_PART;
    }

    private static String decodeString(String string) {
        if (!string.equals(NULL_PART)) {
            try {
                String string2 = URLDecoder.decode(string, "UTF-8");
                return string2;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return null;
    }
}

