/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.layout;

import java.io.File;
import java.util.StringTokenizer;

public class ViewId {
    public static final String DELIMETER = ".";
    public static final char NAME_SEPARATOR = '-';
    protected String type;
    protected String name;
    protected String displayName;
    protected String id;

    public ViewId(String string, String string2) {
        this.type = ViewId.validate(string);
        this.name = ViewId.validate(string2);
        this.displayName = string2;
    }

    public ViewId(String string) {
        if (string == null || string.length() == 0) {
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, DELIMETER);
        this.type = stringTokenizer.nextToken();
        if (stringTokenizer.hasMoreTokens()) {
            this.name = stringTokenizer.nextToken();
        }
    }

    public String getId() {
        if (this.id == null) {
            this.id = this.type;
            if (this.name != null && this.name.length() > 0) {
                this.id = this.id + DELIMETER + this.name;
            }
        }
        return this.id;
    }

    public String getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public boolean isValid() {
        return this.type != null;
    }

    public static String validate(String string) {
        if (string == null || string.length() <= 0) {
            return null;
        }
        String string2 = string.replace(File.separatorChar, '-');
        string2 = string2.replace(':', '-');
        return string2.replace('.', '-');
    }

    public String toString() {
        return this.getId();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ViewId)) {
            return false;
        }
        ViewId viewId = (ViewId)object;
        return this.getId().equals(viewId.getId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    protected ViewId() {
    }
}

