/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.log;

import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import javax.swing.JMenuItem;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuConstants;
import oracle.ide.log.LogManager;
import oracle.ide.log.LogPage;
import oracle.ide.log.LogRecognizer;
import oracle.ide.resource.LogArb;

public abstract class AbstractLogManager
extends LogManager
implements Controller {
    public static final int CLOSE_LOG_CMD_ID = Ide.findOrCreateCmdID("CLOSE_LOG_CMD_ID");
    protected static final int CLEAR_LOG_CMD_ID = Ide.findOrCreateCmdID("CLEAR_LOG_CMD_ID");
    protected static final int CLOSE_OTHER_LOGS_CMD_ID = Ide.findOrCreateCmdID("CLOSE_OTHER_LOGS_CMD_ID");
    protected static final int CLOSE_ALL_LOGS_CMD_ID = Ide.findOrCreateCmdID("CLOSE_ALL_LOGS_CMD_ID");
    protected static final int OPEN_FILE_CMD_ID = Ide.findOrCreateCmdID("OPEN_FILE_CMD_ID");
    private ContextMenu _contextMenu;
    private JMenuItem _clearMenu;
    private JMenuItem _closeMenu;
    private JMenuItem _closeOtherMenu;
    private JMenuItem _closeAllMenu;
    private IdeAction _closeAction;
    private IdeAction _closeOtherAction;
    private MouseListener _mouseListener;
    private ContextMenuListener _contextMenuListener;
    private ArrayList _logRecognizers;

    void $init$() {
        this._logRecognizers = new ArrayList();
    }

    public void addPage(LogPage logPage) {
        this.installMouseListener(logPage);
        Ide.getMainWindow().registerView(logPage.getLogPageView());
    }

    public void removePage(LogPage logPage) {
        logPage.removeMouseListener(this._mouseListener);
        Ide.getMainWindow().unregisterView(logPage.getLogPageView());
    }

    public ContextMenu getContextMenu() {
        if (this._contextMenu == null) {
            this._contextMenu = new ContextMenu();
            IdeAction ideAction = IdeAction.get(CLEAR_LOG_CMD_ID, null, LogArb.getString(7), null, LogArb.getInteger(8), LogArb.getInstance(), 9, null, true);
            this._clearMenu = this._contextMenu.createMenuItem(ideAction, MenuConstants.WEIGHT_LOG_WINDOW_CLEAR);
            ideAction.addController(this);
            this._closeAction = IdeAction.get(CLOSE_LOG_CMD_ID, null, LogArb.getString(4), null, LogArb.getInteger(5), LogArb.getInstance(), 6, null, true);
            this._closeMenu = this._contextMenu.createMenuItem(this._closeAction, MenuConstants.WEIGHT_FILE_CLOSE);
            this._closeAction.addController(this);
            this._closeOtherAction = IdeAction.get(CLOSE_OTHER_LOGS_CMD_ID, null, LogArb.getString(14), null, LogArb.getInteger(15), LogArb.getInstance(), 16, null, true);
            this._closeOtherMenu = this._contextMenu.createMenuItem(this._closeOtherAction, MenuConstants.WEIGHT_FILE_CLOSE_OTHERS);
            this._closeOtherAction.addController(this);
            ideAction = IdeAction.get(CLOSE_ALL_LOGS_CMD_ID, null, LogArb.getString(17), null, LogArb.getInteger(18), LogArb.getInstance(), 19, null, true);
            this._closeAllMenu = this._contextMenu.createMenuItem(ideAction, MenuConstants.WEIGHT_FILE_CLOSE_ALL);
            ideAction.addController(this);
            this.installContextMenuListener();
        }
        return this._contextMenu;
    }

    public void registerLogRecognizer(LogRecognizer logRecognizer) {
        this._logRecognizers.add(logRecognizer);
    }

    public void unregisterLogRecognizer(LogRecognizer logRecognizer) {
        this._logRecognizers.remove(logRecognizer);
    }

    public int getPageCount() {
        return 0;
    }

    public LogPage[] getPages() {
        return new LogPage[0];
    }

    protected Context getContext(EventObject eventObject) {
        return null;
    }

    protected void triggerPopup(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            JTree jTree;
            TreePath treePath;
            Component component = mouseEvent.getComponent();
            component.requestFocus();
            ContextMenu contextMenu = this.getContextMenu();
            if (contextMenu == null) {
                return;
            }
            if (component instanceof JTree && (treePath = (jTree = (JTree)component).getPathForLocation(mouseEvent.getX(), mouseEvent.getY())) != null) {
                TreePath[] treePathArray = jTree.getSelectionPaths();
                boolean bl = false;
                if (treePathArray != null) {
                    int n = 0;
                    while (n < treePathArray.length) {
                        if (treePathArray[n].getLastPathComponent() == treePath.getLastPathComponent()) {
                            bl = true;
                            break;
                        }
                        ++n;
                    }
                }
                if (!bl) {
                    jTree.setSelectionPath(treePath);
                }
            }
            Context context = this.getContext(mouseEvent);
            contextMenu.show(context);
        }
    }

    protected void installContextMenuListener() {
        if (this._contextMenuListener == null) {
            this._contextMenuListener = new 2();
        }
        this._contextMenu.addContextMenuListener(this._contextMenuListener);
    }

    protected void installMouseListener(LogPage logPage) {
        if (this._mouseListener == null) {
            this._mouseListener = new 1();
        }
        logPage.addMouseListener(this._mouseListener);
    }

    protected List getLogRecognizers() {
        return this._logRecognizers;
    }

    public AbstractLogManager() {
        this.$init$();
    }

    static JMenuItem ra$_clearMenu(AbstractLogManager abstractLogManager) {
        return abstractLogManager._clearMenu;
    }

    static JMenuItem ra$_closeMenu(AbstractLogManager abstractLogManager) {
        return abstractLogManager._closeMenu;
    }

    static IdeAction ra$_closeAction(AbstractLogManager abstractLogManager) {
        return abstractLogManager._closeAction;
    }

    static IdeAction ra$_closeOtherAction(AbstractLogManager abstractLogManager) {
        return abstractLogManager._closeOtherAction;
    }

    public final class 2
    implements ContextMenuListener {
        public void menuWillShow(ContextMenu contextMenu) {
            contextMenu.add((Component)AbstractLogManager.ra$_clearMenu(AbstractLogManager.this), MenuConstants.SECTION_LOG_WINDOW_CTXT_MENU);
            contextMenu.add((Component)AbstractLogManager.ra$_closeMenu(AbstractLogManager.this), MenuConstants.SECTION_LOG_WINDOW_CLOSE_CTXT_MENU);
            AbstractLogManager.ra$_closeAction(AbstractLogManager.this).updateAction(contextMenu.getContext());
            AbstractLogManager.ra$_closeOtherAction(AbstractLogManager.this).updateAction(contextMenu.getContext());
        }

        public void menuWillHide(ContextMenu contextMenu) {
        }

        public boolean handleDefaultAction(Context context) {
            return false;
        }
    }

    public final class 1
    extends MouseAdapter {
        public void mousePressed(MouseEvent mouseEvent) {
            AbstractLogManager.this.triggerPopup(mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            AbstractLogManager.this.triggerPopup(mouseEvent);
        }
    }
}

