/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.log;

import java.awt.event.MouseListener;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import oracle.ide.controller.Controller;
import oracle.ide.docking.DockStation;
import oracle.ide.layout.ViewId;
import oracle.ide.log.LogManager;
import oracle.ide.log.LogOwner;
import oracle.ide.log.LogPage;
import oracle.ide.log.LogWindow;
import oracle.ide.util.GraphicsUtils;
import oracle.ide.view.View;

public abstract class AbstractLogPage
extends View
implements LogPage {
    private Icon _icon;
    private String _name;

    protected AbstractLogPage(String string, String string2, Icon icon, boolean bl) {
        super(string);
        this._icon = icon;
        this._name = string2;
        if (bl) {
            AbstractLogPage._addPage(this);
        }
    }

    protected AbstractLogPage(ViewId viewId, Icon icon, boolean bl) {
        this(viewId.getId(), viewId.getDisplayName(), icon, bl);
    }

    protected AbstractLogPage(ViewId viewId, Icon icon) {
        this(viewId, icon, true);
    }

    protected AbstractLogPage(ViewId viewId) {
        this(viewId, null);
    }

    public void log(Object object) {
        this.log(object, false);
    }

    public void log(Object object, boolean bl) {
        this.requestShow(bl);
        this.logMsg(object);
    }

    public void clearAll() {
    }

    public String getTitleName() {
        return this.getTabName();
    }

    public String getTabName() {
        return this._name;
    }

    public void tabNameUpdated() {
        LogWindow logWindow = LogManager.getIdeLogWindow();
        if (logWindow != null) {
            logWindow.updateTitle(null);
        }
    }

    public Icon getTabIcon() {
        return this._icon;
    }

    public String getToolTip() {
        return this.getTabName();
    }

    public void setOwner(LogOwner logOwner) {
        View view = null;
        if (logOwner != null) {
            view = logOwner.getLogOwnerView();
        }
        super.setOwner(view);
    }

    public void addMouseListener(MouseListener mouseListener) {
    }

    public void removeMouseListener(MouseListener mouseListener) {
    }

    public View getLogPageView() {
        return this;
    }

    protected void logMsg(Object object) {
    }

    protected void requestShow(boolean bl) {
        AbstractLogPage abstractLogPage = this;
        2 var3_3 = new 2(this, bl, abstractLogPage);
        if (SwingUtilities.isEventDispatchThread()) {
            var3_3.run();
        } else {
            SwingUtilities.invokeLater(var3_3);
        }
    }

    protected void requestShow() {
        this.requestShow(false);
    }

    private static void _addPage(AbstractLogPage abstractLogPage) {
        1 var1_1 = new 1(abstractLogPage);
        if (SwingUtilities.isEventDispatchThread()) {
            var1_1.run();
        } else {
            try {
                SwingUtilities.invokeLater(var1_1);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public Controller getController() {
        if (this.owner() != null) {
            return this.owner().getController();
        }
        return null;
    }

    public void show() {
        if (this.owner() == null) {
            LogManager.getLogManager().addPage(this);
        }
        ((LogOwner)((Object)this.owner())).selectPage(this);
        LogWindow logWindow = LogManager.getIdeLogWindow();
        DockStation.getDockStation().activateDockable(logWindow);
        GraphicsUtils.focusComponentOrChild(this.getGUI(), true);
    }

    public void close() {
        if (this.owner() != null) {
            this.owner().close();
        }
    }

    public boolean isVisible() {
        if (this.owner() == null) {
            return false;
        }
        return this.owner().isVisible();
    }

    public final class 2
    implements Runnable {
        private final /* synthetic */ boolean v$forceDisplay;
        private final /* synthetic */ LogPage v$logPage;
        final /* synthetic */ AbstractLogPage this$0;

        public void run() {
            LogOwner logOwner = (LogOwner)((Object)this.this$0.owner());
            LogWindow logWindow = LogManager.getIdeLogWindow();
            if (!this.v$forceDisplay && logOwner != null && DockStation.getDockStation().isDockableVisible(logWindow)) {
                logOwner.highlightPage(this.v$logPage);
            } else {
                this.this$0.show();
            }
        }

        public 2(AbstractLogPage abstractLogPage, boolean bl, LogPage logPage) {
            this.v$logPage = logPage;
            this.v$forceDisplay = bl;
            this.this$0 = abstractLogPage;
        }
    }

    public static final class 1
    implements Runnable {
        private final /* synthetic */ AbstractLogPage v$page;

        public void run() {
            LogManager.getLogManager().addPage(this.v$page);
        }

        public 1(AbstractLogPage abstractLogPage) {
            this.v$page = abstractLogPage;
        }
    }
}

