/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.log;

import java.awt.Component;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URL;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuConstants;
import oracle.ide.controls.WaitCursor;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.layout.ViewId;
import oracle.ide.log.AbstractLogPage;
import oracle.ide.log.LogManager;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFileSystem;
import oracle.ide.resource.IdeArb;
import oracle.ide.resource.LogArb;
import oracle.ide.util.AccessibleUtils;
import oracle.ide.util.BitField;

public class DefaultLogPage
extends AbstractLogPage {
    private static int _shift = 0;
    public static int HIDE_NO_MENUS = 0;
    public static int HIDE_COPY_MENU = 1 << _shift++;
    public static int HIDE_SAVE_AS_MENU = 1 << _shift++;
    public static int HIDE_GOTO_SOURCE_MENU = 1 << _shift++;
    public static int HIDE_FIX_SOURCE_MENU = 1 << _shift++;
    public static int HIDE_ALL_MENUS = HIDE_COPY_MENU | HIDE_SAVE_AS_MENU | HIDE_GOTO_SOURCE_MENU | HIDE_FIX_SOURCE_MENU;
    protected static final int GOTO_SOURCE_CMD_ID = Ide.findOrCreateCmdID("GOTO_SOURCE_CMD_ID");
    protected static final int FIX_SOURCE_CMD_ID = Ide.findOrCreateCmdID("FIX_SOURCE_CMD_ID");
    private static URL _lastSaveToFileURL = null;
    protected MouseAdapter mouseAdapter;
    protected KeyAdapter keyAdapter;
    private Controller _controller;
    private JMenuItem _copyMenu;
    private JMenuItem _saveAsMenu;
    private JMenuItem _gotoSourceMenu;
    private JMenuItem _fixSourceMenu;
    private boolean _popupMenuItemsInitialized;
    private JTree tree;
    private JTextArea textArea;
    private JScrollPane scrollPane;

    void $init$() {
        this.mouseAdapter = new DefaultAdapter(null);
        this.keyAdapter = new DefaultKeyAdapter(null);
        this.tree = new 1(null);
        this.textArea = new JTextArea();
        this.scrollPane = new JScrollPane(this.tree);
    }

    protected DefaultLogPage(ViewId viewId, Icon icon, boolean bl, int n) {
        super(viewId, icon, false);
        this.$init$();
        this.scrollPane.setBorder(BorderFactory.createEmptyBorder());
        this.initPopupMenuItems(n);
        this.textArea.setEditable(false);
        this.textArea.setToolTipText(this.getToolTip());
        this.tree.addMouseListener(this.mouseAdapter);
        this.tree.addKeyListener(this.keyAdapter);
        this.tree.setRootVisible(false);
        this.tree.setToolTipText(this.getToolTip());
        this.tree.getSelectionModel().setSelectionMode(1);
        ToolTipManager.sharedInstance().registerComponent(this.tree);
        if (bl) {
            LogManager.getLogManager().addPage(this);
        }
    }

    protected DefaultLogPage(ViewId viewId, Icon icon, boolean bl) {
        this(viewId, icon, false, HIDE_FIX_SOURCE_MENU);
    }

    protected void setModel(TreeModel treeModel) {
        if (this.tree == null || treeModel == null) {
            return;
        }
        this.tree.setModel(treeModel);
        int n = this.tree.getRowCount();
        if (n > 0) {
            if (this.tree.isRootVisible()) {
                this.tree.setSelectionRow(0);
            } else if (n > 1) {
                this.tree.setSelectionRow(1);
            }
        }
    }

    private void initPopupMenuItems(int n) {
        if (!this._popupMenuItemsInitialized) {
            this._popupMenuItemsInitialized = true;
            ContextMenu contextMenu = LogManager.getLogManager().getContextMenu();
            IdeAction ideAction = null;
            if (!BitField.isSet(n, HIDE_COPY_MENU)) {
                ideAction = IdeAction.find(18);
                this._copyMenu = contextMenu.createMenuItem(ideAction, MenuConstants.WEIGHT_EDIT_COPY);
            }
            if (!BitField.isSet(n, HIDE_SAVE_AS_MENU)) {
                ideAction = IdeAction.find(12);
                this._saveAsMenu = contextMenu.createMenuItem(ideAction, MenuConstants.WEIGHT_LOG_WINDOW_SAVE_AS);
            }
            if (!BitField.isSet(n, HIDE_GOTO_SOURCE_MENU)) {
                ideAction = IdeAction.get(GOTO_SOURCE_CMD_ID, null, LogArb.getString(10), (String)null, LogArb.getInteger(11), LogArb.getInstance(), 12, null, true);
                this._gotoSourceMenu = contextMenu.createMenuItem(ideAction, MenuConstants.WEIGHT_NAVIGATE_GO_TO_CLASS);
                ideAction.addController(this.getController());
            }
            if (!BitField.isSet(n, HIDE_FIX_SOURCE_MENU)) {
                ideAction = IdeAction.get(FIX_SOURCE_CMD_ID, null, LogArb.getString(20), (String)null, LogArb.getInteger(21), LogArb.getInstance(), 22, null, true);
                this._fixSourceMenu = contextMenu.createMenuItem(ideAction);
                ideAction.addController(this.getController());
            }
            if (ideAction != null) {
                contextMenu.addContextMenuListener(new PrivateContextMenuListener(null));
            }
        }
    }

    private Object getNextLeaf(int n) {
        int n2 = -1;
        if (this.tree.getSelectionPath() != null) {
            n2 = this.tree.getRowForPath(this.tree.getSelectionPath());
        }
        while ((n2 += n) >= 0 && n2 < this.tree.getRowCount()) {
            TreePath treePath = this.tree.getPathForRow(n2);
            Object object = treePath.getLastPathComponent();
            if (!this.tree.getModel().isLeaf(object)) continue;
            this.tree.setSelectionPath(treePath);
            return object;
        }
        return null;
    }

    public String getTitleName() {
        String string = super.getTitleName();
        AccessibleUtils.updateAccessibleName(this.getTree(), string, true);
        AccessibleUtils.updateAccessibleName(this.getTextArea(), string, true);
        return string;
    }

    public Component getGUI() {
        return this.scrollPane;
    }

    protected final DefaultMutableTreeNode getSelectedTreeNode() {
        Object object;
        TreePath treePath = this.tree.getSelectionPath();
        if (treePath != null && (object = treePath.getLastPathComponent()) instanceof DefaultMutableTreeNode) {
            return (DefaultMutableTreeNode)object;
        }
        return null;
    }

    protected String treeNodeToString(Object object) {
        return String.valueOf(object);
    }

    private final void copy(Object object) {
        StringSelection stringSelection = new StringSelection(this.treeNodeToString(object));
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(stringSelection, null);
    }

    protected void saveToFile(Context context) {
        URL uRL;
        if (this.tree == null || this.tree.getRowCount() <= 0) {
            return;
        }
        String string = LogArb.getString(13);
        URLChooser uRLChooser = DialogUtil.newURLChooser(context);
        uRLChooser.setHelpID("f1_idedsaveasrename_html");
        if (_lastSaveToFileURL != null) {
            uRLChooser.setSelectedURL(_lastSaveToFileURL);
        }
        if (uRLChooser.showSaveDialog((Component)((Object)Ide.getMainWindow()), string) == 0 && (uRL = uRLChooser.getSelectedURL()) != null) {
            _lastSaveToFileURL = uRL;
            WaitCursor waitCursor = Ide.getWaitCursor();
            waitCursor.show();
            try {
                String string2 = Ide.getEnvironOptions().getEncoding();
                OutputStream outputStream = URLFileSystem.openOutputStream(uRL);
                PrintStream printStream = string2 == null ? new PrintStream(outputStream) : new PrintStream(outputStream, false, string2);
                int n = 0;
                int n2 = 0;
                while (n2 < this.tree.getRowCount()) {
                    TreePath treePath = this.tree.getPathForRow(n2);
                    if (treePath != null) {
                        Object object;
                        if (n2 == 0) {
                            n = treePath.getPathCount();
                        }
                        if ((object = treePath.getLastPathComponent()) != null) {
                            int n3 = (treePath.getPathCount() - n) * 4;
                            int n4 = 0;
                            while (n4 < n3) {
                                printStream.print(" ");
                                ++n4;
                            }
                            printStream.println(this.treeNodeToString(object));
                        }
                    }
                    ++n2;
                }
                printStream.flush();
                printStream.close();
            }
            catch (Exception exception) {
                String string3 = URLFileSystem.getPlatformPathName(uRL);
                String string4 = LogArb.format(29, string3);
                JOptionPane.showMessageDialog((Component)((Object)Ide.getMainWindow()), string4, IdeArb.getString(240), 0);
            }
            waitCursor.hide();
        }
    }

    public Controller getController() {
        if (this._controller == null) {
            this._controller = new DefaultLogPageController(null);
        }
        return this._controller;
    }

    public ContextMenu getContextMenu() {
        ContextMenu contextMenu = LogManager.getLogManager().getContextMenu();
        return contextMenu;
    }

    public void clearAll() {
        this.tree.setModel(null);
        this.textArea.setText("");
        this.textArea.setCaretPosition(this.textArea.getDocument().getLength());
    }

    public void addMouseListener(MouseListener mouseListener) {
        if (mouseListener != null) {
            this.textArea.addMouseListener(mouseListener);
            this.tree.addMouseListener(mouseListener);
        }
    }

    public void removeMouseListener(MouseListener mouseListener) {
        if (mouseListener != null) {
            this.tree.removeMouseListener(mouseListener);
            this.textArea.removeMouseListener(mouseListener);
        }
    }

    public void addKeyListener(KeyListener keyListener) {
        if (keyListener != null) {
            this.textArea.addKeyListener(keyListener);
            this.tree.addKeyListener(keyListener);
        }
    }

    public void removeKeyListener(KeyListener keyListener) {
        if (keyListener != null) {
            this.tree.removeKeyListener(keyListener);
            this.textArea.removeKeyListener(keyListener);
        }
    }

    protected void logMsg(Object object) {
        if (object instanceof Collection) {
            if (this.getCurrentView() != this.tree) {
                this.setCurrentView(this.tree);
            }
            this.updateTreeModel((Collection)object);
        } else {
            this.logText(object.toString());
        }
    }

    protected void logText(String string) {
        if (this.getCurrentView() != this.textArea) {
            this.setCurrentView(this.textArea);
        }
        this.textArea.append(string);
        this.textArea.setCaretPosition(this.textArea.getDocument().getLength());
    }

    protected final Component getCurrentView() {
        JViewport jViewport = this.scrollPane.getViewport();
        return jViewport != null ? jViewport.getView() : null;
    }

    protected final void setCurrentView(Component component) {
        this.scrollPane.setViewportView(component);
    }

    protected final JTree getTree() {
        return this.tree;
    }

    protected final JTextArea getTextArea() {
        return this.textArea;
    }

    protected void activateObject(Object object) {
    }

    protected void fixObject(Object object) {
    }

    protected boolean canFixObject(DefaultMutableTreeNode defaultMutableTreeNode) {
        return false;
    }

    protected void updateTreeModel(Collection collection) {
        try {
            SwingUtilities.invokeLater(new DefaultModelBuilder(collection));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static JMenuItem ra$_gotoSourceMenu(DefaultLogPage defaultLogPage) {
        return defaultLogPage._gotoSourceMenu;
    }

    static JMenuItem ra$_fixSourceMenu(DefaultLogPage defaultLogPage) {
        return defaultLogPage._fixSourceMenu;
    }

    static JMenuItem ra$_copyMenu(DefaultLogPage defaultLogPage) {
        return defaultLogPage._copyMenu;
    }

    static JMenuItem ra$_saveAsMenu(DefaultLogPage defaultLogPage) {
        return defaultLogPage._saveAsMenu;
    }

    static JTree ra$tree(DefaultLogPage defaultLogPage) {
        return defaultLogPage.tree;
    }

    static Object mav$getNextLeaf(DefaultLogPage defaultLogPage, int n) {
        return defaultLogPage.getNextLeaf(n);
    }

    static void mav$copy(DefaultLogPage defaultLogPage, Object object) {
        defaultLogPage.copy(object);
    }

    public final class 1
    extends JTree {
        public String convertValueToText(Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            return DefaultLogPage.this.treeNodeToString(object);
        }

        public 1(TreeModel treeModel) {
            super(treeModel);
        }
    }

    private class PrivateContextMenuListener
    implements ContextMenuListener {
        public void menuWillShow(ContextMenu contextMenu) {
            if (contextMenu == null) {
                return;
            }
            Context context = contextMenu.getContext();
            if (context == null || context.getView() != DefaultLogPage.this) {
                return;
            }
            if (DefaultLogPage.ra$_gotoSourceMenu(DefaultLogPage.this) != null) {
                contextMenu.add((Component)DefaultLogPage.ra$_gotoSourceMenu(DefaultLogPage.this), MenuConstants.SECTION_NAVIGATE_CTXT_MENU);
            }
            if (DefaultLogPage.ra$_fixSourceMenu(DefaultLogPage.this) != null) {
                contextMenu.add((Component)DefaultLogPage.ra$_fixSourceMenu(DefaultLogPage.this), MenuConstants.SECTION_LOG_WINDOW_CTXT_MENU);
            }
            if (DefaultLogPage.ra$_copyMenu(DefaultLogPage.this) != null) {
                contextMenu.add((Component)DefaultLogPage.ra$_copyMenu(DefaultLogPage.this), MenuConstants.SECTION_EDIT_CTXT_MENU);
            }
            if (DefaultLogPage.ra$_saveAsMenu(DefaultLogPage.this) != null) {
                contextMenu.add((Component)DefaultLogPage.ra$_saveAsMenu(DefaultLogPage.this), MenuConstants.SECTION_LOG_WINDOW_CTXT_MENU);
            }
        }

        public void menuWillHide(ContextMenu contextMenu) {
        }

        public boolean handleDefaultAction(Context context) {
            return false;
        }

        private PrivateContextMenuListener() {
        }

        PrivateContextMenuListener(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class DefaultLogPageController
    implements Controller {
        public boolean handleEvent(IdeAction ideAction, Context context) {
            if (ideAction != null) {
                int n = ideAction.getCommandId();
                if (n == 30 || n == 31) {
                    Object object = DefaultLogPage.mav$getNextLeaf(DefaultLogPage.this, n == 31 ? -1 : 1);
                    if (object != null) {
                        DefaultLogPage.ra$tree(DefaultLogPage.this).scrollPathToVisible(DefaultLogPage.ra$tree(DefaultLogPage.this).getSelectionPath());
                        DefaultLogPage.this.activateObject(object);
                    }
                    return true;
                }
                if (n == 18 || n == GOTO_SOURCE_CMD_ID || n == FIX_SOURCE_CMD_ID) {
                    Object object;
                    TreePath treePath = DefaultLogPage.ra$tree(DefaultLogPage.this).getSelectionPath();
                    if (treePath != null && (object = treePath.getLastPathComponent()) != null) {
                        if (n == GOTO_SOURCE_CMD_ID) {
                            DefaultLogPage.this.activateObject(object);
                        } else if (n == FIX_SOURCE_CMD_ID) {
                            DefaultLogPage.this.fixObject(object);
                        } else {
                            DefaultLogPage.mav$copy(DefaultLogPage.this, object);
                        }
                    }
                    return true;
                }
                if (n == 12) {
                    DefaultLogPage.this.saveToFile(context);
                    return true;
                }
            }
            return false;
        }

        public boolean update(IdeAction ideAction, Context context) {
            if (ideAction == null) {
                return true;
            }
            int n = ideAction.getCommandId();
            if (n == 30 || n == 31 || n == 12) {
                ideAction.setEnabled(DefaultLogPage.ra$tree(DefaultLogPage.this) != null && DefaultLogPage.ra$tree(DefaultLogPage.this).getRowCount() > 0);
                return true;
            }
            if (n == 18) {
                TreePath treePath = DefaultLogPage.ra$tree(DefaultLogPage.this).getSelectionPath();
                ideAction.setEnabled(treePath != null && treePath.getLastPathComponent() != null);
                return true;
            }
            if (n == FIX_SOURCE_CMD_ID) {
                boolean bl = false;
                DefaultMutableTreeNode defaultMutableTreeNode = DefaultLogPage.this.getSelectedTreeNode();
                if (defaultMutableTreeNode != null) {
                    bl = !defaultMutableTreeNode.isLeaf() ? false : DefaultLogPage.this.canFixObject(defaultMutableTreeNode);
                }
                ideAction.setEnabled(bl);
                return true;
            }
            if (n == GOTO_SOURCE_CMD_ID) {
                boolean bl = false;
                DefaultMutableTreeNode defaultMutableTreeNode = DefaultLogPage.this.getSelectedTreeNode();
                if (defaultMutableTreeNode != null) {
                    bl = defaultMutableTreeNode.isLeaf();
                }
                ideAction.setEnabled(bl);
                return true;
            }
            return false;
        }

        private DefaultLogPageController() {
        }

        DefaultLogPageController(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private final class DefaultAdapter
    extends MouseAdapter {
        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent == null || mouseEvent.getClickCount() != 2) {
                return;
            }
            TreePath treePath = DefaultLogPage.ra$tree(DefaultLogPage.this).getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
            Object object = treePath != null ? treePath.getLastPathComponent() : null;
            TreeModel treeModel = DefaultLogPage.ra$tree(DefaultLogPage.this).getModel();
            if (object != null && treeModel != null && treeModel.isLeaf(object)) {
                DefaultLogPage.this.activateObject(object);
            }
        }

        private DefaultAdapter() {
        }

        DefaultAdapter(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private final class DefaultKeyAdapter
    extends KeyAdapter {
        public void keyTyped(KeyEvent keyEvent) {
            if (keyEvent == null || keyEvent.isConsumed() || keyEvent.getKeyChar() != '\n') {
                return;
            }
            TreeModel treeModel = DefaultLogPage.ra$tree(DefaultLogPage.this).getModel();
            Object object = DefaultLogPage.ra$tree(DefaultLogPage.this).getLastSelectedPathComponent();
            if (object != null && treeModel != null && treeModel.isLeaf(object)) {
                DefaultLogPage.this.activateObject(object);
            }
        }

        private DefaultKeyAdapter() {
        }

        DefaultKeyAdapter(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private final class DefaultModelBuilder
    implements Runnable {
        Collection message;

        DefaultModelBuilder(Collection collection) {
            this.message = collection;
        }

        public void run() {
            if (this.message == null) {
                DefaultLogPage.ra$tree(DefaultLogPage.this).setModel(null);
                return;
            }
            DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode();
            DefaultTreeModel defaultTreeModel = new DefaultTreeModel(defaultMutableTreeNode);
            Iterator iterator = this.message.iterator();
            while (iterator.hasNext()) {
                DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(iterator.next());
                defaultMutableTreeNode.add(defaultMutableTreeNode2);
            }
            DefaultLogPage.ra$tree(DefaultLogPage.this).setModel(defaultTreeModel);
            int n = DefaultLogPage.ra$tree(DefaultLogPage.this).getRowCount() - 1;
            while (n >= 0) {
                DefaultLogPage.ra$tree(DefaultLogPage.this).expandRow(n);
                --n;
            }
        }
    }
}

