/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.log;

import java.awt.Color;
import java.awt.Cursor;
import java.net.URL;
import javax.swing.text.AttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import oracle.ide.Ide;
import oracle.ide.config.EnvironOptions;
import oracle.ide.config.IdeSettings;
import oracle.ide.log.StyledMessage;

public abstract class Href
extends StyledMessage {
    protected final URL _url;
    private static int hrefColor;
    private static SimpleAttributeSet attributeSet;

    public Href(String string, URL uRL) {
        this(string, uRL, Href.getAttributeSet());
    }

    public Href(String string, URL uRL, AttributeSet attributeSet) {
        super(attributeSet, string);
        this._url = uRL;
    }

    public final URL getURL() {
        return this._url;
    }

    public abstract void go();

    public Cursor getCursor() {
        return Cursor.getPredefinedCursor(12);
    }

    private static synchronized SimpleAttributeSet getAttributeSet() {
        if (attributeSet == null) {
            attributeSet = new SimpleAttributeSet();
            StyleConstants.setUnderline(attributeSet, true);
        }
        IdeSettings ideSettings = Ide.getSettings();
        EnvironOptions environOptions = (EnvironOptions)ideSettings.getData("environment-options");
        if (hrefColor == 0 || hrefColor != environOptions.getLogHrefColor()) {
            hrefColor = environOptions.getLogHrefColor();
            StyleConstants.setForeground(attributeSet, new Color(hrefColor));
        }
        return attributeSet;
    }
}

