/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.log;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintStream;
import oracle.ide.log.LogPage;
import oracle.ide.log.LogPageWrapper;
import oracle.ide.log.LogPipe;
import oracle.ide.nulls.DefaultPrintStream;

public class LogPrintStream
extends PrintStream {
    private final LogPage _logPage;

    public LogPrintStream(LogPage logPage) {
        super(LogPrintStream.getOutputStreamToWrap(logPage), true);
        this._logPage = logPage;
    }

    public LogPage getLogPage() {
        return this._logPage;
    }

    public LogPage getWrappedLogPage() {
        LogPage logPage = this.getLogPage();
        return new 1(logPage);
    }

    private static OutputStream getOutputStreamToWrap(LogPage logPage) {
        if (logPage != null) {
            try {
                PipedOutputStream pipedOutputStream = new PipedOutputStream();
                PipedInputStream pipedInputStream = new PipedInputStream(pipedOutputStream);
                InputStreamReader inputStreamReader = new InputStreamReader(pipedInputStream);
                new LogPipe(logPage, new BufferedReader(inputStreamReader));
                PipedOutputStream pipedOutputStream2 = pipedOutputStream;
                return pipedOutputStream2;
            }
            catch (IOException iOException) {
                System.err.println("Unable to create PrintStream for log window -- wiring into System.out instead...");
                iOException.printStackTrace();
            }
        }
        return new DefaultPrintStream();
    }

    public final class 1
    extends LogPageWrapper {
        public void log(Object object) {
            if (object != null) {
                LogPrintStream.this.print(object.toString());
            }
        }

        public 1(LogPage logPage) {
            super(logPage);
        }
    }
}

