/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.log;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PipedReader;
import java.io.PipedWriter;
import java.io.PrintWriter;
import java.io.Writer;
import oracle.ide.log.LogPage;
import oracle.ide.log.LogPageWrapper;
import oracle.ide.log.LogPipe;
import oracle.ide.log.MessagePage;
import oracle.ide.nulls.DefaultPrintWriter;

public class LogPrintWriter
extends PrintWriter {
    private final LogPage _logPage;

    public LogPrintWriter(LogPage logPage) {
        super(LogPrintWriter.getWriterToWrap(logPage), true);
        this._logPage = logPage;
    }

    public void close() {
        super.close();
    }

    public LogPage getLogPage() {
        return this._logPage;
    }

    public LogPage getWrappedLogPage() {
        LogPage logPage = this.getLogPage();
        return new 1(logPage);
    }

    private static Writer getWriterToWrap(LogPage logPage) {
        if (logPage instanceof MessagePage) {
            return new MPWriter((MessagePage)logPage);
        }
        if (logPage != null) {
            try {
                PipedWriter pipedWriter = new PipedWriter();
                PipedReader pipedReader = new PipedReader(pipedWriter);
                new LogPipe(logPage, new BufferedReader(pipedReader));
                PipedWriter pipedWriter2 = pipedWriter;
                return pipedWriter2;
            }
            catch (IOException iOException) {
                System.err.println("Unable to create PrintWriter for log window -- wiring into System.out instead...");
                iOException.printStackTrace();
            }
        }
        return new DefaultPrintWriter();
    }

    public final class 1
    extends LogPageWrapper {
        public void log(Object object) {
            if (object != null) {
                LogPrintWriter.this.print(object.toString());
            }
        }

        public 1(LogPage logPage) {
            super(logPage);
        }
    }

    private static class MPWriter
    extends Writer {
        private MessagePage _page;

        MPWriter(MessagePage messagePage) {
            this._page = messagePage;
        }

        public void close() {
            this._page = null;
        }

        public void flush() {
        }

        public void write(char[] cArray, int n, int n2) {
            if (this._page == null) {
                throw new IllegalStateException("MPWriter is closed");
            }
            this._page.log(new String(cArray, n, n2));
        }
    }
}

