/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.log;

import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleHyperlink;
import javax.accessibility.AccessibleHypertext;
import javax.accessibility.AccessibleText;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JEditorPane;
import javax.swing.JMenuItem;
import javax.swing.JScrollBar;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.MouseInputAdapter;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;
import javax.swing.text.StyledDocument;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.config.EnvironOptions;
import oracle.ide.config.IdeSettings;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuConstants;
import oracle.ide.controls.JAutoScrollPane;
import oracle.ide.controls.WaitCursor;
import oracle.ide.controls.WrappingTextPane;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.dialogs.MessageDialog;
import oracle.ide.help.HelpInfo;
import oracle.ide.keyboard.KeyUtil;
import oracle.ide.layout.ViewId;
import oracle.ide.log.AbstractLogPage;
import oracle.ide.log.Href;
import oracle.ide.log.LogManager;
import oracle.ide.log.StyledMessage;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.resource.EnvironOptionsArb;
import oracle.ide.resource.LogArb;

public class MessagePage
extends AbstractLogPage {
    public static final String MESSAGE_PAGE_ID = "MessagePage";
    private static final SimpleDateFormat logDateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
    private static final String NAME = LogArb.getString(2);
    private static URL _lastSaveToFileURL = null;
    private static final int WRAP_LOG_LINE_CMD_ID = Ide.findOrCreateCmdID("WRAP_LOG_LINE_CMD_ID");
    private static final char EOL = '\n';
    private final boolean _showStyledText;
    protected JTextComponent _textComponent;
    private int _lineCount;
    private int _deletedLines;
    protected JAutoScrollPane _scrollPane;
    private Timer _timer;
    private Controller _baseController;
    private PrintStream _diskLogFile;
    private String _diskLogFileName;
    private Object _lock;
    private StringBuffer _currentBuffer;
    private String _toAppend;
    private List _styles;
    private List _hrefs;
    private static Comparator _styleComparator = new 1();
    private Map _hrefsToHyperlink;

    public MessagePage() {
        this(new ViewId(MESSAGE_PAGE_ID, NAME));
    }

    protected MessagePage(ViewId viewId) {
        this(viewId, null);
    }

    protected MessagePage(ViewId viewId, Icon icon) {
        this(viewId, icon, true);
    }

    protected MessagePage(ViewId viewId, Icon icon, boolean bl) {
        this(viewId, icon, bl, false);
    }

    protected MessagePage(ViewId viewId, Icon icon, boolean bl, boolean bl2) {
        super(viewId, icon, bl);
        this.$init$();
        this._showStyledText = bl2;
        if (this._showStyledText && this._textComponent != null && !(this._textComponent instanceof WrappingTextPane)) {
            this.createTextComponent();
            this._scrollPane.setViewportView(this._textComponent);
        }
        this._timer = new Timer(250, new TimerListener(null));
        this._timer.setRepeats(false);
        this._baseController = new MessagePaneBaseController(null);
        ContextMenu contextMenu = LogManager.getLogManager().getContextMenu();
        IdeAction ideAction = IdeAction.get(WRAP_LOG_LINE_CMD_ID, null, LogArb.getString(26), null, LogArb.getInteger(27), LogArb.getInstance(), 28, null, true);
        ideAction.putValue("Check", Boolean.TRUE);
        contextMenu.addContextMenuListener(new 4());
    }

    private void saveToFile(Context context) {
        URL uRL;
        String string = LogArb.getString(13);
        URLChooser uRLChooser = DialogUtil.newURLChooser(context);
        uRLChooser.setHelpID("f1_idedsaveasrename_html");
        if (_lastSaveToFileURL != null) {
            uRLChooser.setSelectedURL(_lastSaveToFileURL);
        }
        if (uRLChooser.showSaveDialog((Component)((Object)Ide.getMainWindow()), string) == 0 && (uRL = uRLChooser.getSelectedURL()) != null) {
            _lastSaveToFileURL = uRL;
            WaitCursor waitCursor = Ide.getWaitCursor();
            waitCursor.show();
            try {
                String string2 = Ide.getEnvironOptions().getEncoding();
                OutputStream outputStream = URLFileSystem.openOutputStream(uRL);
                PrintStream printStream = string2 == null ? new PrintStream(outputStream) : new PrintStream(outputStream, false, string2);
                int n = this._textComponent.getSelectionStart();
                int n2 = this._textComponent.getSelectionEnd();
                if (n2 - n > 0) {
                    String string3 = this._textComponent.getText(n, n2 - n);
                    printStream.print(string3);
                } else {
                    printStream.print(this._textComponent.getText());
                }
                printStream.flush();
                printStream.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            waitCursor.hide();
        }
    }

    public ContextMenu getContextMenu() {
        ContextMenu contextMenu = LogManager.getLogManager().getContextMenu();
        return contextMenu;
    }

    private void openLogFile() {
        String string = this._diskLogFileName + "_" + logDateFormat.format(new Date()) + ".log";
        try {
            if (this._diskLogFile != null) {
                this._diskLogFile.close();
            }
            String string2 = Ide.getEnvironOptions().getEncoding();
            OutputStream outputStream = URLFileSystem.openOutputStream(URLFactory.newFileURL(string));
            this._diskLogFile = string2 == null ? new PrintStream(outputStream) : new PrintStream(outputStream, false, string2);
        }
        catch (IOException iOException) {
            this._diskLogFileName = null;
            MessageDialog.error((Component)((Object)Ide.getMainWindow()), EnvironOptionsArb.format(33, string), EnvironOptionsArb.getString(32), null);
        }
    }

    private void closeLogFile() {
        if (this._diskLogFile != null) {
            this._diskLogFile.close();
        }
        this._diskLogFile = null;
    }

    protected boolean checkLogOpen() {
        if (this._diskLogFileName == null) {
            return false;
        }
        if (this._diskLogFile == null) {
            this.openLogFile();
        }
        return this._diskLogFileName != null;
    }

    protected void setLogFileName(String string) {
        if (!string.equals(this._diskLogFileName)) {
            this.closeLogFile();
        }
        this._diskLogFileName = string;
    }

    public void clearAll() {
        if (this._scrollPane == null) {
            return;
        }
        this.closeLogFile();
        this.clearTextComponent();
    }

    public void addMouseListener(MouseListener mouseListener) {
        this.getGUI();
        this._textComponent.addMouseListener(mouseListener);
    }

    public void removeMouseListener(MouseListener mouseListener) {
        if (this._textComponent != null) {
            this._textComponent.removeMouseListener(mouseListener);
        }
    }

    public Component getGUI() {
        if (this._scrollPane == null) {
            this.createTextComponent();
            this._scrollPane = new JAutoScrollPane(this._textComponent);
            this._scrollPane.setBorder(BorderFactory.createEmptyBorder());
        }
        return this._scrollPane;
    }

    public HelpInfo getHelpInfo() {
        return new HelpInfo("f1_idelogwindowgen_html");
    }

    public Controller getController() {
        return this._baseController;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void logMsg(Object object) {
        Object object2 = this._lock;
        synchronized (object2) {
            if (object instanceof StyledMessage) {
                StyledMessage styledMessage = (StyledMessage)object;
                int n = this.getTextLength();
                styledMessage.setStartOffset(n);
                this.addStyle(styledMessage);
                object = styledMessage.getText();
                styledMessage.clearText();
            }
            this._currentBuffer.append(object);
        }
        if (!this._timer.isRunning()) {
            this._timer.start();
        }
    }

    private void createTextComponent() {
        if (!this._showStyledText) {
            JTextArea jTextArea = new JTextArea();
            jTextArea.setDocument(new PlainDocument());
            jTextArea.setEditable(false);
            jTextArea.setLineWrap(Ide.getEnvironOptions().isWrapLogLines());
            this._textComponent = jTextArea;
            KeyUtil.removeCtrlTabFromTraversalKeys(this._textComponent);
            InputMap inputMap = this._textComponent.getInputMap();
            inputMap.setParent(Ide.getIdeInputMap());
        } else {
            3 var3_3 = new 3();
            var3_3.setDocument(new DefaultStyledDocument());
            var3_3.setEditable(false);
            var3_3.setLineWrap(Ide.getEnvironOptions().isWrapLogLines());
            2 var4_4 = new 2(this, var3_3);
            var3_3.addMouseListener(var4_4);
            var3_3.addMouseMotionListener(var4_4);
            this._textComponent = var3_3;
        }
        this._textComponent.setToolTipText(this.getToolTip());
        Font font = new JTextArea().getFont();
        this._textComponent.setFont(new Font("DialogInput", font.getStyle(), font.getSize()));
    }

    protected void updateToolTipText() {
        this._textComponent.setToolTipText(this.getToolTip());
    }

    protected boolean getWrapLines() {
        if (this._textComponent instanceof JTextArea) {
            JTextArea jTextArea = (JTextArea)this._textComponent;
            return jTextArea.getLineWrap();
        }
        WrappingTextPane wrappingTextPane = (WrappingTextPane)this._textComponent;
        return wrappingTextPane.getLineWrap();
    }

    protected void setWrapLines(boolean bl) {
        if (this._textComponent instanceof JTextArea) {
            JTextArea jTextArea = (JTextArea)this._textComponent;
            jTextArea.setLineWrap(bl);
            Ide.getEnvironOptions().setWrapLogLines(bl);
        } else {
            WrappingTextPane wrappingTextPane = (WrappingTextPane)this._textComponent;
            wrappingTextPane.setLineWrap(bl);
            Ide.getEnvironOptions().setWrapLogLines(bl);
        }
    }

    protected final String getText() {
        try {
            Document document = this._textComponent.getDocument();
            int n = document.getLength();
            String string = document.getText(0, n);
            return string;
        }
        catch (BadLocationException badLocationException) {
            return this._textComponent.getText();
        }
    }

    protected void appendToTextComponent(String string, int n) {
        if (this._textComponent instanceof JTextArea) {
            JTextArea jTextArea = (JTextArea)this._textComponent;
            jTextArea.append(string);
            this._lineCount = jTextArea.getLineCount();
            if (this._lineCount > n) {
                try {
                    int n2 = this._lineCount - n;
                    int n3 = jTextArea.getLineStartOffset(n2);
                    this.deleteFromStartOfTextComponent(n2, n3);
                }
                catch (BadLocationException badLocationException) {}
            }
        } else {
            WrappingTextPane wrappingTextPane = (WrappingTextPane)this._textComponent;
            Document document = wrappingTextPane.getDocument();
            int n4 = document.getLength();
            try {
                document.insertString(n4, string, null);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            if (string.length() > 0) {
                if (n4 == 0) {
                    ++this._lineCount;
                }
                int n5 = string.indexOf(10);
                while (n5 != -1) {
                    ++this._lineCount;
                    n5 = string.indexOf(10, n5 + 1);
                }
            }
            int n6 = document.getLength();
            this.setRecentAttributes(n4, n6);
            if (this._lineCount > n) {
                int n7 = this._lineCount - n;
                String string2 = this.getText();
                int n8 = string2.length();
                int n9 = 0;
                int n10 = 0;
                while (n10 < n7) {
                    if ((n9 = string2.indexOf(10, n9 + 1)) == -1) {
                        n9 = n8;
                        break;
                    }
                    ++n10;
                }
                this.deleteFromStartOfTextComponent(n7, ++n9);
            }
        }
        if (!string.endsWith("\n")) {
            String string3 = this.getText();
            int n11 = string3.lastIndexOf(10) + 1;
            this._textComponent.setCaretPosition(n11);
        }
    }

    protected void deleteFromStartOfTextComponent(int n, int n2) {
        if (this._textComponent instanceof JTextArea) {
            JTextArea jTextArea = (JTextArea)this._textComponent;
            try {
                jTextArea.replaceRange(null, 0, n2);
                this._lineCount = jTextArea.getLineCount();
                this._deletedLines += n;
                if (this._deletedLines > 5000) {
                    this.replaceTextComponentDocument();
                }
            }
            catch (Exception exception) {}
        } else {
            WrappingTextPane wrappingTextPane = (WrappingTextPane)this._textComponent;
            try {
                Document document = wrappingTextPane.getDocument();
                document.remove(0, n2);
                this._lineCount -= n;
                this._deletedLines += n;
                if (this._deletedLines > 5000) {
                    this.replaceTextComponentDocument();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        JScrollBar jScrollBar = this._scrollPane.getVerticalScrollBar();
        jScrollBar.setValue(jScrollBar.getMaximum());
        String string = this.getText();
        int n3 = string.lastIndexOf(10) + 1;
        this._textComponent.setCaretPosition(n3);
        this.adjustAttributes(n2);
    }

    protected void replaceTextComponentDocument() {
        String string = this.getText();
        AbstractDocument abstractDocument = this._textComponent instanceof JTextArea ? new PlainDocument() : new DefaultStyledDocument();
        this._textComponent.setDocument(abstractDocument);
        this._textComponent.setText(string);
        this.replaceAttributes();
        this._deletedLines = 0;
    }

    protected void clearTextComponent() {
        this._textComponent.setText("");
        this._textComponent.setCaretPosition(0);
        this._lineCount = 0;
        this.clearAttributes();
    }

    public void addHref(Href href) {
        this.addStyle(href);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStyle(StyledMessage styledMessage) {
        Object object = this._lock;
        synchronized (object) {
            int n = styledMessage.getStartOffset();
            int n2 = styledMessage.getEndOffset();
            int n3 = Collections.binarySearch(this._styles, styledMessage, _styleComparator);
            if (n3 < 0) {
                n3 = -n3 - 1;
            }
            if (n3 > 0) {
                StyledMessage styledMessage2 = (StyledMessage)this._styles.get(n3 - 1);
                int n4 = styledMessage2.getStartOffset();
                int n5 = styledMessage2.getEndOffset();
                if (n5 > n) {
                    styledMessage2.setEndOffset(n);
                    if (n5 > n2) {
                        this._styles.add(n3, new StyledMessage(styledMessage2.getAttributes(), n2, n5));
                    }
                }
            }
            while (n3 < this._styles.size() - 1) {
                boolean bl = false;
                StyledMessage styledMessage3 = (StyledMessage)this._styles.get(n3);
                int n6 = styledMessage3.getStartOffset();
                int n7 = styledMessage3.getEndOffset();
                if (n2 > n6) {
                    if (n2 > n7) {
                        this._styles.remove(n3);
                        if (styledMessage3 instanceof Href) {
                            this.removeHref((Href)styledMessage3);
                        }
                        bl = true;
                    } else {
                        styledMessage3.setStartOffset(n2);
                    }
                }
                if (!bl) break;
            }
            this._styles.add(n3, styledMessage);
            if (styledMessage instanceof Href) {
                n3 = Collections.binarySearch(this._hrefs, styledMessage, _styleComparator);
                if (n3 < 0) {
                    n3 = -n3 - 1;
                }
                this._hrefs.add(n3, styledMessage);
            }
            this.setAttributes(styledMessage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setRecentAttributes(int n, int n2) {
        Object object = this._lock;
        synchronized (object) {
            int n3 = this._styles.size() - 1;
            while (n3 >= 0) {
                StyledMessage styledMessage = (StyledMessage)this._styles.get(n3);
                if (styledMessage.getStartOffset() < n2) {
                    if (styledMessage.getEndOffset() < n) break;
                    this.setAttributes(styledMessage);
                }
                --n3;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void adjustAttributes(int n) {
        Object object = this._lock;
        synchronized (object) {
            int n2 = this._styles.size() - 1;
            while (n2 >= 0) {
                StyledMessage styledMessage = (StyledMessage)this._styles.get(n2);
                if (styledMessage.getStartOffset() >= n) {
                    styledMessage.updateOffsets(-n);
                } else {
                    this._styles.remove(n2);
                    if (styledMessage instanceof Href) {
                        this.removeHref((Href)styledMessage);
                    }
                }
                --n2;
            }
        }
    }

    private void removeHref(Href href) {
        this._hrefs.remove(href);
        Hyperlink hyperlink = (Hyperlink)this._hrefsToHyperlink.remove(href);
        if (hyperlink != null) {
            hyperlink.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replaceAttributes() {
        Object object = this._lock;
        synchronized (object) {
            this.replaceAttributes(this._styles);
        }
    }

    private void replaceAttributes(List list) {
        int n = list.size() - 1;
        while (n >= 0) {
            StyledMessage styledMessage = (StyledMessage)list.get(n);
            this.setAttributes(styledMessage);
            --n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearAttributes() {
        Object object = this._lock;
        synchronized (object) {
            this._styles.clear();
            this._hrefs.clear();
            this._hrefsToHyperlink.clear();
        }
    }

    private void setAttributes(StyledMessage styledMessage) {
        Document document = this._textComponent.getDocument();
        if (document instanceof StyledDocument) {
            int n = document.getLength();
            int n2 = styledMessage.getStartOffset();
            if (n2 < n) {
                AttributeSet attributeSet;
                int n3 = styledMessage.getEndOffset();
                if (n3 > n) {
                    n3 = n;
                }
                if ((attributeSet = styledMessage.getAttributes()) != null) {
                    StyledDocument styledDocument = (StyledDocument)document;
                    styledDocument.setCharacterAttributes(n2, n3 - n2, attributeSet, true);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Href findHrefByOffset(int n) {
        Object object = this._lock;
        synchronized (object) {
            Href href;
            Href href2;
            int n2 = Collections.binarySearch(this._hrefs, new Integer(n), _styleComparator);
            if (n2 < 0) {
                n2 = -n2 - 1;
            }
            if (n2 > 0 && n >= (href2 = (Href)this._hrefs.get(n2 - 1)).getStartOffset() && n < href2.getEndOffset()) {
                Href href3 = href2;
                return href3;
            }
            if (n2 < this._hrefs.size() && n >= (href = (Href)this._hrefs.get(n2)).getStartOffset() && n < href.getEndOffset()) {
                Href href4 = href;
                return href4;
            }
        }
        return null;
    }

    void $init$() {
        this._lock = new Object();
        this._currentBuffer = new StringBuffer();
        this._toAppend = null;
        this._styles = new ArrayList();
        this._hrefs = new ArrayList();
        this._hrefsToHyperlink = new HashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getTextLength() {
        Object object = this._lock;
        synchronized (object) {
            int n = this._textComponent.getDocument().getLength();
            if (this._toAppend != null) {
                n += this._toAppend.length();
            }
            int n2 = n += this._currentBuffer.length();
            return n2;
        }
    }

    static int ra$WRAP_LOG_LINE_CMD_ID() {
        return WRAP_LOG_LINE_CMD_ID;
    }

    static void mav$saveToFile(MessagePage messagePage, Context context) {
        messagePage.saveToFile(context);
    }

    static Href mav$findHrefByOffset(MessagePage messagePage, int n) {
        return messagePage.findHrefByOffset(n);
    }

    static List ra$_hrefs(MessagePage messagePage) {
        return messagePage._hrefs;
    }

    static Map ra$_hrefsToHyperlink(MessagePage messagePage) {
        return messagePage._hrefsToHyperlink;
    }

    static PrintStream ra$_diskLogFile(MessagePage messagePage) {
        return messagePage._diskLogFile;
    }

    static String ra$_toAppend(MessagePage messagePage) {
        return messagePage._toAppend;
    }

    static Object ra$_lock(MessagePage messagePage) {
        return messagePage._lock;
    }

    static void wa$_toAppend(MessagePage messagePage, String string) {
        messagePage._toAppend = string;
    }

    static StringBuffer ra$_currentBuffer(MessagePage messagePage) {
        return messagePage._currentBuffer;
    }

    static void wa$_currentBuffer(MessagePage messagePage, StringBuffer stringBuffer) {
        messagePage._currentBuffer = stringBuffer;
    }

    public final class 4
    implements ContextMenuListener {
        public void menuWillShow(ContextMenu contextMenu) {
            Context context;
            if (contextMenu != null && (context = contextMenu.getContext()) != null && context.getView() == MessagePage.this) {
                JMenuItem jMenuItem = contextMenu.createMenuItem(IdeAction.find(18), MenuConstants.WEIGHT_EDIT_COPY);
                JMenuItem jMenuItem2 = contextMenu.createMenuItem(IdeAction.find(22), MenuConstants.WEIGHT_EDIT_SELECT_ALL);
                JMenuItem jMenuItem3 = contextMenu.createMenuItem(IdeAction.find(MessagePage.ra$WRAP_LOG_LINE_CMD_ID()), 1.0f);
                JMenuItem jMenuItem4 = contextMenu.createMenuItem(IdeAction.find(12), MenuConstants.WEIGHT_LOG_WINDOW_SAVE_AS);
                contextMenu.add((Component)jMenuItem, MenuConstants.SECTION_EDIT_CTXT_MENU);
                contextMenu.add((Component)jMenuItem2, MenuConstants.SECTION_EDIT_CTXT_MENU);
                contextMenu.add((Component)jMenuItem3, MenuConstants.SECTION_LOG_WINDOW_CTXT_MENU);
                contextMenu.add((Component)jMenuItem4, MenuConstants.SECTION_LOG_WINDOW_CTXT_MENU);
            }
        }

        public void menuWillHide(ContextMenu contextMenu) {
        }

        public boolean handleDefaultAction(Context context) {
            return false;
        }
    }

    private class MessagePaneBaseController
    implements Controller {
        public boolean handleEvent(IdeAction ideAction, Context context) {
            int n = ideAction.getCommandId();
            if (n == 18) {
                if (MessagePage.this._textComponent != null) {
                    MessagePage.this._textComponent.copy();
                }
            } else if (n == 22) {
                if (MessagePage.this._textComponent != null) {
                    MessagePage.this._textComponent.selectAll();
                    MessagePage.this._textComponent.copy();
                }
            } else if (n == 12) {
                MessagePage.mav$saveToFile(MessagePage.this, context);
            } else if (n == MessagePage.ra$WRAP_LOG_LINE_CMD_ID()) {
                MessagePage.this.setWrapLines(ideAction.getState());
            } else {
                return false;
            }
            return true;
        }

        public boolean update(IdeAction ideAction, Context context) {
            int n = ideAction.getCommandId();
            if (n == 17) {
                ideAction.setEnabled(false);
            } else if (n == 18) {
                boolean bl = false;
                if (MessagePage.this._textComponent != null) {
                    bl = MessagePage.this._textComponent.getSelectionEnd() - MessagePage.this._textComponent.getSelectionStart() > 0;
                }
                ideAction.setEnabled(bl);
            } else if (n == 22) {
                boolean bl = MessagePage.this._textComponent != null && MessagePage.this._textComponent.getDocument().getLength() > 0;
                ideAction.setEnabled(bl);
            } else if (n == 12) {
                boolean bl = MessagePage.this._textComponent != null && MessagePage.this._textComponent.getDocument().getLength() > 0;
                ideAction.setEnabled(bl);
            } else if (n == MessagePage.ra$WRAP_LOG_LINE_CMD_ID()) {
                ideAction.setEnabled(true);
                ideAction.setState(MessagePage.this.getWrapLines());
            } else {
                return false;
            }
            return true;
        }

        private MessagePaneBaseController() {
        }

        MessagePaneBaseController(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    public final class 3
    extends WrappingTextPane {
        private AccessibleContextWithHypertext a;

        void $init$() {
            this.a = null;
        }

        public AccessibleContext getAccessibleContext() {
            if (this.a == null) {
                this.a = new AccessibleContextWithHypertext();
            }
            return this.a;
        }

        public 3() {
            this.$init$();
        }

        public class AccessibleContextWithHypertext
        extends JEditorPane.AccessibleJEditorPane
        implements AccessibleHypertext {
            public AccessibleText getAccessibleText() {
                return this;
            }

            public int getLinkCount() {
                return MessagePage.ra$_hrefs(MessagePage.this).size();
            }

            public AccessibleHyperlink getLink(int n) {
                Href href = (Href)MessagePage.ra$_hrefs(MessagePage.this).get(n);
                if (href != null) {
                    AccessibleHyperlink accessibleHyperlink = (AccessibleHyperlink)MessagePage.ra$_hrefsToHyperlink(MessagePage.this).get(href);
                    if (accessibleHyperlink == null) {
                        accessibleHyperlink = new Hyperlink(href);
                        MessagePage.ra$_hrefsToHyperlink(MessagePage.this).put(href, accessibleHyperlink);
                    }
                    return accessibleHyperlink;
                }
                return null;
            }

            public int getLinkIndex(int n) {
                Href href = MessagePage.mav$findHrefByOffset(MessagePage.this, n);
                if (href != null) {
                    return MessagePage.ra$_hrefs(MessagePage.this).indexOf(href);
                }
                return -1;
            }

            AccessibleContextWithHypertext() {
                super(3.this);
            }
        }
    }

    public final class 2
    extends MouseInputAdapter {
        private final /* synthetic */ WrappingTextPane v$textPane;
        final /* synthetic */ MessagePage this$0;

        public void mouseMoved(MouseEvent mouseEvent) {
            Href href = null;
            try {
                int n = this.v$textPane.getUI().viewToModel(this.v$textPane, mouseEvent.getPoint());
                href = MessagePage.mav$findHrefByOffset(this.this$0, n);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (href != null) {
                this.v$textPane.setCursor(href.getCursor());
            } else {
                this.v$textPane.setCursor(null);
            }
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            try {
                int n;
                Href href;
                if ((mouseEvent.getModifiers() & 0x10) != 0 && mouseEvent.getClickCount() == 1 && (href = MessagePage.mav$findHrefByOffset(this.this$0, n = this.v$textPane.getUI().viewToModel(this.v$textPane, mouseEvent.getPoint()))) != null) {
                    href.go();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public 2(MessagePage messagePage, WrappingTextPane wrappingTextPane) {
            this.v$textPane = wrappingTextPane;
            this.this$0 = messagePage;
        }
    }

    private class Hyperlink
    extends AccessibleHyperlink {
        private Href _href;

        Hyperlink(Href href) {
            this._href = href;
        }

        void clear() {
            this._href = null;
        }

        public boolean isValid() {
            return this._href != null;
        }

        public int getAccessibleActionCount() {
            if (this._href != null) {
                return 1;
            }
            return 0;
        }

        public boolean doAccessibleAction(int n) {
            if (this._href != null && n == 0) {
                this._href.go();
                return true;
            }
            return false;
        }

        public String getAccessibleActionDescription(int n) {
            if (this._href != null && n == 0) {
                return this._href.getText();
            }
            return null;
        }

        public Object getAccessibleActionObject(int n) {
            if (this._href != null && n == 0) {
                return this._href.getURL();
            }
            return null;
        }

        public Object getAccessibleActionAnchor(int n) {
            if (this._href != null && n == 0) {
                return this._href.getText();
            }
            return null;
        }

        public int getStartIndex() {
            if (this._href != null) {
                return this._href.getStartOffset();
            }
            return 0;
        }

        public int getEndIndex() {
            if (this._href != null) {
                return this._href.getEndOffset();
            }
            return 0;
        }
    }

    public static final class 1
    implements Comparator {
        public int compare(Object object, Object object2) {
            return this.getSortValue(object) - this.getSortValue(object2);
        }

        private int getSortValue(Object object) {
            if (object instanceof StyledMessage) {
                return ((StyledMessage)object).getStartOffset();
            }
            if (object instanceof Integer) {
                return (Integer)object;
            }
            return 0;
        }
    }

    private class TimerListener
    implements Runnable,
    ActionListener {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = MessagePage.ra$_lock(MessagePage.this);
            synchronized (object) {
                if (MessagePage.ra$_currentBuffer(MessagePage.this).length() != 0) {
                    MessagePage.wa$_toAppend(MessagePage.this, MessagePage.ra$_currentBuffer(MessagePage.this).toString());
                    if (MessagePage.ra$_currentBuffer(MessagePage.this).capacity() > 1024) {
                        MessagePage.wa$_currentBuffer(MessagePage.this, new StringBuffer(1024));
                    } else {
                        MessagePage.ra$_currentBuffer(MessagePage.this).delete(0, Integer.MAX_VALUE);
                    }
                }
                if (MessagePage.ra$_toAppend(MessagePage.this) != null) {
                    SwingUtilities.invokeLater(this);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            IdeSettings ideSettings = Ide.getSettings();
            EnvironOptions environOptions = (EnvironOptions)ideSettings.getData("environment-options");
            if (MessagePage.this._scrollPane == null) {
                MessagePage.this.getGUI();
            }
            if (MessagePage.this.checkLogOpen()) {
                MessagePage.ra$_diskLogFile(MessagePage.this).print(MessagePage.ra$_toAppend(MessagePage.this));
            }
            Object object = MessagePage.ra$_lock(MessagePage.this);
            synchronized (object) {
                MessagePage.this.appendToTextComponent(MessagePage.ra$_toAppend(MessagePage.this), environOptions.getMaxLogLines());
                MessagePage.wa$_toAppend(MessagePage.this, null);
            }
        }

        private TimerListener() {
        }

        TimerListener(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

