/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.marshal.xml;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import oracle.ide.marshal.xml.Object2Dom;
import oracle.ide.marshal.xml.ObjectWrapper;
import oracle.ide.marshal.xml.ToDomConverter;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

class File2Dom
implements ToDomConverter {
    private static final Class _fileClass = File.class;

    public boolean toElement(ObjectWrapper objectWrapper, Element element, Class clazz, Object2Dom object2Dom) {
        URL uRL;
        if (clazz != _fileClass) {
            return false;
        }
        File file = (File)objectWrapper.getObject();
        File file2 = File2Dom.getCanonicalFile(file);
        URL uRL2 = URLFactory.newFileURL(file2);
        String string = URLFileSystem.toRelativeSpec(uRL2, uRL = object2Dom.getDocumentURL());
        if (string == null || string.length() == 0) {
            string = ".";
        }
        Text text = element.getOwnerDocument().createTextNode(string);
        element.appendChild(text);
        return true;
    }

    private static File getCanonicalFile(File file) {
        try {
            File file2 = file.getCanonicalFile();
            return file2;
        }
        catch (IOException iOException) {
            File file3 = file.getAbsoluteFile();
            System.err.println("\n*** Warning: I/O error occurred when trying to determine the canonical path for " + file3.getPath());
            System.err.println("*** Attempting to continue.  Stack trace is:");
            iOException.printStackTrace();
            File file4 = file3;
            return file4;
        }
    }

    public boolean toObject(ObjectWrapper objectWrapper, Element element, Class clazz, Object2Dom object2Dom) {
        if (clazz != _fileClass) {
            return false;
        }
        CharacterData characterData = null;
        NodeList nodeList = element.getChildNodes();
        int n = nodeList.getLength();
        int n2 = 0;
        while (n2 < n) {
            Node node = nodeList.item(n2);
            if (node != null && node.getNodeType() == 3) {
                characterData = (Text)node;
                break;
            }
            ++n2;
        }
        if (characterData == null) {
            objectWrapper.setObject(null);
            return true;
        }
        String string = characterData.getData();
        if (string.startsWith("/")) {
            File file = new File(string);
            objectWrapper.setObject(file);
            return true;
        }
        URL uRL = object2Dom.getDocumentURL();
        URL uRL2 = URLFileSystem.getParent(uRL);
        URL uRL3 = URLFactory.newURL(uRL2, string);
        if (uRL3 != null) {
            String string2 = uRL3.getPath();
            File file = new File(string2);
            objectWrapper.setObject(file);
        } else {
            objectWrapper.setObject(null);
        }
        return true;
    }

    File2Dom() {
    }
}

