/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.marshal.xml;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import oracle.ide.marshal.xml.HashMapProxy;
import oracle.ide.marshal.xml.Object2Dom;
import oracle.ide.marshal.xml.ObjectWrapper;
import oracle.ide.marshal.xml.ToDomConverter;
import oracle.ide.util.StringComparator;
import oracle.xml.parser.v2.XMLElement;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class Map2Dom
implements ToDomConverter {
    private static final boolean HASH_MAP_PROXY_ENABLED = Boolean.getBoolean("use.HashMapProxy");
    static final String KEY_TAG = "Key";
    static final String VALUE_TAG = "Value";
    private static final Class _stringClass = String.class;
    private static final Class _mapClass = Map.class;
    private static final Class _hashMapClass = HashMap.class;
    private static final Class _hashMapProxyClass = HashMapProxy.class;
    private final Comparator _stringComparator;

    void $init$() {
        this._stringComparator = new StringComparator();
    }

    public boolean toElement(ObjectWrapper objectWrapper, Element element, Class clazz, Object2Dom object2Dom) {
        if (!_mapClass.isAssignableFrom(clazz)) {
            return false;
        }
        Map map = (Map)objectWrapper.getObject();
        Object[] objectArray = map.keySet().toArray();
        Arrays.sort(objectArray, this._stringComparator);
        Iterator<Object> iterator = Arrays.asList(objectArray).iterator();
        boolean bl = HASH_MAP_PROXY_ENABLED && clazz == _hashMapProxyClass;
        String string = element.getNamespaceURI();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            Element element2 = object2Dom.toElement(object, KEY_TAG, _stringClass, string);
            Document document = element.getOwnerDocument();
            Element element3 = this.getValueElement(bl, object2Dom, document, map, object, string);
            Element element4 = document.createElementNS(string, "Item");
            element4.appendChild(element2);
            element4.appendChild(element3);
            element.appendChild(element4);
        }
        return true;
    }

    public boolean toObject(ObjectWrapper objectWrapper, Element element, Class clazz, Object2Dom object2Dom) {
        if (!_mapClass.isAssignableFrom(clazz)) {
            return false;
        }
        boolean bl = HASH_MAP_PROXY_ENABLED && clazz == _hashMapClass;
        try {
            NodeList nodeList = element.getChildNodes();
            int n = nodeList.getLength();
            Map map = bl ? new HashMapProxy(object2Dom) : (Map)clazz.newInstance();
            int n2 = 0;
            while (n2 < n) {
                Node node = nodeList.item(n2);
                if (node.getNodeType() == 1) {
                    Element element2 = (Element)node;
                    NodeList nodeList2 = element2.getChildNodes();
                    int n3 = nodeList2.getLength();
                    int n4 = 0;
                    Element element3 = null;
                    while (n4 < n3) {
                        Node node2 = nodeList2.item(n4);
                        if (node2.getNodeType() == 1) {
                            element3 = (Element)node2;
                            ++n4;
                            break;
                        }
                        ++n4;
                    }
                    Element element4 = null;
                    while (n4 < n3) {
                        Node node3 = nodeList2.item(n4);
                        if (node3.getNodeType() == 1) {
                            element4 = (Element)node3;
                            break;
                        }
                        ++n4;
                    }
                    Object object = Map2Dom.toObject(object2Dom, element3);
                    Object object2 = this.getValueObject(bl, object2Dom, element4);
                    map.put(object, object2);
                }
                ++n2;
            }
            objectWrapper.setObject(map);
            boolean bl2 = true;
            return bl2;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            objectWrapper.setObject(null);
            boolean bl3 = true;
            return bl3;
        }
    }

    static Object toObject(Object2Dom object2Dom, Element element) {
        return object2Dom.toObject(element, _stringClass);
    }

    private Object getValueObject(boolean bl, Object2Dom object2Dom, Element element) {
        if (element != null) {
            String string = object2Dom.getClassAttr(element);
            if (!bl || string == null || string.startsWith("java.lang")) {
                return Map2Dom.toObject(object2Dom, element);
            }
        }
        return element;
    }

    private Element getValueElement(boolean bl, Object2Dom object2Dom, Document document, Map map, Object object, String string) {
        Object object2;
        if (bl) {
            HashMapProxy hashMapProxy = (HashMapProxy)map;
            object2 = hashMapProxy.superGet(object);
        } else {
            object2 = map.get(object);
        }
        if (object2 instanceof DocumentFragment) {
            return (Element)((DocumentFragment)object2).getFirstChild();
        }
        if (object2 instanceof XMLElement) {
            return (Element)document.importNode((Node)((XMLElement)object2), true);
        }
        return object2Dom.toElement(object2, VALUE_TAG, _stringClass, string);
    }

    Map2Dom() {
        this.$init$();
    }
}

