/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.marshal.xml;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import oracle.ide.marshal.xml.Array2Dom;
import oracle.ide.marshal.xml.File2Dom;
import oracle.ide.marshal.xml.HashMapProxy;
import oracle.ide.marshal.xml.HashStructure2Dom;
import oracle.ide.marshal.xml.List2Dom;
import oracle.ide.marshal.xml.Map2Dom;
import oracle.ide.marshal.xml.Object2DomException;
import oracle.ide.marshal.xml.Object2DomLogger;
import oracle.ide.marshal.xml.Object2String2Dom;
import oracle.ide.marshal.xml.ObjectComparator;
import oracle.ide.marshal.xml.ObjectWrapper;
import oracle.ide.marshal.xml.Set2Dom;
import oracle.ide.marshal.xml.ToDomConverter;
import oracle.ide.marshal.xml.URL2Dom;
import oracle.ide.marshal.xml.XMLObjectStore;
import oracle.ide.net.URLFileSystem;
import oracle.ide.resource.MarshalArb;
import oracle.ide.util.ModelUtil;
import oracle.ide.xml.XMLUtil;
import oracle.javatools.marshal.ToStringManager;
import oracle.javatools.marshal.xml.PropertyInfo;
import oracle.javatools.marshal.xml.PropertyIterator;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.DTD;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.parser.v2.XMLParseException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXParseException;

public final class Object2Dom
extends XMLObjectStore {
    public static final int REPORT_NO_ERRORS = 0;
    public static final int REPORT_WELL_FORMED_ERRORS = 1;
    public static final int REPORT_VALIDATION_ERRORS = 2;
    public static final int REPORT_DATA_CONSTRAINT_ERRORS = 3;
    public static final String ID_ATTR = "id";
    public static final String IDREF_ATTR = "idref";
    public static final String XMLNS_ATTR = "xmlns";
    public static final String XMLNS_URI = "http://www.w3.org/2000/xmlns/";
    public static final String ITEM_TAG = "Item";
    private static final Class _toDomConverterClass = ToDomConverter.class;
    private static final Class _hashMapProxyClass = HashMapProxy.class;
    private static final ArrayList _exemptFromIdref = new ArrayList(7);
    private static final ArrayList _converters = new ArrayList(10);
    private static final HashMap _doctypes = new HashMap();
    private static final HashMap _xmlns = new HashMap();
    private final boolean _useIdNumbers;
    private final boolean _namedArrayElems;
    private final boolean _nullIfEmpty;
    private final boolean _includeNulls;
    private final boolean _includeClassAttrs;
    private Map _objectToElement;
    private Map _elementToId;
    private Map _idToObject;
    private URL _documentURL;
    private XMLDocument _xmlDocument;
    private String _encoding;
    private String _publicID;
    private String _systemID;
    private String _namespaceURI;
    private DTD _dtd;
    private boolean _dtdOverridden;
    private int _reportLevel;
    private Object2DomLogger _logger;

    static {
        Object2Dom.registerConverter(new URL2Dom());
        Object2Dom.registerConverter(new File2Dom());
        Object2Dom.registerConverter(new Object2String2Dom());
        Object2Dom.registerConverter(new Array2Dom());
        Object2Dom.registerConverter(new List2Dom());
        Object2Dom.registerConverter(new Map2Dom());
        Object2Dom.registerConverter(new Set2Dom());
        Object2Dom.registerConverter(new HashStructure2Dom());
        Object2Dom.exemptTypeFromIdref(String.class);
        Object2Dom.exemptTypeFromIdref(Class.class);
        Object2Dom.exemptTypeFromIdref(URL.class);
        Object2Dom.exemptTypeFromIdref(Boolean.class);
    }

    private Object2Dom(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        this.$init$();
        this._useIdNumbers = bl;
        this._namedArrayElems = bl2;
        this._nullIfEmpty = bl3;
        this._includeNulls = bl4;
        this._includeClassAttrs = bl5;
    }

    public static Object2Dom newInstance() {
        return new Object2Dom(true, false, false, true, true);
    }

    public static Object2Dom newInstanceForSchemaCompiledBeans() {
        return new Object2Dom(false, true, true, false, false);
    }

    public XMLDocument toDocument(Object object, String string, URL uRL) throws IOException {
        return this.toDocument(object, string, null, uRL);
    }

    public XMLDocument toDocument(Object object, String string, Class clazz, URL uRL) throws IOException {
        this.setDocumentURL(uRL);
        XMLDocument xMLDocument = this.toDocument(object, string, clazz);
        XMLUtil.writeXML(xMLDocument, uRL);
        return xMLDocument;
    }

    public XMLDocument toDocument(Object object, String string) {
        return this.toDocument(object, string, (Class)null);
    }

    public XMLDocument toDocument(Object object, String string, Class clazz) {
        if (string == null) {
            throw new NullPointerException("Root tag is null.");
        }
        this._objectToElement = new TreeMap(new ObjectComparator());
        this._elementToId = new HashMap();
        this._xmlDocument = new XMLDocument();
        this._xmlDocument.setVersion("1.0");
        this._xmlDocument.setEncoding(this.getEncoding());
        if (ModelUtil.hasLength((String)this._systemID)) {
            this._xmlDocument.setDoctype(string, this._systemID, this._publicID);
        }
        Element element = this.toElement(object, string, clazz, this._namespaceURI, false);
        this._xmlDocument.appendChild((Node)element);
        return this._xmlDocument;
    }

    public Object toObject(InputStream inputStream, Class clazz) throws IOException {
        return this.toObject(this.getDocument(inputStream, null), clazz);
    }

    public Object toObject(Reader reader, Class clazz) throws IOException {
        return this.toObject(this.getDocument(null, reader), clazz);
    }

    public Object toObject(URL uRL) throws IOException {
        return this.toObject(uRL, null);
    }

    public Object toObject(URL uRL, Class clazz) throws IOException {
        this.setDocumentURL(uRL);
        Object object = this.toObject(this.getDocument(uRL), clazz);
        return object;
    }

    public Object toObject(XMLDocument xMLDocument) {
        return this.toObject(xMLDocument, null);
    }

    public Object toObject(XMLDocument xMLDocument, Class clazz) {
        Object object = this.toObject(this.initAndGetRootElement((Document)xMLDocument), clazz, false);
        if (this._logger != null) {
            this._logger.logXMLDocument(xMLDocument);
        }
        return object;
    }

    public String getEncoding() {
        return this._encoding != null ? this._encoding : "UTF-8";
    }

    public void setEncoding(String string) {
        this._encoding = string;
    }

    public void setDoctypeID(String string, String string2) {
        this._publicID = string;
        this._systemID = string != null ? (string2 != null ? string2 : "") : string2;
    }

    public void setDTD(DTD dTD) {
        this._dtd = dTD;
        this._dtdOverridden = true;
    }

    public void setNamespaceURI(String string) {
        this._namespaceURI = string;
    }

    public void setLogger(int n, Object2DomLogger object2DomLogger) {
        if (n < 0 || n > 3) {
            throw new IllegalArgumentException("Invalid report level");
        }
        this._reportLevel = n;
        this._logger = object2DomLogger;
    }

    public static void registerConverter(ToDomConverter toDomConverter) {
        if (!_converters.contains(toDomConverter)) {
            _converters.add(toDomConverter);
        }
    }

    public static void registerDoctype(Class clazz, String string, String string2, String string3) {
        Doctype doctype = new Doctype(string, string2, string3);
        _doctypes.put(clazz, doctype);
    }

    public static void registerNamespaceElem(Class clazz, String string, String string2) {
        if (ModelUtil.hasLength((String)string)) {
            _xmlns.put(clazz, new NSElem(string, string2));
        }
    }

    public static void exemptTypeFromIdref(Class clazz) {
        _exemptFromIdref.add(clazz);
    }

    public boolean isNamedArrayElems() {
        return this._namedArrayElems;
    }

    public boolean isNullIfEmpty() {
        return this._nullIfEmpty;
    }

    public boolean isIncludeNulls() {
        return this._includeNulls;
    }

    public Element toElement(Object object, String string, Class clazz) {
        new UnsupportedOperationException("The method Object2Dom.toElement(Object, String, Class) has been deprecated.  Calls to this method will produce incorrect results.  Please update your code.").printStackTrace();
        return this.toElement(object, string, clazz, null);
    }

    public Element toElement(Object object, String string, Class clazz, String string2) {
        return this.toElement(object, string, clazz, string2, this._nullIfEmpty);
    }

    public Object toObject(Element element, Class clazz) {
        return this.toObject(element, clazz, true);
    }

    public static NodeList getChildrenByTagName(Element element, String string) {
        if (element instanceof XMLElement) {
            return ((XMLElement)element).getChildrenByTagName(string);
        }
        throw new UnsupportedOperationException("Not implemented without Oracle XML parser.");
    }

    public void marshalAttributes(Element element, Object object) {
        if (element == null || object == null) {
            return;
        }
        PropertyIterator propertyIterator = new PropertyIterator(object);
        while (propertyIterator.hasNext()) {
            Class clazz;
            Object object2;
            String string;
            PropertyInfo propertyInfo = propertyIterator.next();
            if (!propertyInfo.isAttribute() || (string = ToStringManager.toString((Object)(object2 = propertyInfo.getPropertyValue(object)), (Class)(clazz = propertyInfo.getPropertyClass()))) == null) continue;
            String string2 = propertyInfo.getXMLName();
            element.setAttribute(string2, string);
        }
    }

    public void unmarshalAttributes(Element element, Object object) {
        PropertyIterator propertyIterator = new PropertyIterator(object);
        while (propertyIterator.hasNext()) {
            PropertyInfo propertyInfo = propertyIterator.next();
            if (!propertyInfo.isAttribute()) continue;
            String string = propertyInfo.getXMLName();
            Attr attr = element.getAttributeNode(string);
            if (attr == null) {
                this.setPropertyValue(propertyInfo, object, null, element);
                continue;
            }
            String string2 = attr.getValue();
            Class clazz = propertyInfo.getPropertyClass();
            Object object2 = ToStringManager.fromString((String)string2, (Class)clazz);
            this.setPropertyValue(propertyInfo, object, object2, attr);
        }
    }

    public Object load(URL uRL) throws IOException {
        Object object = this.toObject(uRL);
        this.flush();
        return object;
    }

    public boolean open(URL uRL, Object object) throws IOException {
        try {
            this.setDocumentURL(uRL);
            Element element = this.initAndGetRootElement((Document)this.getDocument(uRL));
            try {
                String string = this.getClassAttr(element);
                if (!ModelUtil.hasLength((String)string)) {
                    boolean bl = false;
                    this.flush();
                    return bl;
                }
                element = this.applyTransforms(element, null, null);
                string = this.getClassAttr(element);
                if (!object.getClass().getName().equals(string)) {
                    boolean bl = false;
                    this.flush();
                    return bl;
                }
                this.initObject(element, object);
            }
            catch (Exception exception) {
                this.logOtherExceptionImpl(exception);
            }
            boolean bl = true;
            this.flush();
            return bl;
        }
        catch (Throwable throwable) {
            this.flush();
            throw throwable;
        }
    }

    public boolean save(URL uRL, Object object) throws IOException {
        String string;
        if (object == null) {
            return false;
        }
        Class<?> clazz = object.getClass();
        NSElem nSElem = (NSElem)_xmlns.get(clazz);
        if (nSElem != null) {
            string = nSElem.localElemName;
        } else {
            Doctype doctype = (Doctype)_doctypes.get(object.getClass());
            if (doctype == null) {
                throw this.newO2DException("Cannot save the specified object because no namespace or doctype is registered", null);
            }
            this.setDoctypeID(doctype.publicID, doctype.systemID);
            string = doctype.rootName;
        }
        this.toDocument(object, string, uRL);
        this.flush();
        return true;
    }

    public URL getDocumentURL() {
        return this._documentURL;
    }

    public void setDocumentURL(URL uRL) {
        this._documentURL = uRL;
    }

    void logOtherExceptionImpl(Throwable throwable) {
        if (this._logger != null) {
            this._logger.logOtherException(throwable);
        } else {
            throwable.printStackTrace();
        }
    }

    private void logMessageImpl(String string) {
        if (this._logger != null) {
            this._logger.logMessage(string + "\n");
        } else {
            System.err.println(string);
        }
    }

    private Element toElement(Object object, String string, Class clazz, String string2, boolean bl) {
        Element element = Object2Dom.newElementNS(object, string, clazz, (Document)this._xmlDocument, string2);
        if (object == null) {
            return element;
        }
        Class<?> clazz2 = object.getClass();
        if (!(!this._useIdNumbers || clazz != null && clazz.isPrimitive() || Object2Dom.isExemptFromIdref(clazz2))) {
            if (this._objectToElement.containsKey(object)) {
                Element element2 = (Element)this._objectToElement.get(object);
                if (this._elementToId.containsKey(element2)) {
                    Integer n = (Integer)this._elementToId.get(element2);
                    element.setAttribute(IDREF_ATTR, n.toString());
                } else {
                    Integer n = this.assignNewId(element2);
                    element.setAttribute(IDREF_ATTR, n.toString());
                }
                return element;
            }
            this.mapObjectToElement(object, element);
        }
        if (clazz2 != ToStringManager.wrapPrimitive((Class)clazz)) {
            this.setClassAttr(element, clazz2);
        }
        ObjectWrapper objectWrapper = new ObjectWrapper(object);
        if (object instanceof ToDomConverter && ((ToDomConverter)object).toElement(objectWrapper, element, clazz2, this)) {
            return this.assignClassIfEmpty(element, clazz2, this._nullIfEmpty);
        }
        for (ToDomConverter toDomConverter : _converters) {
            if (!toDomConverter.toElement(objectWrapper, element, clazz2, this)) continue;
            return this.assignClassIfEmpty(element, clazz2, this._nullIfEmpty);
        }
        PropertyIterator propertyIterator = new PropertyIterator(object);
        while (propertyIterator.hasNext()) {
            Element element3;
            PropertyInfo propertyInfo = propertyIterator.next();
            String string3 = propertyInfo.getXMLName();
            Object object2 = propertyInfo.getPropertyValue(object);
            Class clazz3 = propertyInfo.getPropertyClass();
            if (propertyInfo.isAttribute()) {
                String string4 = ToStringManager.toString((Object)object2, (Class)clazz3);
                if (string4 == null) continue;
                element.setAttribute(string3, string4);
                continue;
            }
            if (object2 == null && propertyInfo.isOmittedWhenNull() || object2 == null && !this._includeNulls || (element3 = this.toElement(object2, string3, clazz3, element.getNamespaceURI())) == null) continue;
            if (this._namedArrayElems && object2.getClass().isArray()) {
                this.addArrayElems(element3, element);
                continue;
            }
            element.appendChild(element3);
        }
        return this.assignClassIfEmpty(element, clazz2, bl);
    }

    private static boolean isExemptFromIdref(Class clazz) {
        int n = _exemptFromIdref.size();
        int n2 = 0;
        while (n2 < n) {
            if (clazz == _exemptFromIdref.get(n2)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private void addArrayElems(Element element, Element element2) {
        if (this._namedArrayElems) {
            NodeList nodeList = element.getChildNodes();
            int n = nodeList.getLength();
            int n2 = 0;
            while (n2 < n) {
                Node node = nodeList.item(0);
                element2.appendChild(node);
                ++n2;
            }
        } else {
            element2.appendChild(element);
        }
    }

    private Object toObject(Element element, Class clazz, boolean bl) {
        String string;
        if (this._useIdNumbers && ModelUtil.hasLength((String)(string = element.getAttribute(IDREF_ATTR)))) {
            Integer n = Integer.valueOf(string);
            Object v = this._idToObject.get(n);
            if (v == null) {
                try {
                    XMLDocument xMLDocument = (XMLDocument)element.getOwnerDocument();
                    Element element2 = (Element)xMLDocument.selectSingleNode("//*[@id='" + string + "']");
                    Object object = this.toObject(element2, clazz, bl);
                    this._idToObject.put(n, object);
                    Object object2 = object;
                    return object2;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            return v;
        }
        if (this._includeClassAttrs || clazz == null) {
            // empty if block
        }
        if (bl) {
            String string2 = this.getClassAttr(element);
            boolean bl2 = string2 != null;
            NamedNodeMap namedNodeMap = element.getAttributes();
            if (!(element.hasChildNodes() || bl2 || namedNodeMap != null && namedNodeMap.getLength() != 0)) {
                return null;
            }
        }
        try {
            ObjectWrapper objectWrapper;
            ToDomConverter toDomConverter;
            element = this.applyTransforms(element, clazz, null);
            String string3 = this.getClassAttr(element);
            Class clazz2 = Object2Dom.getClassObject(string3, clazz);
            if (_toDomConverterClass.isAssignableFrom(clazz2) && (toDomConverter = (ToDomConverter)clazz2.newInstance()).toObject(objectWrapper = new ObjectWrapper(toDomConverter), element, clazz2, this)) {
                Object object = this.mapIdToObject(this.getId(element), objectWrapper.getObject());
                return object;
            }
            ObjectWrapper objectWrapper2 = new ObjectWrapper();
            for (ToDomConverter toDomConverter2 : _converters) {
                if (!toDomConverter2.toObject(objectWrapper2, element, clazz2, this)) continue;
                Object object = this.mapIdToObject(this.getId(element), objectWrapper2.getObject());
                return object;
            }
            Object t = clazz2.newInstance();
            Object object = this.initObject(element, t);
            return object;
        }
        catch (ClassNotFoundException classNotFoundException) {
            String string4 = classNotFoundException.getLocalizedMessage();
            this.logMessageImpl(MarshalArb.format(0, string4));
            this.logMessageImpl(MarshalArb.getString(1));
        }
        catch (Exception exception) {
            this.logOtherExceptionImpl(exception);
        }
        return null;
    }

    private void mapObjectToElement(Object object, Element element) {
        this._objectToElement.put(object, element);
    }

    private Object mapIdToObject(Integer n, Object object) {
        if (this._useIdNumbers && n != null) {
            this._idToObject.put(n, object);
        }
        return object;
    }

    private Integer getId(Element element) {
        String string;
        if (this._useIdNumbers && ModelUtil.hasLength((String)(string = element.getAttribute(ID_ATTR)))) {
            return Integer.valueOf(string);
        }
        return null;
    }

    private Integer assignNewId(Element element) {
        Integer n = new Integer(this._elementToId.size());
        element.setAttribute(ID_ATTR, n.toString());
        this._elementToId.put(element, n);
        return n;
    }

    String getClassAttr(Element element) {
        return this._includeClassAttrs ? ModelUtil.nullifyIfEmpty((String)element.getAttribute("class")) : null;
    }

    void setClassAttr(Element element, Class clazz) {
        if (this._includeClassAttrs) {
            element.setAttribute("class", clazz != _hashMapProxyClass ? clazz.getName() : "java.util.HashMap");
        }
    }

    private static Class getClassObject(String string, Class clazz) throws ClassNotFoundException {
        return string != null ? Class.forName(string) : clazz;
    }

    private static Element newElementNS(Object object, String string, Class clazz, Node node) {
        return Object2Dom.newElementNS(object, string, clazz, node.getOwnerDocument(), node.getNamespaceURI());
    }

    private static Element newElementNS(Object object, String string, Class clazz, Document document, String string2) {
        Class<?> clazz2 = object != null ? object.getClass() : clazz;
        NSElem nSElem = (NSElem)_xmlns.get(clazz2);
        if (nSElem != null) {
            String string3 = nSElem.localElemName;
            Element element = document.createElementNS(nSElem.namespaceURI, string3);
            element.setAttribute("nselem", string3);
            return element;
        }
        return document.createElementNS(string2, string);
    }

    private Element assignClassIfEmpty(Element element, Class clazz, boolean bl) {
        NamedNodeMap namedNodeMap;
        if (!(element.hasChildNodes() || (namedNodeMap = element.getAttributes()) != null && namedNodeMap.getLength() != 0)) {
            if (bl) {
                return null;
            }
            this.setClassAttr(element, clazz);
        }
        return element;
    }

    private XMLDocument getDocument(URL uRL) throws IOException {
        if (uRL == null) {
            return null;
        }
        return this.getDocument(URLFileSystem.openInputStream(uRL), null);
    }

    private XMLDocument getDocument(InputStream inputStream, Reader reader) throws IOException {
        DOMParser dOMParser = new DOMParser();
        dOMParser.setPreserveWhitespace(false);
        if (this._reportLevel > 0) {
            dOMParser.setDebugMode(true);
        }
        if (this._dtd != null) {
            dOMParser.setDoctype(this._dtd);
        }
        if (this._dtdOverridden && this._reportLevel >= 2) {
            dOMParser.setValidationMode(2);
        }
        BufferedInputStream bufferedInputStream = null;
        BufferedReader bufferedReader = null;
        try {
            try {
                if (inputStream != null) {
                    bufferedInputStream = new BufferedInputStream(inputStream);
                    dOMParser.parse((InputStream)bufferedInputStream);
                } else {
                    bufferedReader = new BufferedReader(reader);
                    dOMParser.parse((Reader)bufferedReader);
                }
                XMLDocument xMLDocument = dOMParser.getDocument();
                if (bufferedInputStream != null) {
                    try {
                        bufferedInputStream.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                if (bufferedReader != null) {
                    try {
                        bufferedReader.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                return xMLDocument;
            }
            catch (XMLParseException xMLParseException) {
                if (this.isLoggingParseErrors()) {
                    this._logger.logXMLParseException(xMLParseException);
                }
                throw this.newO2DException("Error parsing XML", (Exception)((Object)xMLParseException));
            }
            catch (SAXParseException sAXParseException) {
                if (this.isLoggingParseErrors()) {
                    this._logger.logSAXParseException(sAXParseException);
                }
                throw this.newO2DException("Error parsing XML", sAXParseException);
            }
            catch (Exception exception) {
                if (this.isLoggingParseErrors()) {
                    this._logger.logOtherException(exception);
                }
                exception.printStackTrace();
                throw this.newO2DException("Error parsing XML", exception);
            }
        }
        catch (Throwable throwable) {
            if (bufferedInputStream != null) {
                try {
                    bufferedInputStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            throw throwable;
        }
    }

    private Object2DomException newO2DException(String string, Exception exception) {
        try {
            URL uRL = this.getDocumentURL();
            if (uRL != null) {
                string = string + " -- " + URLFileSystem.getPlatformPathName(uRL);
            }
        }
        catch (Exception exception2) {
            exception2.printStackTrace();
        }
        return new Object2DomException(string, exception);
    }

    private boolean isLoggingParseErrors() {
        return this._logger != null && this._reportLevel > 0;
    }

    private void flush() {
        if (this._objectToElement != null) {
            this._objectToElement.clear();
        }
        if (this._elementToId != null) {
            this._elementToId.clear();
        }
        if (this._idToObject != null) {
            this._idToObject.clear();
        }
        this.setDocumentURL(null);
    }

    private Element initAndGetRootElement(Document document) {
        this._idToObject = new HashMap(257);
        this._xmlDocument = null;
        return document.getDocumentElement();
    }

    private Object initObject(Element element, Object object) {
        this.mapIdToObject(this.getId(element), object);
        try {
            PropertyIterator propertyIterator = new PropertyIterator(object);
            while (propertyIterator.hasNext()) {
                PropertyInfo propertyInfo = propertyIterator.next();
                String string = propertyInfo.getXMLName();
                if (propertyInfo.isAttribute()) {
                    Attr attr = element.getAttributeNode(string);
                    if (attr == null) {
                        this.setPropertyValue(propertyInfo, object, null, element);
                        continue;
                    }
                    String string2 = attr.getValue();
                    Class clazz = propertyInfo.getPropertyClass();
                    Object object2 = ToStringManager.fromString((String)string2, (Class)clazz);
                    this.setPropertyValue(propertyInfo, object, object2, attr);
                    continue;
                }
                NodeList nodeList = Object2Dom.getChildrenByTagName(element, string);
                int n = nodeList.getLength();
                if (n < 1) continue;
                if (!this._namedArrayElems && n > 1) {
                    IllegalStateException illegalStateException = new IllegalStateException("Named property '" + string + "' is not unique.");
                    this.logOtherExceptionImpl(illegalStateException);
                    continue;
                }
                Element element2 = (Element)nodeList.item(0);
                Class clazz = propertyInfo.getPropertyClass();
                Object object3 = this.toObject(element2, clazz);
                this.setPropertyValue(propertyInfo, object, object3, element2);
            }
            Object object4 = object;
            return object4;
        }
        catch (Exception exception) {
            this.logOtherExceptionImpl(exception);
            return null;
        }
    }

    private void setPropertyValue(PropertyInfo propertyInfo, Object object, Object object2, Node node) {
        Throwable throwable = null;
        try {
            propertyInfo.setPropertyValue(object, object2);
            return;
        }
        catch (InvocationTargetException invocationTargetException) {
            throwable = invocationTargetException.getTargetException();
        }
        catch (Exception exception) {
            throwable = exception;
        }
        if (this.isLoggingDataConstraintsErrors()) {
            int n = -1;
            int n2 = -1;
            if (node instanceof XMLNode) {
                XMLNode xMLNode = (XMLNode)node;
                n = xMLNode.getLineNumber();
                n2 = xMLNode.getColumnNumber();
            }
            this._logger.logUnmarshalException(n, n2, throwable);
        }
    }

    private boolean isLoggingDataConstraintsErrors() {
        return this._logger != null && this._reportLevel == 3;
    }

    void $init$() {
        this._dtd = new DTD();
        this._dtdOverridden = false;
    }

    private static class NSElem {
        final String namespaceURI;
        final String localElemName;

        NSElem(String string, String string2) {
            this.namespaceURI = string;
            this.localElemName = string2;
        }
    }

    private static class Doctype {
        final String rootName;
        final String publicID;
        final String systemID;

        Doctype(String string, String string2, String string3) {
            this.rootName = string;
            this.publicID = string2;
            this.systemID = string3;
        }
    }
}

