/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.marshal.xml;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.Iterator;
import oracle.ide.marshal.xml.URL2Dom;
import oracle.ide.marshal.xml.XMLObjectStore;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.StringComparator;
import oracle.ide.xml.XMLUtil;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.ListStructure;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.XMLDocument;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

abstract class StructureIO
extends XMLObjectStore {
    private final String _rootQname;
    private final String _nsURI;
    private final String _propagatedXmlns;
    private final StringComparator _stringComparator;
    private XMLDocument _doc;
    private URL _documentURL;

    void $init$() {
        this._stringComparator = new StringComparator();
    }

    StructureIO(String string, String string2) {
        this.$init$();
        this._nsURI = string;
        this._rootQname = string2;
        this._propagatedXmlns = string2 != null && string2.indexOf(58) < 0 ? string : null;
    }

    void setDocumentURL(URL uRL) {
        this._documentURL = uRL;
    }

    void loadImpl(URL uRL, HashStructure hashStructure, ListStructure listStructure) throws IOException {
        this.setDocumentURL(uRL);
        this._doc = this.getDocument(uRL);
        Element element = this._doc.getDocumentElement();
        Class clazz = hashStructure != null ? HashStructure.class : ListStructure.class;
        Element element2 = element;
        try {
            element2 = this.applyTransforms(element, clazz, null);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (hashStructure != null) {
            this.elem2HashStructure(element2, hashStructure);
        } else {
            this.elem2ListStructure(element2, listStructure);
        }
    }

    void elem2HashStructure(Element element, HashStructure hashStructure) {
        NodeList nodeList = element.getChildNodes();
        int n = nodeList.getLength();
        int n2 = 0;
        while (n2 < n) {
            Element element2;
            Attr attr;
            Node node = nodeList.item(n2);
            if (node.getNodeType() == 1 && (attr = (element2 = (Element)node).getAttributeNode("n")) != null) {
                String string = attr.getValue();
                String string2 = element2.getLocalName();
                if (string2 == "value") {
                    hashStructure.putString(string, this.elem2string(element2));
                } else if (string2 == "hash") {
                    HashStructure hashStructure2 = hashStructure.getHashStructure(string);
                    if (hashStructure2 == null) {
                        hashStructure2 = HashStructure.newInstance();
                        hashStructure.putHashStructure(string, hashStructure2);
                    }
                    this.elem2HashStructure(element2, hashStructure2);
                } else if (string2 == "url") {
                    hashStructure.putURL(string, this.elem2url(element2));
                } else if (string2 == "list") {
                    ListStructure listStructure = hashStructure.getListStructure(string);
                    if (listStructure != null) {
                        listStructure.clear();
                    } else {
                        listStructure = ListStructure.newInstance();
                        hashStructure.putListStructure(string, listStructure);
                    }
                    this.elem2ListStructure(element2, listStructure);
                }
            }
            ++n2;
        }
    }

    private String elem2string(Element element) {
        Attr attr = element.getAttributeNode("v");
        return attr != null ? attr.getValue() : null;
    }

    private URL elem2url(Element element) {
        return URL2Dom.toURL(element, this._documentURL);
    }

    private void elem2ListStructure(Element element, ListStructure listStructure) {
        NodeList nodeList = element.getChildNodes();
        int n = nodeList.getLength();
        int n2 = 0;
        while (n2 < n) {
            Node node = nodeList.item(n2);
            if (node.getNodeType() == 1) {
                Element element2 = (Element)node;
                String string = element2.getLocalName();
                if (string == "string") {
                    listStructure.add((Object)element2.getAttribute("v"));
                } else if (string == "boolean") {
                    listStructure.add((Object)Boolean.valueOf(element2.getAttribute("v")));
                } else if (string == "int") {
                    listStructure.add((Object)Integer.valueOf(element2.getAttribute("v")));
                } else if (string == "long") {
                    listStructure.add((Object)Long.valueOf(element2.getAttribute("v")));
                } else if (string == "float") {
                    listStructure.add((Object)Float.valueOf(element2.getAttribute("v")));
                } else if (string == "double") {
                    listStructure.add((Object)Double.valueOf(element2.getAttribute("v")));
                } else if (string == "null") {
                    listStructure.add(null);
                } else if (string == "hash") {
                    HashStructure hashStructure = HashStructure.newInstance();
                    this.elem2HashStructure(element2, hashStructure);
                    listStructure.add((Object)hashStructure);
                } else if (string == "url") {
                    listStructure.add((Object)this.elem2url(element2));
                } else if (string == "list") {
                    ListStructure listStructure2 = ListStructure.newInstance();
                    this.elem2ListStructure(element2, listStructure2);
                    listStructure.add((Object)listStructure2);
                }
            }
            ++n2;
        }
    }

    private XMLDocument getDocument(URL uRL) throws IOException {
        DOMParser dOMParser = new DOMParser();
        dOMParser.setAttribute("oracle.xml.parser.XMLParser.Standalone", (Object)Boolean.TRUE);
        BufferedInputStream bufferedInputStream = null;
        try {
            try {
                InputStream inputStream = URLFileSystem.openInputStream(uRL);
                bufferedInputStream = new BufferedInputStream(inputStream);
                dOMParser.parse((InputStream)bufferedInputStream);
                XMLDocument xMLDocument = dOMParser.getDocument();
                if (bufferedInputStream != null) {
                    try {
                        bufferedInputStream.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                return xMLDocument;
            }
            catch (IOException iOException) {
                throw iOException;
            }
            catch (Exception exception) {
                IOException iOException = new IOException();
                iOException.initCause(exception);
                throw iOException;
            }
        }
        catch (Throwable throwable) {
            if (bufferedInputStream != null) {
                try {
                    bufferedInputStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            throw throwable;
        }
    }

    void saveImpl(URL uRL, HashStructure hashStructure, ListStructure listStructure) throws IOException {
        this._doc = new XMLDocument();
        this._doc.setVersion("1.0");
        this._doc.setEncoding("UTF-8");
        Element element = this._doc.createElementNS(this._nsURI, this._rootQname);
        this._doc.appendChild((Node)element);
        this.setDocumentURL(uRL);
        if (hashStructure != null) {
            this.hashStructure2elem(hashStructure, element);
        } else {
            this.listStructure2elem(listStructure, element);
        }
        XMLUtil.writeXML(this._doc, uRL);
    }

    void hashStructure2elem(HashStructure hashStructure, Element element) {
        Object[] objectArray = hashStructure.persistentKeySet().toArray();
        Arrays.sort(objectArray, this._stringComparator);
        Iterator<Object> iterator = Arrays.asList(objectArray).iterator();
        while (iterator.hasNext()) {
            String string = iterator.next().toString();
            Object object = hashStructure.getObject(string);
            if (object == null) {
                this.createChildElem(element, "value", string);
                continue;
            }
            Class<?> clazz = object.getClass();
            if (clazz == String.class) {
                this.string2elem(object.toString(), this.createChildElem(element, "value", string));
                continue;
            }
            if (object instanceof HashStructure) {
                this.hashStructure2elem((HashStructure)object, this.createChildElem(element, "hash", string));
                continue;
            }
            if (clazz == URL.class) {
                this.url2elem((URL)object, this.createChildElem(element, "url", string));
                continue;
            }
            if (clazz != ListStructure.class) continue;
            this.listStructure2elem((ListStructure)object, this.createChildElem(element, "list", string));
        }
    }

    private Element createChildElem(Element element, String string, String string2) {
        Element element2 = this.createChildElem(element, string);
        element2.setAttribute("n", string2);
        return element2;
    }

    private void string2elem(String string, Element element) {
        element.setAttribute("v", string);
    }

    private void url2elem(URL uRL, Element element) {
        URL2Dom.toElement(uRL, this._documentURL, element);
    }

    private void listStructure2elem(ListStructure listStructure, Element element) {
        for (Object e : listStructure) {
            if (e == null) {
                this.createChildElem(element, "null");
                continue;
            }
            Class<?> clazz = e.getClass();
            String string = StructureIO.getValueElemName(clazz);
            if (string != null) {
                Element element2 = this.createChildElem(element, string);
                element2.setAttribute("v", e.toString());
                continue;
            }
            if (e instanceof HashStructure) {
                this.hashStructure2elem((HashStructure)e, this.createChildElem(element, "hash"));
                continue;
            }
            if (clazz == URL.class) {
                this.url2elem((URL)e, this.createChildElem(element, "url"));
                continue;
            }
            if (clazz != ListStructure.class) continue;
            this.listStructure2elem((ListStructure)e, this.createChildElem(element, "list"));
        }
    }

    private static String getValueElemName(Class clazz) {
        if (clazz == String.class) {
            return "string";
        }
        if (clazz == Boolean.class) {
            return "boolean";
        }
        if (clazz == Integer.class) {
            return "int";
        }
        if (clazz == Long.class) {
            return "long";
        }
        if (clazz == Float.class) {
            return "float";
        }
        if (clazz == Double.class) {
            return "double";
        }
        return null;
    }

    private Element createChildElem(Element element, String string) {
        Element element2 = element.getOwnerDocument().createElementNS(this._propagatedXmlns, string);
        element.appendChild(element2);
        return element2;
    }
}

