/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.marshal.xml;

import java.net.MalformedURLException;
import java.net.URL;
import oracle.ide.marshal.xml.Object2Dom;
import oracle.ide.marshal.xml.ObjectWrapper;
import oracle.ide.marshal.xml.ToDomConverter;
import oracle.ide.net.JarUtil;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import org.w3c.dom.Attr;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

class URL2Dom
implements ToDomConverter {
    private static final Class _urlClass = URL.class;
    private static final String JAR_ENTRY_TAG = "jar-entry";
    private static final String ATTR_PROTOCOL = "protocol";
    private static final String ATTR_USERINFO = "userinfo";
    private static final String ATTR_HOST = "host";
    private static final String ATTR_PORT = "port";
    private static final String ATTR_PATH = "path";
    private static final String ATTR_QUERY = "query";
    private static final String ATTR_REF = "ref";

    public boolean toElement(ObjectWrapper objectWrapper, Element element, Class clazz, Object2Dom object2Dom) {
        if (_urlClass != clazz) {
            return false;
        }
        URL uRL = (URL)objectWrapper.getObject();
        if (uRL == null) {
            return true;
        }
        URL uRL2 = object2Dom.getDocumentURL();
        return URL2Dom.toElement(uRL, uRL2, element);
    }

    static boolean toElement(URL uRL, URL uRL2, Element element) {
        String string;
        String string2;
        if (uRL2 == null) {
            URL2Dom.marshalAbsoluteURL(element, uRL);
            return true;
        }
        if (uRL.getProtocol().equals("jar")) {
            string2 = JarUtil.getJarEntry(uRL);
            URL uRL3 = JarUtil.getJarFileURL(uRL);
            string = URLFileSystem.toRelativeSpec(uRL3, uRL2);
        } else {
            string2 = null;
            string = URLFileSystem.toRelativeSpec(uRL, uRL2);
        }
        if (string == null || string.length() == 0) {
            string = ".";
        }
        int n = string.indexOf(":");
        int n2 = string.indexOf("/");
        if (n >= 0 && n < n2 || n2 == 0) {
            URL2Dom.marshalAbsoluteURL(element, uRL);
        } else {
            String string3;
            element.setAttribute(ATTR_PATH, string);
            String string4 = uRL.getQuery();
            if (string4 != null) {
                element.setAttribute(ATTR_QUERY, string4);
            }
            if ((string3 = uRL.getRef()) != null) {
                element.setAttribute(ATTR_REF, string3);
            }
            if (string2 != null) {
                element.setAttribute(JAR_ENTRY_TAG, string2);
            }
        }
        return true;
    }

    public boolean toObject(ObjectWrapper objectWrapper, Element element, Class clazz, Object2Dom object2Dom) {
        if (_urlClass != clazz) {
            return false;
        }
        URL uRL = object2Dom.getDocumentURL();
        URL uRL2 = URL2Dom.toURL(element, uRL);
        objectWrapper.setObject(uRL2);
        return true;
    }

    static URL toURL(Element element, URL uRL) {
        URL uRL2;
        CharacterData characterData = null;
        NodeList nodeList = element.getChildNodes();
        int n = nodeList.getLength();
        int n2 = 0;
        while (n2 < n) {
            Node node = nodeList.item(n2);
            if (node != null && node.getNodeType() == 3) {
                characterData = (Text)node;
                break;
            }
            ++n2;
        }
        if (characterData != null) {
            String string;
            String string2 = characterData.getData();
            Attr attr = element.getAttributeNode(JAR_ENTRY_TAG);
            String string3 = string = attr != null && attr.getValue() != null ? attr.getValue() : null;
            if (uRL == null) {
                throw new IllegalStateException("null document URL when unmarshalling an old format for URL persistence");
            }
            return URL2Dom._getObjectURL(string2, string, uRL);
        }
        NamedNodeMap namedNodeMap = element.getAttributes();
        Node node = namedNodeMap.getNamedItem(ATTR_PROTOCOL);
        if (uRL == null) {
            if (node == null) {
                throw new IllegalStateException("no protocol specified when unmarshalling an URL and the base document URL is null");
            }
            return URL2Dom.unmarshalAbsoluteURL(node, namedNodeMap);
        }
        if (node != null) {
            return URL2Dom.unmarshalAbsoluteURL(node, namedNodeMap);
        }
        String string = URL2Dom.getNodeValue(namedNodeMap.getNamedItem(ATTR_PATH));
        if (string == null) {
            return null;
        }
        String string4 = URL2Dom.getNodeValue(namedNodeMap.getNamedItem(ATTR_QUERY));
        String string5 = URL2Dom.getNodeValue(namedNodeMap.getNamedItem(ATTR_REF));
        if (string.startsWith("/")) {
            String string6 = uRL.getProtocol();
            if (!string6.equals("jar")) {
                String string7 = uRL.getUserInfo();
                String string8 = uRL.getHost();
                int n3 = uRL.getPort();
                uRL2 = URLFactory.newURL(string6, string7, string8, n3, string, string4, string5);
            } else {
                uRL2 = URLFactory.newFileURL(string);
            }
        } else {
            URL uRL3 = URLFileSystem.getParent(uRL);
            URL uRL4 = URLFactory.newURL(uRL3, string);
            String string9 = uRL4.getProtocol();
            String string10 = uRL4.getUserInfo();
            String string11 = uRL4.getHost();
            int n4 = uRL4.getPort();
            String string12 = uRL4.getPath();
            uRL2 = URLFactory.newURL(string9, string10, string11, n4, string12, string4, string5);
        }
        String string13 = URL2Dom.getNodeValue(namedNodeMap.getNamedItem(JAR_ENTRY_TAG));
        if (string13 != null) {
            return URLFactory.newJarURL(uRL2, string13);
        }
        return uRL2;
    }

    private static int getIntValue(Node node) {
        if (node == null) {
            return -1;
        }
        String string = node.getNodeValue();
        return new Integer(string);
    }

    private static String getNodeValue(Node node) {
        return node != null ? node.getNodeValue() : null;
    }

    private static final void marshalAbsoluteURL(Element element, URL uRL) {
        String string;
        String string2;
        String string3;
        int n;
        String string4;
        String string5 = uRL.getProtocol();
        element.setAttribute(ATTR_PROTOCOL, string5);
        String string6 = uRL.getUserInfo();
        if (string6 != null) {
            element.setAttribute(ATTR_USERINFO, uRL.getUserInfo());
        }
        if ((string4 = uRL.getHost()) != null && string4.length() > 0) {
            element.setAttribute(ATTR_HOST, string4);
        }
        if ((n = uRL.getPort()) >= 0) {
            element.setAttribute(ATTR_PORT, new Integer(n).toString());
        }
        if ((string3 = uRL.getPath()) != null) {
            element.setAttribute(ATTR_PATH, string3);
        }
        if ((string2 = uRL.getQuery()) != null) {
            element.setAttribute(ATTR_QUERY, string2);
        }
        if ((string = uRL.getRef()) != null) {
            element.setAttribute(ATTR_REF, string);
        }
    }

    private static final URL unmarshalAbsoluteURL(Node node, NamedNodeMap namedNodeMap) {
        String string = node.getNodeValue();
        String string2 = URL2Dom.getNodeValue(namedNodeMap.getNamedItem(ATTR_USERINFO));
        String string3 = URL2Dom.getNodeValue(namedNodeMap.getNamedItem(ATTR_HOST));
        int n = URL2Dom.getIntValue(namedNodeMap.getNamedItem(ATTR_PORT));
        String string4 = URL2Dom.getNodeValue(namedNodeMap.getNamedItem(ATTR_PATH));
        String string5 = URL2Dom.getNodeValue(namedNodeMap.getNamedItem(ATTR_QUERY));
        String string6 = URL2Dom.getNodeValue(namedNodeMap.getNamedItem(ATTR_REF));
        return URLFactory.newURL(string, string2, string3, n, string4, string5, string6);
    }

    private static final URL _getObjectURL(String string, String string2, URL uRL) {
        URL uRL2 = URL2Dom._getFileObjectURL(string, string2);
        if (uRL2 == null) {
            try {
                URL uRL3 = new URL(string);
                uRL2 = string2 != null ? URLFactory.newJarURL(uRL3, string2) : uRL3;
            }
            catch (MalformedURLException malformedURLException) {
                try {
                    URL uRL4 = URLFileSystem.getParent(uRL);
                    URL uRL5 = URLFactory.newURL(uRL4, string);
                    uRL2 = string2 != null ? URLFactory.newJarURL(uRL5, string2) : uRL5;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    uRL2 = null;
                }
            }
        }
        return uRL2;
    }

    private static final URL _getFileObjectURL(String string, String string2) {
        URL uRL = null;
        if (string.startsWith("file:")) {
            String string3 = string.substring(5);
            URL uRL2 = URLFactory.newFileURL(string3);
            uRL = string2 != null ? URLFactory.newJarURL(uRL2, string2) : uRL2;
        }
        return uRL;
    }

    URL2Dom() {
    }
}

